/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.exportgradle;

import com.android.ide.eclipse.adt.internal.wizards.exportgradle.ExportMessages;
import com.android.ide.eclipse.adt.internal.wizards.exportgradle.ProjectSetupBuilder;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ProjectSelectionPage
extends WizardPage {
    private final ProjectSetupBuilder mBuilder;
    private CheckboxTableViewer mTableViewer;
    private List<IJavaProject> mSelectedJavaProjects = Lists.newArrayList();

    public ProjectSelectionPage(ProjectSetupBuilder builder) {
        super("GradleExportPage");
        this.mBuilder = builder;
        this.setPageComplete(false);
        this.setTitle(ExportMessages.PageTitle);
        this.setDescription(ExportMessages.PageDescription);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        Label title = new Label(workArea, 0);
        title.setText(ExportMessages.SelectProjects);
        Composite listComposite = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        listComposite.setLayout((Layout)layout);
        listComposite.setLayoutData((Object)new GridData(1808));
        Table table = new Table(listComposite, 2848);
        this.mTableViewer = new CheckboxTableViewer(table);
        table.setLayout((Layout)new TableLayout());
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 300;
        table.setLayoutData((Object)data);
        this.mTableViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider(){

            public Object[] getElements(Object element) {
                if (element instanceof IJavaProject[]) {
                    return (IJavaProject[])element;
                }
                return null;
            }
        });
        this.mTableViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.mTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    ProjectSelectionPage.this.mSelectedJavaProjects.add((IJavaProject)event.getElement());
                } else {
                    ProjectSelectionPage.this.mSelectedJavaProjects.remove(event.getElement());
                }
                ProjectSelectionPage.this.updateEnablement();
            }
        });
        this.initializeProjects();
        this.createSelectionButtons(listComposite);
        this.setControl((Control)workArea);
        this.updateEnablement();
        Dialog.applyDialogFont((Control)parent);
    }

    private void createSelectionButtons(Composite composite) {
        Composite buttonsComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(2));
        Button selectAll = new Button(buttonsComposite, 8);
        selectAll.setText(ExportMessages.SelectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < ProjectSelectionPage.this.mTableViewer.getTable().getItemCount()) {
                    ProjectSelectionPage.this.mSelectedJavaProjects.add((IJavaProject)ProjectSelectionPage.this.mTableViewer.getElementAt(i));
                    ++i;
                }
                ProjectSelectionPage.this.mTableViewer.setAllChecked(true);
                ProjectSelectionPage.this.updateEnablement();
            }
        });
        this.setButtonLayoutData(selectAll);
        Button deselectAll = new Button(buttonsComposite, 8);
        deselectAll.setText(ExportMessages.DeselectAll);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectSelectionPage.this.mSelectedJavaProjects.clear();
                ProjectSelectionPage.this.mTableViewer.setAllChecked(false);
                ProjectSelectionPage.this.updateEnablement();
            }
        });
        this.setButtonLayoutData(deselectAll);
    }

    private void initializeProjects() {
        IJavaProject[] javaProjects;
        IWorkspaceRoot rootWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)rootWorkspace);
        try {
            javaProjects = javaModel.getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            javaProjects = new IJavaProject[]{};
        }
        this.mTableViewer.setInput((Object)javaProjects);
        if (this.mSelectedJavaProjects != null) {
            this.mTableViewer.setCheckedElements((Object[])this.mSelectedJavaProjects.toArray(new IJavaProject[this.mSelectedJavaProjects.size()]));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateEnablement() {
        block8: {
            block7: {
                error = null;
                if (this.mSelectedJavaProjects.size() != 0) break block7;
                error = ExportMessages.NoProjectsError;
lbl-1000:
                // 4 sources

                {
                    catch (Throwable var3_3) {
                        this.setErrorMessage(error);
                        this.setPageComplete(error == null);
                        this.getContainer().updateButtons();
                        throw var3_3;
                    }
                }
                this.setErrorMessage(error);
                this.setPageComplete(error == null);
                this.getContainer().updateButtons();
                return;
            }
            cyclicProjects = this.getCyclicProjects(this.mSelectedJavaProjects);
            if (cyclicProjects.size() <= 0) break block8;
            error = MessageFormat.format((String)ExportMessages.CyclicProjectsError, (Object[])new Object[]{Joiner.on((String)", ").join(cyclicProjects)});
            this.setErrorMessage(error);
            this.setPageComplete(error == null);
            this.getContainer().updateButtons();
            return;
        }
        try {
            error = this.mBuilder.setProject(this.mSelectedJavaProjects);
            ** if (error == null) goto lbl-1000
        }
        catch (CoreException v0) {
            ** try [egrp 3[TRYBLOCK] [5 : 160->164)] { 
            {
            }
        }
lbl-1000:
        // 1 sources

        {
            this.setErrorMessage(error);
            this.setPageComplete(error == null);
            this.getContainer().updateButtons();
            return;
        }
lbl-1000:
        // 1 sources

        {
        }
lbl35:
        // 2 sources

        this.setErrorMessage(error);
        this.setPageComplete(error == null);
        this.getContainer().updateButtons();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.mTableViewer.getTable().setFocus();
            this.mBuilder.setCanFinish(false);
            this.mBuilder.setCanGenerate(false);
        }
    }

    private List<String> getCyclicProjects(List<IJavaProject> projects) throws CoreException {
        ArrayList<String> cyclicProjects = new ArrayList<String>();
        for (IJavaProject javaProject : projects) {
            if (!ProjectSelectionPage.hasCyclicDependency(javaProject)) continue;
            cyclicProjects.add(javaProject.getProject().getName());
        }
        return cyclicProjects;
    }

    private static boolean hasCyclicDependency(IJavaProject javaProject) throws CoreException {
        IMarker[] markers;
        IMarker[] iMarkerArray = markers = javaProject.getProject().findMarkers("org.eclipse.jdt.core.buildpath_problem", false, 1);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            String cycleAttr = (String)marker.getAttribute("cycleDetected");
            if (cycleAttr != null && cycleAttr.equals("true")) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

