/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.newproject;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.xml.AndroidManifestParser;
import com.android.ide.common.xml.ManifestData;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.DomUtilities;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.io.FolderWrapper;
import com.android.io.IAbstractFolder;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.project.ProjectProperties;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class ImportedProject {
    private final File mLocation;
    private String mActivityName;
    private ManifestData mManifest;
    private String mProjectName;
    private String mRelativePath;

    ImportedProject(File location, String relativePath) {
        this.mLocation = location;
        this.mRelativePath = relativePath;
    }

    File getLocation() {
        return this.mLocation;
    }

    String getRelativePath() {
        return this.mRelativePath;
    }

    @Nullable
    ManifestData getManifest() {
        if (this.mManifest == null) {
            try {
                this.mManifest = AndroidManifestParser.parse((IAbstractFolder)new FolderWrapper(this.mLocation));
            }
            catch (SAXException e) {
                AdtPlugin.log(e, null, new Object[0]);
                return null;
            }
            catch (Exception e) {
                AdtPlugin.log(e, null, new Object[0]);
                return null;
            }
        }
        return this.mManifest;
    }

    @Nullable
    public String getActivityName() {
        ManifestData manifest;
        if (this.mActivityName == null && (manifest = this.getManifest()) != null) {
            if (manifest.getLauncherActivity() != null) {
                this.mActivityName = manifest.getLauncherActivity().getName();
            }
            if (this.mActivityName == null || this.mActivityName.isEmpty()) {
                ManifestData.Activity[] activities;
                ManifestData.Activity[] activityArray = activities = manifest.getActivities();
                int n = activities.length;
                int n2 = 0;
                while (n2 < n) {
                    ManifestData.Activity activity = activityArray[n2];
                    this.mActivityName = activity.getName();
                    if (this.mActivityName != null && !this.mActivityName.isEmpty()) break;
                    ++n2;
                }
            }
            if (this.mActivityName != null) {
                int index = this.mActivityName.lastIndexOf(46);
                this.mActivityName = this.mActivityName.substring(index + 1);
            }
        }
        return this.mActivityName;
    }

    @NonNull
    public String getProjectName() {
        if (this.mProjectName == null) {
            this.mProjectName = this.findEclipseProjectName();
            if (this.mProjectName != null) {
                return this.mProjectName;
            }
            String activityName = this.getActivityName();
            if (activityName == null || activityName.isEmpty()) {
                this.mProjectName = this.mLocation.getName();
            } else {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IStatus nameStatus = workspace.validateName(activityName, 4);
                if (nameStatus.isOK()) {
                    this.mProjectName = activityName;
                } else {
                    StringBuilder sb = new StringBuilder();
                    int i = 0;
                    int n = activityName.length();
                    while (i < n) {
                        char c = activityName.charAt(i);
                        if (c != ':' && c != '/' && c != '\\') {
                            sb.append(c);
                        }
                        ++i;
                    }
                    this.mProjectName = sb.length() == 0 ? this.mLocation.getName() : sb.toString();
                }
            }
        }
        return this.mProjectName;
    }

    @Nullable
    private String findEclipseProjectName() {
        File projectFile = new File(this.mLocation, ".project");
        if (projectFile.exists()) {
            try {
                Node nameElement;
                String name;
                NodeList names;
                String xml = Files.toString((File)projectFile, (Charset)Charsets.UTF_8);
                Document doc = DomUtilities.parseDocument(xml, false);
                if (doc != null && (names = doc.getElementsByTagName("name")).getLength() >= 1 && !(name = (nameElement = names.item(0)).getTextContent().trim()).isEmpty()) {
                    return name;
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public void setProjectName(@NonNull String newName) {
        this.mProjectName = newName;
    }

    public IAndroidTarget getTarget() {
        IAndroidTarget t;
        int n;
        int n2;
        IAndroidTarget[] iAndroidTargetArray;
        Matcher m;
        String targetProperty;
        IAndroidTarget[] targets = Sdk.getCurrent().getTargets();
        ProjectProperties properties = ProjectProperties.load((String)this.mLocation.getPath(), (ProjectProperties.PropertyType)ProjectProperties.PropertyType.PROJECT);
        if (properties != null && (targetProperty = properties.getProperty("target")) != null && (m = Pattern.compile("android-(.+)").matcher(targetProperty.trim())).matches()) {
            int targetLevel;
            String targetName = m.group(1);
            try {
                targetLevel = Integer.parseInt(targetName);
            }
            catch (NumberFormatException numberFormatException) {
                targetLevel = -1;
            }
            iAndroidTargetArray = targets;
            n2 = targets.length;
            n = 0;
            while (n < n2) {
                t = iAndroidTargetArray[n];
                AndroidVersion version = t.getVersion();
                if (version.isPreview() && targetName.equals(version.getCodename())) {
                    return t;
                }
                if (targetLevel == version.getApiLevel()) {
                    return t;
                }
                ++n;
            }
            if (targetLevel > 0) {
                IAndroidTarget target = targets[targets.length - 1];
                int targetDelta = target.getVersion().getApiLevel() - targetLevel;
                IAndroidTarget[] iAndroidTargetArray2 = targets;
                int version = targets.length;
                int n3 = 0;
                while (n3 < version) {
                    IAndroidTarget t2 = iAndroidTargetArray2[n3];
                    int newDelta = t2.getVersion().getApiLevel() - targetLevel;
                    if (newDelta >= 0 && newDelta < targetDelta) {
                        targetDelta = newDelta;
                        target = t2;
                    }
                    ++n3;
                }
                return target;
            }
        }
        IAndroidTarget target = targets[targets.length - 1];
        ManifestData manifest = this.getManifest();
        if (manifest != null) {
            int minSdkLevel = manifest.getMinSdkVersion();
            int targetDelta = target.getVersion().getApiLevel() - minSdkLevel;
            iAndroidTargetArray = targets;
            n2 = targets.length;
            n = 0;
            while (n < n2) {
                t = iAndroidTargetArray[n];
                int newDelta = t.getVersion().getApiLevel() - minSdkLevel;
                if (newDelta >= 0 && newDelta < targetDelta) {
                    targetDelta = newDelta;
                    target = t;
                }
                ++n;
            }
        }
        return target;
    }
}

