/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.newproject;

import com.android.annotations.Nullable;
import com.android.ide.common.sdk.LoadStatus;
import com.android.ide.common.xml.AndroidManifestParser;
import com.android.ide.common.xml.ManifestData;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.ide.eclipse.adt.internal.wizards.newproject.NewProjectWizardState;
import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkManager;
import com.android.sdkuilib.internal.widgets.SdkTargetSelector;
import com.android.utils.NullLogger;
import com.android.utils.Pair;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

class SdkSelectionPage
extends WizardPage
implements Sdk.ITargetChangeListener {
    private final NewProjectWizardState mValues;
    private boolean mIgnore;
    private SdkTargetSelector mSdkTargetSelector;

    SdkSelectionPage(NewProjectWizardState values) {
        super("sdkSelection");
        this.mValues = values;
        this.setTitle("Select Build Target");
        AdtPlugin.getDefault().addTargetListener(this);
    }

    public void dispose() {
        AdtPlugin.getDefault().removeTargetListener(this);
        super.dispose();
    }

    public void createControl(Composite parent) {
        Group group = new Group(parent, 16);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(1808));
        group.setFont(parent.getFont());
        group.setText("Build Target");
        this.mSdkTargetSelector = new SdkTargetSelector((Composite)group, null);
        this.mSdkTargetSelector.setSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SdkSelectionPage.this.mIgnore) {
                    return;
                }
                ((SdkSelectionPage)SdkSelectionPage.this).mValues.target = SdkSelectionPage.this.mSdkTargetSelector.getSelected();
                ((SdkSelectionPage)SdkSelectionPage.this).mValues.targetModifiedByUser = true;
                SdkSelectionPage.this.onSdkTargetModified();
                SdkSelectionPage.this.validatePage();
            }
        });
        this.onSdkLoaded();
        this.setControl((Control)group);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.mValues.mode == NewProjectWizardState.Mode.SAMPLE) {
            this.setDescription("Choose an SDK to select a sample from");
        } else {
            this.setDescription("Choose an SDK to target");
        }
        try {
            this.mIgnore = true;
            if (this.mValues.target != null) {
                this.mSdkTargetSelector.setSelection(this.mValues.target);
            }
        }
        finally {
            this.mIgnore = false;
        }
        this.validatePage();
    }

    public boolean isPageComplete() {
        if (this.mValues.target == null) {
            return false;
        }
        return super.isPageComplete();
    }

    private void onSdkTargetModified() {
        if (this.mIgnore) {
            return;
        }
        IAndroidTarget target = this.mValues.target;
        if (target != null) {
            boolean setMinSdk = false;
            AndroidVersion version = target.getVersion();
            int apiLevel = version.getApiLevel();
            if (!this.mValues.minSdkModifiedByUser) {
                setMinSdk = true;
            } else {
                String s = this.mValues.minSdk;
                if (s.length() > 0) {
                    try {
                        int currentApi = Integer.parseInt(s);
                        if (currentApi > apiLevel) {
                            setMinSdk = true;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            if (setMinSdk) {
                String minSdk = version.isPreview() ? version.getCodename() : Integer.toString(apiLevel);
                this.mValues.minSdk = minSdk;
            }
        }
        this.loadSamplesForTarget(target);
    }

    private void loadSamplesForTarget(IAndroidTarget target) {
        File previouslyChosenSample = this.mValues.chosenSample;
        this.mValues.samples.clear();
        this.mValues.chosenSample = null;
        if (target != null) {
            String samplesRootPath = target.getPath(4);
            File root = new File(samplesRootPath);
            this.findSamplesManifests(root, root, null, null, this.mValues.samples);
            Sdk sdk = Sdk.getCurrent();
            if (sdk != null) {
                SdkManager sdkman = sdk.getNewSdkManager(NullLogger.getLogger());
                Map extras = sdkman.getExtraSamples();
                for (Map.Entry entry : extras.entrySet()) {
                    File path = (File)entry.getKey();
                    String name = (String)entry.getValue();
                    if (path.getName().equals("sample")) {
                        this.findSampleManifestInDir(path, path, name, target.getVersion(), this.mValues.samples);
                    }
                    this.findSamplesManifests(path, path, name, target.getVersion(), this.mValues.samples);
                }
            }
            if (this.mValues.samples.isEmpty()) {
                return;
            }
            Collections.sort(this.mValues.samples, new Comparator<Pair<String, File>>(){

                @Override
                public int compare(Pair<String, File> o1, Pair<String, File> o2) {
                    return ((String)o1.getFirst()).compareTo((String)o2.getFirst());
                }
            });
            if (previouslyChosenSample != null) {
                String previouslyChosenName = previouslyChosenSample.getName();
                int i = 0;
                int n = this.mValues.samples.size();
                while (i < n) {
                    File file = (File)this.mValues.samples.get(i).getSecond();
                    if (file.getName().equals(previouslyChosenName)) {
                        this.mValues.chosenSample = file;
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private void findSamplesManifests(File rootDir, File currDir, @Nullable String extraName, @Nullable AndroidVersion targetVersion, List<Pair<String, File>> samplesPaths) {
        if (!currDir.isDirectory()) {
            return;
        }
        File[] fileArray = currDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                this.findSampleManifestInDir(f, rootDir, extraName, targetVersion, samplesPaths);
                String leaf = f.getName();
                if (!("src".equals(leaf) || "assets".equals(leaf) || "res".equals(leaf))) {
                    this.findSamplesManifests(rootDir, f, extraName, targetVersion, samplesPaths);
                }
            }
            ++n2;
        }
    }

    private void findSampleManifestInDir(File sampleDir, File rootDir, String extraName, AndroidVersion targetVersion, List<Pair<String, File>> samplesPaths) {
        File manifestFile = new File(sampleDir, "AndroidManifest.xml");
        if (manifestFile.isFile()) {
            try {
                ManifestData data = AndroidManifestParser.parse((IAbstractFile)new FileWrapper(manifestFile));
                if (data != null) {
                    boolean accept = false;
                    if (targetVersion == null) {
                        accept = true;
                    } else if (targetVersion != null) {
                        int i = data.getMinSdkVersion();
                        if (i != 0) {
                            accept = i <= targetVersion.getApiLevel();
                        } else {
                            String s = data.getMinSdkVersionString();
                            if (s != null) {
                                accept = s.equals(targetVersion.getCodename());
                            }
                        }
                    }
                    if (accept) {
                        String name = this.getSampleDisplayName(extraName, rootDir, sampleDir);
                        samplesPaths.add((Pair<String, File>)Pair.of((Object)name, (Object)sampleDir));
                    }
                }
            }
            catch (Exception exception) {
                AdtPlugin.log(1, "NPW ignoring malformed manifest %s", manifestFile.getAbsolutePath());
            }
        }
    }

    private String getSampleDisplayName(String extraName, File rootDir, File sampleDir) {
        String name = null;
        if (!rootDir.equals(sampleDir)) {
            String path = sampleDir.getPath();
            int n = rootDir.getPath().length();
            if (path.length() > n) {
                if ((path = path.substring(n)).charAt(0) == File.separatorChar) {
                    path = path.substring(1);
                }
                if (path.endsWith(File.separator)) {
                    path = path.substring(0, path.length() - 1);
                }
                name = path.replaceAll(Pattern.quote(File.separator), " > ");
            }
        }
        if (name == null && rootDir.equals(sampleDir) && sampleDir.getName().equals("sample") && extraName != null) {
            return extraName;
        }
        if (name == null) {
            while (sampleDir != null && (name == null || "sample".equals(name) || "samples".equals(name))) {
                name = sampleDir.getName();
                sampleDir = sampleDir.getParentFile();
            }
        }
        if (name == null) {
            if (extraName != null) {
                return extraName;
            }
            name = "Sample";
        }
        if (extraName != null) {
            name = String.valueOf(name) + " [" + extraName + ']';
        }
        return name;
    }

    private void validatePage() {
        String error = null;
        if (AdtPlugin.getDefault().getSdkLoadStatus() == LoadStatus.LOADING) {
            error = "The SDK is still loading; please wait.";
        }
        if (error == null && this.mValues.target == null) {
            error = "An SDK Target must be specified.";
        }
        if (error == null && this.mValues.mode == NewProjectWizardState.Mode.SAMPLE && (this.mValues.samples == null || this.mValues.samples.size() == 0)) {
            error = "This target has no samples. Please select another target.";
        }
        this.setPageComplete(error == null);
        if (error != null) {
            this.setMessage(error, 3);
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
        }
    }

    @Override
    public void onSdkLoaded() {
        if (this.mSdkTargetSelector == null) {
            return;
        }
        IAndroidTarget[] targets = null;
        if (Sdk.getCurrent() != null) {
            targets = Sdk.getCurrent().getTargets();
        }
        this.mSdkTargetSelector.setTargets(targets);
        if (targets != null && targets.length == 1) {
            this.mValues.target = targets[0];
            this.mSdkTargetSelector.setSelection(this.mValues.target);
            this.onSdkTargetModified();
        } else if (targets != null) {
            IAndroidTarget initialTarget = null;
            IAndroidTarget[] iAndroidTargetArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                IAndroidTarget target = iAndroidTargetArray[n2];
                if (target.isPlatform() && !target.getVersion().isPreview() && (initialTarget == null || target.getVersion().getApiLevel() > initialTarget.getVersion().getApiLevel())) {
                    initialTarget = target;
                }
                ++n2;
            }
            if (initialTarget != null) {
                this.mValues.target = initialTarget;
                try {
                    this.mIgnore = true;
                    this.mSdkTargetSelector.setSelection(this.mValues.target);
                }
                finally {
                    this.mIgnore = false;
                }
                this.onSdkTargetModified();
            }
        }
        this.validatePage();
    }

    @Override
    public void onProjectTargetChange(IProject changedProject) {
    }

    @Override
    public void onTargetLoaded(IAndroidTarget target) {
    }
}

