/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.newproject;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;

public final class WorkingSetHelper {
    private static final IWorkingSet[] EMPTY_WORKING_SET_ARRAY = new IWorkingSet[0];

    private WorkingSetHelper() {
    }

    public static IWorkingSet[] getSelectedWorkingSet(IStructuredSelection selection, IWorkbenchPart activePart) {
        IWorkingSet[] selected = WorkingSetHelper.getSelectedWorkingSet(selection);
        if (selected != null && selected.length > 0) {
            int i = 0;
            while (i < selected.length) {
                if (!WorkingSetHelper.isValidWorkingSet(selected[i])) {
                    return EMPTY_WORKING_SET_ARRAY;
                }
                ++i;
            }
            return selected;
        }
        if (!(activePart instanceof PackageExplorerPart)) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        PackageExplorerPart explorerPart = (PackageExplorerPart)activePart;
        if (explorerPart.getRootMode() == 1) {
            IWorkingSet filterWorkingSet = explorerPart.getFilterWorkingSet();
            if (filterWorkingSet == null) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            if (!WorkingSetHelper.isValidWorkingSet(filterWorkingSet)) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            return new IWorkingSet[]{filterWorkingSet};
        }
        Object input = explorerPart.getViewPartInput();
        if (!(input instanceof IWorkingSet)) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        IWorkingSet workingSet = (IWorkingSet)input;
        if (!WorkingSetHelper.isValidWorkingSet(workingSet)) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        return new IWorkingSet[]{workingSet};
    }

    private static IWorkingSet[] getSelectedWorkingSet(IStructuredSelection selection) {
        if (!(selection instanceof ITreeSelection)) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        ITreeSelection treeSelection = (ITreeSelection)selection;
        if (treeSelection.isEmpty()) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        List elements = treeSelection.toList();
        if (elements.size() == 1) {
            Object element = elements.get(0);
            TreePath[] paths = treeSelection.getPathsFor(element);
            if (paths.length != 1) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            TreePath path = paths[0];
            if (path.getSegmentCount() == 0) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            Object candidate = path.getSegment(0);
            if (!(candidate instanceof IWorkingSet)) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            IWorkingSet workingSetCandidate = (IWorkingSet)candidate;
            if (WorkingSetHelper.isValidWorkingSet(workingSetCandidate)) {
                return new IWorkingSet[]{workingSetCandidate};
            }
            return EMPTY_WORKING_SET_ARRAY;
        }
        ArrayList result = new ArrayList();
        for (Object element : elements) {
            if (!(element instanceof IWorkingSet) || !WorkingSetHelper.isValidWorkingSet((IWorkingSet)element)) continue;
            result.add(element);
        }
        return result.toArray(new IWorkingSet[result.size()]);
    }

    private static boolean isValidWorkingSet(IWorkingSet workingSet) {
        String id = workingSet.getId();
        if (!"org.eclipse.jdt.ui.JavaWorkingSetPage".equals(id) && !"org.eclipse.ui.resourceWorkingSetPage".equals(id)) {
            return false;
        }
        return !workingSet.isAggregateWorkingSet();
    }
}

