/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.templates;

import com.android.annotations.NonNull;
import com.android.assetstudiolib.GraphicGenerator;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.actions.AddSupportJarAction;
import com.android.ide.eclipse.adt.internal.assetstudio.AssetType;
import com.android.ide.eclipse.adt.internal.assetstudio.ConfigureAssetSetPage;
import com.android.ide.eclipse.adt.internal.assetstudio.CreateAssetSetWizardState;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.project.ProjectHelper;
import com.android.ide.eclipse.adt.internal.wizards.newproject.NewProjectCreator;
import com.android.ide.eclipse.adt.internal.wizards.templates.ActivityPage;
import com.android.ide.eclipse.adt.internal.wizards.templates.InstallDependencyPage;
import com.android.ide.eclipse.adt.internal.wizards.templates.NewProjectPage;
import com.android.ide.eclipse.adt.internal.wizards.templates.NewProjectWizardState;
import com.android.ide.eclipse.adt.internal.wizards.templates.NewTemplatePage;
import com.android.ide.eclipse.adt.internal.wizards.templates.NewTemplateWizardState;
import com.android.ide.eclipse.adt.internal.wizards.templates.ProjectContentsPage;
import com.android.ide.eclipse.adt.internal.wizards.templates.TemplateHandler;
import com.android.ide.eclipse.adt.internal.wizards.templates.TemplateMetadata;
import com.android.ide.eclipse.adt.internal.wizards.templates.TemplateWizard;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IWorkbench;

public class NewProjectWizard
extends TemplateWizard {
    private static final String PARENT_ACTIVITY_CLASS = "parentActivityClass";
    private static final String ACTIVITY_TITLE = "activityTitle";
    static final String IS_LAUNCHER = "isLauncher";
    static final String IS_NEW_PROJECT = "isNewProject";
    static final String IS_LIBRARY_PROJECT = "isLibraryProject";
    static final String ATTR_COPY_ICONS = "copyIcons";
    static final String ATTR_TARGET_API = "targetApi";
    static final String ATTR_MIN_API = "minApi";
    static final String ATTR_MIN_BUILD_API = "minBuildApi";
    static final String ATTR_BUILD_API = "buildApi";
    static final String ATTR_REVISION = "revision";
    static final String ATTR_MIN_API_LEVEL = "minApiLevel";
    static final String ATTR_PACKAGE_NAME = "packageName";
    static final String ATTR_APP_TITLE = "appTitle";
    static final String CATEGORY_PROJECTS = "projects";
    static final String CATEGORY_ACTIVITIES = "activities";
    static final String CATEGORY_OTHER = "other";
    static final String ATTR_APP_COMPAT = "appCompat";
    public static final String DEFAULT_LAUNCHER_ICON = "launcher_icon";
    private NewProjectPage mMainPage;
    private ProjectContentsPage mContentsPage;
    private ActivityPage mActivityPage;
    private NewTemplatePage mTemplatePage;
    private NewProjectWizardState mValues;
    private IProject mProject;

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle("New Android Application");
        this.mValues = new NewProjectWizardState();
        this.mMainPage = new NewProjectPage(this.mValues);
        this.mContentsPage = new ProjectContentsPage(this.mValues);
        this.mContentsPage.init(selection, AdtUtils.getActivePart());
        this.mActivityPage = new ActivityPage(this.mValues, true, true);
        this.mActivityPage.setLauncherActivitiesOnly(true);
    }

    @Override
    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.mMainPage);
        this.addPage((IWizardPage)this.mContentsPage);
        this.addPage((IWizardPage)this.mActivityPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        TemplateMetadata template;
        if (page == this.mMainPage) {
            return this.mContentsPage;
        }
        if (page == this.mContentsPage) {
            if (this.mValues.createIcon) {
                CreateAssetSetWizardState iconState = this.mValues.iconState;
                iconState.type = AssetType.LAUNCHER;
                iconState.outputName = "ic_launcher";
                iconState.background = new RGB(255, 255, 255);
                iconState.foreground = new RGB(51, 182, 234);
                iconState.trim = true;
                iconState.sourceType = CreateAssetSetWizardState.SourceType.IMAGE;
                iconState.imagePath = new File(DEFAULT_LAUNCHER_ICON);
                iconState.shape = GraphicGenerator.Shape.NONE;
                iconState.padding = 0;
                WizardPage p = this.getIconPage(this.mValues.iconState);
                p.setTitle("Configure Launcher Icon");
                return p;
            }
            if (this.mValues.createActivity) {
                return this.mActivityPage;
            }
            return null;
        }
        if (page == this.mIconPage) {
            return this.mActivityPage;
        }
        if (page == this.mActivityPage && this.mValues.createActivity) {
            if (this.mTemplatePage == null) {
                NewTemplateWizardState activityValues = this.mValues.activityValues;
                activityValues.defaults.put("activityName", this.mValues.activityName);
                Set<String> hidden = activityValues.hidden;
                hidden.add(ATTR_PACKAGE_NAME);
                hidden.add(ATTR_APP_TITLE);
                hidden.add(ATTR_MIN_API);
                hidden.add(ATTR_MIN_API_LEVEL);
                hidden.add(ATTR_TARGET_API);
                hidden.add(ATTR_BUILD_API);
                hidden.add(IS_LAUNCHER);
                hidden.add(PARENT_ACTIVITY_CLASS);
                hidden.add(ACTIVITY_TITLE);
                this.mTemplatePage = new NewTemplatePage(activityValues, false);
                this.addPage((IWizardPage)this.mTemplatePage);
            }
            this.mTemplatePage.setCustomMinSdk(this.mValues.minSdkLevel, this.mValues.getBuildApi());
            return this.mTemplatePage;
        }
        if (page == this.mTemplatePage && (template = this.mValues.activityValues.getTemplateHandler().getTemplate()) != null && !InstallDependencyPage.isInstalled(template.getDependencies())) {
            return this.getDependencyPage(template, true);
        }
        if (page == this.mTemplatePage || !this.mValues.createActivity && page == this.mActivityPage || page == this.getDependencyPage(null, false)) {
            return null;
        }
        return super.getNextPage(page);
    }

    public boolean canFinish() {
        if (this.mValues.createIcon && (this.mIconPage == null || !this.mIconPage.isPageComplete())) {
            return false;
        }
        if (this.mValues.createActivity && (this.mTemplatePage == null || !this.mTemplatePage.isPageComplete())) {
            return false;
        }
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (!(page == this.mTemplatePage && !this.mValues.createActivity || page == this.mIconPage && !this.mValues.createIcon || page.isPageComplete())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    @NonNull
    protected IProject getProject() {
        return this.mProject;
    }

    @Override
    @NonNull
    protected List<String> getFilesToOpen() {
        return this.mValues.template.getFilesToOpen();
    }

    NewProjectWizardState getValues() {
        return this.mValues;
    }

    void setValues(NewProjectWizardState values) {
        this.mValues = values;
    }

    @Override
    protected List<Change> computeChanges() {
        TemplateHandler template = this.mValues.template;
        template.setBackupMergedFiles(false);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        this.addProjectInfo(paramMap);
        TemplateHandler.addDirectoryParameters(paramMap, this.getProject());
        if (this.mValues.createActivity && this.mValues.minSdkLevel < 14) {
            paramMap.put(ATTR_APP_COMPAT, true);
            this.getFinalizingActions().add(new Runnable(){

                @Override
                public void run() {
                    AddSupportJarAction.installAppCompatLibrary(NewProjectWizard.this.mProject, true);
                }
            });
        }
        return template.render(this.mProject, paramMap);
    }

    @Override
    protected boolean performFinish(final IProgressMonitor monitor) throws InvocationTargetException {
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            String name = this.mValues.projectName;
            this.mProject = root.getProject(name);
            final TemplateHandler template = this.mValues.template;
            template.setBackupMergedFiles(false);
            NewProjectCreator.ProjectPopulator projectPopulator = new NewProjectCreator.ProjectPopulator(){

                @Override
                public void populate(IProject project) throws InvocationTargetException {
                    File libFolder = new File(AdtPlugin.getOsSdkToolsFolder(), "lib");
                    try {
                        if (!$assertionsDisabled && project != NewProjectWizard.this.mProject) {
                            throw new AssertionError();
                        }
                        NewProjectCreator.addLocalFile(project, new File(libFolder, "proguard-project.txt"), "proguard-project.txt", (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception e) {
                        AdtPlugin.log(e, null, new Object[0]);
                    }
                    try {
                        NewProjectWizard.this.mProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        AdtPlugin.log(e, null, new Object[0]);
                    }
                    List<Change> changes = NewProjectWizard.this.computeChanges();
                    if (!changes.isEmpty()) {
                        monitor.beginTask("Creating project...", changes.size());
                        try {
                            try {
                                CompositeChange composite = new CompositeChange("", changes.toArray(new Change[changes.size()]));
                                composite.perform(monitor);
                            }
                            catch (CoreException e) {
                                AdtPlugin.log(e, null, new Object[0]);
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                    if (((NewProjectWizard)NewProjectWizard.this).mValues.createIcon) {
                        NewProjectWizard.this.generateIcons(NewProjectWizard.this.mProject);
                    }
                    if (((NewProjectWizard)NewProjectWizard.this).mValues.createActivity) {
                        TemplateHandler activityTemplate = ((NewProjectWizard)NewProjectWizard.this).mValues.activityValues.getTemplateHandler();
                        activityTemplate.setBackupMergedFiles(false);
                        NewProjectWizard.this.generateActivity(template, project, monitor);
                    }
                }
            };
            NewProjectCreator.create(monitor, this.mProject, this.mValues.target, projectPopulator, this.mValues.isLibrary, this.mValues.projectLocation, this.mValues.workingSets);
            IJavaProject javaProject = BaseProjectHelper.getJavaProject(this.mProject);
            if (javaProject != null) {
                ProjectHelper.enforcePreferredCompilerCompliance(javaProject);
            }
            try {
                this.mProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                AdtPlugin.log(e, null, new Object[0]);
            }
            List<Runnable> finalizingTasks = this.getFinalizingActions();
            for (Runnable r : finalizingTasks) {
                r.run();
            }
            return true;
        }
        catch (Exception ioe) {
            AdtPlugin.log(ioe, null, new Object[0]);
            return false;
        }
    }

    private void generateIcons(IProject newProject) {
        assert (this.mValues.createIcon);
        ConfigureAssetSetPage.generateIcons(newProject, this.mValues.iconState, false, this.mIconPage);
    }

    private void generateActivity(TemplateHandler projectTemplate, IProject project, IProgressMonitor monitor) throws InvocationTargetException {
        assert (this.mValues.createActivity);
        NewTemplateWizardState activityValues = this.mValues.activityValues;
        Map<String, Object> parameters = activityValues.parameters;
        this.addProjectInfo(parameters);
        parameters.put(IS_NEW_PROJECT, true);
        parameters.put(IS_LIBRARY_PROJECT, this.mValues.isLibrary);
        parameters.put(IS_LAUNCHER, true);
        TemplateHandler.addDirectoryParameters(parameters, project);
        TemplateHandler activityTemplate = activityValues.getTemplateHandler();
        activityTemplate.setBackupMergedFiles(false);
        List<Change> changes = activityTemplate.render(project, parameters);
        if (!changes.isEmpty()) {
            monitor.beginTask("Creating template...", changes.size());
            try {
                try {
                    CompositeChange composite = new CompositeChange("", changes.toArray(new Change[changes.size()]));
                    composite.perform(monitor);
                }
                catch (CoreException e) {
                    AdtPlugin.log(e, null, new Object[0]);
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
            }
        }
        List<String> filesToOpen = activityTemplate.getFilesToOpen();
        projectTemplate.getFilesToOpen().addAll(filesToOpen);
        List<Runnable> finalizingActions = activityTemplate.getFinalizingActions();
        projectTemplate.getFinalizingActions().addAll(finalizingActions);
    }

    private void addProjectInfo(Map<String, Object> parameters) {
        parameters.put(ATTR_PACKAGE_NAME, this.mValues.packageName);
        parameters.put(ATTR_APP_TITLE, this.mValues.applicationName);
        parameters.put(ATTR_MIN_API, this.mValues.minSdk);
        parameters.put(ATTR_MIN_API_LEVEL, this.mValues.minSdkLevel);
        parameters.put(ATTR_TARGET_API, this.mValues.targetSdkLevel);
        parameters.put(ATTR_BUILD_API, this.mValues.target.getVersion().getApiLevel());
        parameters.put(ATTR_COPY_ICONS, !this.mValues.createIcon);
        parameters.putAll(this.mValues.parameters);
    }

    @Override
    @NonNull
    protected List<Runnable> getFinalizingActions() {
        return this.mValues.template.getFinalizingActions();
    }
}

