/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.templates;

import com.android.annotations.NonNull;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.wizards.templates.InstallDependencyPage;
import com.android.ide.eclipse.adt.internal.wizards.templates.NewTemplatePage;
import com.android.ide.eclipse.adt.internal.wizards.templates.NewTemplateWizardState;
import com.android.ide.eclipse.adt.internal.wizards.templates.TemplateHandler;
import com.android.ide.eclipse.adt.internal.wizards.templates.TemplateManager;
import com.android.ide.eclipse.adt.internal.wizards.templates.TemplateMetadata;
import com.android.ide.eclipse.adt.internal.wizards.templates.TemplateWizard;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewTemplateWizard
extends TemplateWizard {
    static final String BLANK_ACTIVITY = "activities/BlankActivity";
    static final String CUSTOM_VIEW = "other/CustomView";
    protected NewTemplatePage mMainPage;
    protected NewTemplateWizardState mValues;
    private final String mTemplateName;

    NewTemplateWizard(String templateName) {
        this.mTemplateName = templateName;
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.mValues = new NewTemplateWizardState();
        File template = TemplateManager.getTemplateLocation(this.mTemplateName);
        if (template != null) {
            this.mValues.setTemplateLocation(template);
        }
        this.hideBuiltinParameters();
        List<IProject> projects = AdtUtils.getSelectedProjects((ISelection)selection);
        if (projects.size() == 1) {
            this.mValues.project = projects.get(0);
        }
        this.mMainPage = new NewTemplatePage(this.mValues, true);
    }

    @Override
    protected boolean shouldAddIconPage() {
        return this.mValues.getIconState() != null;
    }

    protected void hideBuiltinParameters() {
        Set<String> hidden = this.mValues.hidden;
        hidden.add("packageName");
        hidden.add("minApi");
        hidden.add("minApiLevel");
        hidden.add("targetApi");
        hidden.add("buildApi");
    }

    @Override
    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.mMainPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        TemplateMetadata template = this.mValues.getTemplateHandler().getTemplate();
        if (page == this.mMainPage && this.shouldAddIconPage()) {
            WizardPage iconPage = this.getIconPage(this.mValues.getIconState());
            this.mValues.updateIconState(this.mMainPage.getEvaluator());
            return iconPage;
        }
        if (page == this.mMainPage || this.shouldAddIconPage() && page == this.getIconPage(this.mValues.getIconState())) {
            if (template != null) {
                if (InstallDependencyPage.isInstalled(template.getDependencies())) {
                    return this.getPreviewPage(this.mValues);
                }
                return this.getDependencyPage(template, true);
            }
        } else if (page == this.getDependencyPage(template, false)) {
            return this.getPreviewPage(this.mValues);
        }
        return super.getNextPage(page);
    }

    @Override
    @NonNull
    protected IProject getProject() {
        return this.mValues.project;
    }

    @Override
    @NonNull
    protected List<String> getFilesToOpen() {
        TemplateHandler activityTemplate = this.mValues.getTemplateHandler();
        return activityTemplate.getFilesToOpen();
    }

    @Override
    @NonNull
    protected List<Runnable> getFinalizingActions() {
        TemplateHandler activityTemplate = this.mValues.getTemplateHandler();
        return activityTemplate.getFinalizingActions();
    }

    @Override
    protected List<Change> computeChanges() {
        return this.mValues.computeChanges();
    }

    public static void openFiles(final @NonNull IProject project, final @NonNull List<String> relativePaths, final @NonNull IWorkbench mWorkbench) {
        if (!relativePaths.isEmpty()) {
            AdtPlugin.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (String path : relativePaths) {
                        boolean isLast;
                        IResource resource = project.findMember(path);
                        if (resource == null) continue;
                        if (resource instanceof IFile) {
                            try {
                                AdtPlugin.openFile((IFile)resource, null, false);
                            }
                            catch (PartInitException e) {
                                AdtPlugin.log(e, "Failed to open %1$s", resource.getFullPath().toString());
                            }
                        }
                        boolean bl = isLast = relativePaths.size() == 1 || path.equals(relativePaths.get(relativePaths.size() - 1));
                        if (!isLast) continue;
                        BasicNewResourceWizard.selectAndReveal((IResource)resource, (IWorkbenchWindow)mWorkbench.getActiveWorkbenchWindow());
                    }
                }
            });
        }
    }

    public static class NewCustomViewWizard
    extends NewTemplateWizard {
        public NewCustomViewWizard() {
            super(NewTemplateWizard.CUSTOM_VIEW);
        }

        @Override
        public void init(IWorkbench workbench, IStructuredSelection selection) {
            super.init(workbench, selection);
            this.setWindowTitle("New Custom View");
            this.mMainPage.setTitle("New Custom View");
            this.mMainPage.setDescription("Creates a new custom view");
        }
    }
}

