/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public abstract class AbstractBreakpointRulerAction
extends Action
implements IUpdate {
    private final IWorkbenchPart fTargetPart;
    private final IVerticalRulerInfo fRulerInfo;

    public AbstractBreakpointRulerAction(IWorkbenchPart part, IVerticalRulerInfo info) {
        Assert.isTrue((boolean)(part instanceof ITextEditor));
        this.fTargetPart = part;
        this.fRulerInfo = info;
    }

    protected IBreakpoint getBreakpoint() {
        IAnnotationModel annotationModel = this.getAnnotationModel();
        IDocument document = this.getDocument();
        if (annotationModel != null) {
            Iterator iterator = annotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof SimpleMarkerAnnotation)) continue;
                SimpleMarkerAnnotation markerAnnotation = (SimpleMarkerAnnotation)object;
                IMarker marker = markerAnnotation.getMarker();
                try {
                    IBreakpoint breakpoint;
                    Position position;
                    int line;
                    if (!marker.isSubtypeOf(IBreakpoint.BREAKPOINT_MARKER) || (line = document.getLineOfOffset((position = annotationModel.getPosition((Annotation)markerAnnotation)).getOffset())) != this.fRulerInfo.getLineOfLastMouseButtonActivity() || (breakpoint = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker)) == null) continue;
                    return breakpoint;
                }
                catch (CoreException coreException) {
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        return null;
    }

    protected IWorkbenchPart getTargetPart() {
        return this.fTargetPart;
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.fRulerInfo;
    }

    private IDocument getDocument() {
        ITextEditor textEditor;
        IDocumentProvider provider;
        IWorkbenchPart targetPart = this.getTargetPart();
        if (targetPart instanceof ITextEditor && (provider = (textEditor = (ITextEditor)targetPart).getDocumentProvider()) != null) {
            return provider.getDocument((Object)textEditor.getEditorInput());
        }
        return null;
    }

    private IAnnotationModel getAnnotationModel() {
        ITextEditor textEditor;
        IDocumentProvider provider;
        IWorkbenchPart targetPart = this.getTargetPart();
        if (targetPart instanceof ITextEditor && (provider = (textEditor = (ITextEditor)targetPart).getDocumentProvider()) != null) {
            return provider.getAnnotationModel((Object)textEditor.getEditorInput());
        }
        return null;
    }
}

