/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.IModuleRetrieval;
import org.eclipse.cdt.debug.internal.ui.actions.AbstractViewActionDelegate;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jface.action.IAction;

public class LoadSymbolsForAllActionDelegate
extends AbstractViewActionDelegate {
    protected String getErrorDialogTitle() {
        return ActionMessages.getString("LoadSymbolsForAllActionDelegate.Error_1");
    }

    protected String getErrorDialogMessage() {
        return ActionMessages.getString("LoadSymbolsForAllActionDelegate.Error(s)_occurred_loading_the_symbols_1");
    }

    protected void doAction() throws DebugException {
        IModuleRetrieval mr;
        ICDebugTarget target = this.getDebugTarget(this.getView().getViewer().getInput());
        if (target != null && (mr = (IModuleRetrieval)target.getAdapter(IModuleRetrieval.class)) != null) {
            DebugPlugin.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        mr.loadSymbolsForAllModules();
                    }
                    catch (DebugException e) {
                        LoadSymbolsForAllActionDelegate.this.failed(e);
                    }
                }
            });
        }
    }

    protected void update() {
        IAction action = this.getAction();
        if (this.getView() != null && this.getView().getViewer() != null && action != null) {
            ICDebugTarget target = this.getDebugTarget(this.getView().getViewer().getInput());
            action.setEnabled(target != null ? target.isSuspended() : false);
        }
    }

    protected void doHandleDebugEvent(DebugEvent event) {
    }

    private ICDebugTarget getDebugTarget(Object element) {
        if (element instanceof IAdaptable) {
            return (ICDebugTarget)((IAdaptable)element).getAdapter(ICDebugTarget.class);
        }
        return null;
    }

    protected void failed(Throwable e) {
        MultiStatus ms = new MultiStatus(CDIDebugModel.getPluginIdentifier(), 10002, ActionMessages.getString("LoadSymbolsForAllActionDelegate.0"), null);
        ms.add((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), 10002, e.getMessage(), e));
        CDebugUtils.error((IStatus)ms, (Object)((Object)this));
    }
}

