/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.actions;

import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.debug.core.commands.ITerminateHandler;

public class DsfTerminateCommand
implements ITerminateHandler {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;

    public DsfTerminateCommand(DsfSession session) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public void canExecute(final IEnabledStateRequest request) {
        if (request.getElements().length != 1 || !(request.getElements()[0] instanceof IDMVMContext)) {
            request.setEnabled(false);
            request.done();
            return;
        }
        IDMVMContext vmc = (IDMVMContext)request.getElements()[0];
        final IProcesses.IProcessDMContext processDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)vmc.getDMContext(), IProcesses.IProcessDMContext.class);
        if (processDmc == null) {
            request.setEnabled(false);
            request.done();
            return;
        }
        try {
            this.fExecutor.execute((Runnable)new DsfRunnable(){

                public void run() {
                    IProcesses procService = (IProcesses)DsfTerminateCommand.this.fTracker.getService(IProcesses.class);
                    if (procService == null) {
                        request.setEnabled(false);
                        request.done();
                    } else {
                        procService.canTerminate((IProcesses.IThreadDMContext)processDmc, (DataRequestMonitor)new DataRequestMonitor<Boolean>(ImmediateExecutor.getInstance(), null){

                            protected void handleCompleted() {
                                request.setEnabled(this.isSuccess() && (Boolean)this.getData() != false);
                                request.done();
                            }
                        });
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            request.setEnabled(false);
            request.done();
        }
    }

    public boolean execute(final IDebugCommandRequest request) {
        if (request.getElements().length != 1 || !(request.getElements()[0] instanceof IDMVMContext)) {
            request.done();
            return false;
        }
        IDMVMContext vmc = (IDMVMContext)request.getElements()[0];
        final IProcesses.IProcessDMContext processDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)vmc.getDMContext(), IProcesses.IProcessDMContext.class);
        if (processDmc == null) {
            request.done();
            return false;
        }
        try {
            this.fExecutor.execute((Runnable)new DsfRunnable(){

                public void run() {
                    IProcesses procService = (IProcesses)DsfTerminateCommand.this.fTracker.getService(IProcesses.class);
                    if (procService != null) {
                        procService.terminate((IProcesses.IThreadDMContext)processDmc, new RequestMonitor(ImmediateExecutor.getInstance(), null){

                            protected void handleCompleted() {
                                request.setStatus(this.getStatus());
                                request.done();
                            }
                        });
                    } else {
                        request.done();
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            request.done();
        }
        return false;
    }
}

