/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.model.CDebugElementState;
import org.eclipse.cdt.debug.core.model.ICDebugElement;
import org.eclipse.cdt.debug.core.model.ICDebugElementStatus;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.IModuleRetrieval;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;

public abstract class CDebugElement
extends PlatformObject
implements ICDebugElement,
ICDebugElementStatus {
    private CDebugTarget fDebugTarget;
    private int fSeverity = 0;
    private String fMessage = null;
    private CDebugElementState fState = CDebugElementState.UNDEFINED;
    private CDebugElementState fOldState = CDebugElementState.UNDEFINED;
    private Object fCurrentStateInfo = null;

    public CDebugElement(CDebugTarget target) {
        this.setDebugTarget(target);
    }

    public String getModelIdentifier() {
        return CDIDebugModel.getPluginIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    protected void setDebugTarget(CDebugTarget target) {
        this.fDebugTarget = target;
    }

    protected void logError(Exception e) {
        DebugPlugin.log((Throwable)e);
    }

    protected void logError(String message) {
        DebugPlugin.logMessage((String)message, null);
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
    }

    protected void fireEventSet(DebugEvent[] events) {
        DebugPlugin.getDefault().fireDebugEventSet(events);
    }

    public void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    public DebugEvent createCreateEvent() {
        return new DebugEvent((Object)this, 4);
    }

    public void fireResumeEvent(int detail) {
        this.fireEvent(new DebugEvent((Object)this, 1, detail));
    }

    public DebugEvent createResumeEvent(int detail) {
        return new DebugEvent((Object)this, 1, detail);
    }

    public void fireSuspendEvent(int detail) {
        this.fireEvent(new DebugEvent((Object)this, 2, detail));
    }

    public DebugEvent createSuspendEvent(int detail) {
        return new DebugEvent((Object)this, 2, detail);
    }

    public void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    public DebugEvent createTerminateEvent() {
        return new DebugEvent((Object)this, 8);
    }

    public void fireChangeEvent(int detail) {
        this.fireEvent(new DebugEvent((Object)this, 16, detail));
    }

    public DebugEvent createChangeEvent(int detail) {
        return new DebugEvent((Object)this, 16, detail);
    }

    public ICDISession getCDISession() {
        ICDITarget cdiTarget = this.getCDITarget();
        return cdiTarget != null ? cdiTarget.getSession() : null;
    }

    public ICDITarget getCDITarget() {
        return (ICDITarget)this.getDebugTarget().getAdapter(ICDITarget.class);
    }

    public static void requestFailed(String message, Exception e) throws DebugException {
        CDebugElement.requestFailed(message, e, 5012);
    }

    public static void targetRequestFailed(String message, CDIException e) throws DebugException {
        String format = "Target request failed: {0}";
        if (!message.endsWith(".")) {
            format = String.valueOf(format) + ".";
        }
        CDebugElement.requestFailed(MessageFormat.format((String)format, (Object[])new String[]{message}), e, 5010);
    }

    public static void requestFailed(String message, Throwable e, int code) throws DebugException {
        CDebugElement.throwDebugException(message, code, e);
    }

    public static void targetRequestFailed(String message, Throwable e) throws DebugException {
        String format = "Target request failed: {0}";
        if (!message.endsWith(".")) {
            format = String.valueOf(format) + ".";
        }
        CDebugElement.throwDebugException(MessageFormat.format((String)format, (Object[])new String[]{message}), 5010, e);
    }

    public static void notSupported(String message) throws DebugException {
        CDebugElement.throwDebugException(message, 5011, null);
    }

    protected static void throwDebugException(String message, int code, Throwable exception) throws DebugException {
        throw new DebugException((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), code, message, exception));
    }

    protected void infoMessage(Throwable e) {
        Status newStatus = new Status(1, CDebugCorePlugin.getUniqueIdentifier(), 10001, e.getMessage(), null);
        CDebugUtils.info((IStatus)newStatus, this.getDebugTarget());
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IDebugElement.class)) {
            return this;
        }
        if (adapter.equals(ICDebugElement.class)) {
            return this;
        }
        if (adapter.equals(CDebugElement.class)) {
            return this;
        }
        if (adapter.equals(ICDebugElementStatus.class)) {
            return this;
        }
        if (adapter.equals(ICDISession.class)) {
            return this.getCDISession();
        }
        if (adapter.equals(ICDebugTarget.class)) {
            return this.getDebugTarget();
        }
        if (adapter.equals(IDebugTarget.class)) {
            return this.getDebugTarget();
        }
        if (adapter.equals(IMemoryBlockRetrieval.class)) {
            return this.getDebugTarget().getAdapter(adapter);
        }
        if (adapter.equals(IModuleRetrieval.class)) {
            return this.getDebugTarget().getAdapter(adapter);
        }
        if (adapter.equals(ILaunch.class)) {
            return this.getDebugTarget().getLaunch();
        }
        return super.getAdapter(adapter);
    }

    protected void setStatus(int severity, String message) {
        this.fSeverity = severity;
        this.fMessage = message;
        if (this.fMessage != null) {
            this.fMessage = this.fMessage.trim();
        }
    }

    protected void resetStatus() {
        this.fSeverity = 0;
        this.fMessage = null;
    }

    public boolean isOK() {
        return this.fSeverity == 0;
    }

    public int getSeverity() {
        return this.fSeverity;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public CDebugElementState getState() {
        return this.fState;
    }

    protected synchronized void setState(CDebugElementState state) throws IllegalArgumentException {
        this.fOldState = this.fState;
        this.fState = state;
    }

    protected synchronized void restoreState() {
        this.fState = this.fOldState;
    }

    public Object getCurrentStateInfo() {
        return this.fCurrentStateInfo;
    }

    protected void setCurrentStateInfo(Object currentStateInfo) {
        this.fCurrentStateInfo = currentStateInfo;
    }
}

