/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import org.eclipse.cdt.debug.internal.core.sourcelookup.InternalSourceLookupMessages;
import org.eclipse.cdt.debug.internal.core.sourcelookup.MapEntrySourceContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainerTypeDelegate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MapEntrySourceContainerType
extends AbstractSourceContainerTypeDelegate {
    private static final String ELEMENT_NAME = "mapEntry";
    private static final String BACKEND_PATH = "backendPath";
    private static final String LOCAL_PATH = "localPath";

    public ISourceContainer createSourceContainer(String memento) throws CoreException {
        Element node = this.parseDocument(memento);
        if (node.getNodeType() == 1) {
            Element element = node;
            if (ELEMENT_NAME.equals(element.getNodeName())) {
                Path local;
                String path = element.getAttribute(BACKEND_PATH);
                Path backend = new Path(path);
                if (!backend.isValidPath(path)) {
                    this.abort(InternalSourceLookupMessages.MapEntrySourceContainerType_0, null);
                }
                if (!(local = new Path(path = element.getAttribute(LOCAL_PATH))).isValidPath(path)) {
                    this.abort(InternalSourceLookupMessages.MapEntrySourceContainerType_1, null);
                }
                return new MapEntrySourceContainer((IPath)backend, (IPath)local);
            }
            this.abort(InternalSourceLookupMessages.MapEntrySourceContainerType_2, null);
        }
        this.abort(InternalSourceLookupMessages.MapEntrySourceContainerType_3, null);
        return null;
    }

    public String getMemento(ISourceContainer container) throws CoreException {
        MapEntrySourceContainer entry = (MapEntrySourceContainer)container;
        Document document = this.newDocument();
        Element element = document.createElement(ELEMENT_NAME);
        element.setAttribute(BACKEND_PATH, entry.getBackendPath().toOSString());
        element.setAttribute(LOCAL_PATH, entry.getLocalPath().toOSString());
        document.appendChild(element);
        return this.serializeDocument(document);
    }
}

