/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.build.core.scannerconfig.CfgInfoContext;
import org.eclipse.cdt.build.core.scannerconfig.ICfgScannerConfigBuilderInfo2Set;
import org.eclipse.cdt.build.internal.core.scannerconfig2.CfgScannerConfigProfileManager;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.core.resources.RefreshScopeManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.core.ConsoleOutputSniffer;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCProfileInstance;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfile;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.cdt.managedbuilder.core.AbstractBuildRunner;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.newmake.internal.core.StreamMonitor;
import org.eclipse.cdt.utils.CommandLineUtil;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalBuildRunner
extends AbstractBuildRunner {
    private static final String TYPE_CLEAN = "ManagedMakeBuilder.type.clean";
    private static final String TYPE_INC = "ManagedMakeBuider.type.incremental";
    private static final String CONSOLE_HEADER = "ManagedMakeBuilder.message.console.header";
    private static final String WARNING_UNSUPPORTED_CONFIGURATION = "ManagedMakeBuilder.warning.unsupported.configuration";
    private static final String NEWLINE = System.getProperty("line.separator", "\n");
    private static final String PATH_ENV = "PATH";

    @Override
    public boolean invokeBuild(int kind, IProject project, IConfiguration configuration, IBuilder builder, IConsole console, IMarkerGenerator markerGenerator, IncrementalProjectBuilder projectBuilder, IProgressMonitor monitor) throws CoreException {
        return this.invokeExternalBuild(kind, project, configuration, builder, console, markerGenerator, projectBuilder, monitor);
    }

    protected boolean invokeExternalBuild(int kind, IProject project, IConfiguration configuration, IBuilder builder, IConsole console, IMarkerGenerator markerGenerator, IncrementalProjectBuilder projectBuilder, IProgressMonitor monitor) throws CoreException {
        boolean isClean;
        block26: {
            isClean = false;
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(String.valueOf(ManagedMakeMessages.getResourceString("MakeBuilder.Invoking_Make_Builder")) + project.getName(), 100);
            try {
                try {
                    StreamMonitor streamMon;
                    IPath buildCommand = builder.getBuildCommand();
                    if (buildCommand == null) break block26;
                    ConsoleOutputStream cos = console.getOutputStream();
                    StringBuffer buf = new StringBuffer();
                    String[] consoleHeader = new String[3];
                    switch (kind) {
                        case 6: 
                        case 9: 
                        case 10: {
                            consoleHeader[0] = ManagedMakeMessages.getResourceString(TYPE_INC);
                            break;
                        }
                        case 15: {
                            consoleHeader[0] = ManagedMakeMessages.getResourceString(TYPE_CLEAN);
                        }
                    }
                    consoleHeader[1] = configuration.getName();
                    consoleHeader[2] = project.getName();
                    buf.append(NEWLINE);
                    buf.append(ManagedMakeMessages.getFormattedString(CONSOLE_HEADER, consoleHeader)).append(NEWLINE);
                    buf.append(NEWLINE);
                    if (!configuration.isSupported()) {
                        String unsupportedToolchainMsg = ManagedMakeMessages.getFormattedString(WARNING_UNSUPPORTED_CONFIGURATION, new String[]{configuration.getName(), configuration.getToolChain().getName()});
                        buf.append(unsupportedToolchainMsg).append(NEWLINE);
                        buf.append(NEWLINE);
                    }
                    cos.write(buf.toString().getBytes());
                    cos.flush();
                    IWorkspace workspace = project.getWorkspace();
                    IMarker[] markers = project.findMarkers("org.eclipse.cdt.core.problem", true, 2);
                    if (markers != null) {
                        workspace.deleteMarkers(markers);
                    }
                    URI workingDirectoryURI = ManagedBuildManager.getBuildLocationURI(configuration, builder);
                    String pathFromURI = EFSExtensionManager.getDefault().getPathFromURI(workingDirectoryURI);
                    if (pathFromURI == null) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", ManagedMakeMessages.getString("ManagedMakeBuilder.message.error"), null));
                    }
                    Path workingDirectory = new Path(pathFromURI);
                    String[] targets = this.getTargets(kind, builder);
                    if (targets.length != 0 && targets[targets.length - 1].equals(builder.getCleanBuildTarget())) {
                        isClean = true;
                    }
                    String errMsg = null;
                    ICommandLauncher launcher = builder.getCommandLauncher();
                    launcher.setProject(project);
                    launcher.showCommand(true);
                    Map<String, String> envMap = this.getEnvironment(builder);
                    String[] env = ExternalBuildRunner.getEnvStrings(envMap);
                    String[] buildArguments = targets;
                    String[] newArgs = CommandLineUtil.argumentsToArray((String)builder.getBuildArguments());
                    buildArguments = new String[targets.length + newArgs.length];
                    System.arraycopy(newArgs, 0, buildArguments, 0, newArgs.length);
                    System.arraycopy(targets, 0, buildArguments, newArgs.length, targets.length);
                    QualifiedName qName = new QualifiedName(ManagedBuilderCorePlugin.getUniqueIdentifier(), "progressMonitor");
                    Integer last = (Integer)project.getSessionProperty(qName);
                    if (last == null) {
                        last = new Integer(100);
                    }
                    ErrorParserManager epm = new ErrorParserManager(project, workingDirectoryURI, markerGenerator, builder.getErrorParsers());
                    epm.setOutputStream((OutputStream)cos);
                    StreamMonitor stdout = streamMon = new StreamMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 100), (OutputStream)epm, last);
                    StreamMonitor stderr = streamMon;
                    ConsoleOutputSniffer sniffer = this.createBuildOutputSniffer(stdout, stderr, project, configuration, (IPath)workingDirectory, markerGenerator, null);
                    OutputStream consoleOut = sniffer == null ? stdout : sniffer.getOutputStream();
                    OutputStream consoleErr = sniffer == null ? stderr : sniffer.getErrorStream();
                    Process p = launcher.execute(buildCommand, buildArguments, env, (IPath)workingDirectory, monitor);
                    if (p != null) {
                        try {
                            p.getOutputStream().close();
                        }
                        catch (IOException iOException) {}
                        monitor.subTask(String.valueOf(ManagedMakeMessages.getResourceString("MakeBuilder.Invoking_Command")) + launcher.getCommandLine());
                        if (launcher.waitAndRead(consoleOut, consoleErr, (IProgressMonitor)new SubProgressMonitor(monitor, 0)) != 0) {
                            errMsg = launcher.getErrorMessage();
                        }
                        monitor.subTask(ManagedMakeMessages.getResourceString("MakeBuilder.Updating_project"));
                        try {
                            RefreshScopeManager refreshManager = RefreshScopeManager.getInstance();
                            IWorkspaceRunnable runnable = refreshManager.getRefreshRunnable(project);
                            ResourcesPlugin.getWorkspace().run(runnable, null, 1, null);
                        }
                        catch (CoreException coreException) {}
                    } else {
                        buf = new StringBuffer(launcher.getCommandLine()).append(NEWLINE);
                        errMsg = launcher.getErrorMessage();
                    }
                    project.setSessionProperty(qName, !monitor.isCanceled() && !isClean ? new Integer(streamMon.getWorkDone()) : null);
                    if (errMsg != null) {
                        String errorPrefix = ManagedMakeMessages.getResourceString("ManagedMakeBuilder.error.prefix");
                        String buildCommandStr = buildCommand.toString();
                        String envPath = envMap.get(PATH_ENV);
                        if (envPath == null) {
                            envPath = System.getenv(PATH_ENV);
                        }
                        if (PathUtil.findProgramLocation((String)buildCommandStr, (String)envPath) == null) {
                            buf.append(errMsg).append(NEWLINE);
                            errMsg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.program.not.in.path", buildCommandStr);
                            buf.append(errorPrefix).append(errMsg).append(NEWLINE);
                            buf.append(NEWLINE);
                            buf.append("PATH=[" + envPath + "]").append(NEWLINE);
                        } else {
                            buf.append(errorPrefix).append(errMsg).append(NEWLINE);
                        }
                        consoleErr.write(buf.toString().getBytes());
                        consoleErr.flush();
                    }
                    buf = new StringBuffer(NEWLINE);
                    buf.append(ManagedMakeMessages.getResourceString("ManagedMakeBuilder.message.build.finished")).append(NEWLINE);
                    consoleOut.write(buf.toString().getBytes());
                    ((OutputStream)stdout).close();
                    ((OutputStream)stderr).close();
                    monitor.subTask(ManagedMakeMessages.getResourceString("MakeBuilder.Creating_Markers"));
                    consoleOut.close();
                    consoleErr.close();
                    cos.close();
                }
                catch (Exception e) {
                    ManagedBuilderCorePlugin.log(e);
                    throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e));
                }
            }
            finally {
                monitor.done();
            }
        }
        return isClean;
    }

    protected String[] getTargets(int kind, IBuilder builder) {
        String[] targetsArray = null;
        if (kind != 15 && !builder.isCustomBuilder() && builder.isManagedBuildOn()) {
            IConfiguration cfg = builder.getParent().getParent();
            String preBuildStep = cfg.getPrebuildStep();
            try {
                preBuildStep = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(preBuildStep, "", " ", 3, cfg);
            }
            catch (BuildMacroException buildMacroException) {}
            if (preBuildStep != null && preBuildStep.length() != 0) {
                targetsArray = new String[]{"pre-build", "main-build"};
            }
        }
        if (targetsArray == null) {
            String targets = "";
            switch (kind) {
                case 9: {
                    targets = builder.getAutoBuildTarget();
                    break;
                }
                case 6: 
                case 10: {
                    targets = builder.getIncrementalBuildTarget();
                    break;
                }
                case 15: {
                    targets = builder.getCleanBuildTarget();
                }
            }
            targetsArray = CommandLineUtil.argumentsToArray((String)targets);
        }
        return targetsArray;
    }

    protected Map<String, String> getEnvironment(IBuilder builder) throws CoreException {
        Map<String, String> builderEnv;
        HashMap<String, String> envMap = new HashMap<String, String>();
        if (builder.appendEnvironment()) {
            IEnvironmentVariable[] vars;
            ICConfigurationDescription cfgDes = ManagedBuildManager.getDescriptionForConfiguration(builder.getParent().getParent());
            IEnvironmentVariableManager mngr = CCorePlugin.getDefault().getBuildEnvironmentManager();
            IEnvironmentVariable[] iEnvironmentVariableArray = vars = mngr.getVariables(cfgDes, true);
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                IEnvironmentVariable var = iEnvironmentVariableArray[n2];
                envMap.put(var.getName(), var.getValue());
                ++n2;
            }
        }
        if ((builderEnv = builder.getExpandedEnvironment()) != null) {
            envMap.putAll(builderEnv);
        }
        return envMap;
    }

    protected static String[] getEnvStrings(Map<String, String> env) {
        ArrayList<String> strings = new ArrayList<String>(env.size());
        for (Map.Entry<String, String> entry : env.entrySet()) {
            StringBuffer buffer = new StringBuffer(entry.getKey());
            buffer.append('=').append(entry.getValue());
            strings.add(buffer.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    private ConsoleOutputSniffer createBuildOutputSniffer(OutputStream outputStream, OutputStream errorStream, IProject project, IConfiguration cfg, IPath workingDirectory, IMarkerGenerator markerGenerator, IScannerInfoCollector collector) {
        ICfgScannerConfigBuilderInfo2Set container = CfgScannerConfigProfileManager.getCfgScannerConfigBuildInfo(cfg);
        Map<CfgInfoContext, IScannerConfigBuilderInfo2> map = container.getInfoMap();
        ArrayList<IScannerInfoConsoleParser> clParserList = new ArrayList<IScannerInfoConsoleParser>();
        if (container.isPerRcTypeDiscovery()) {
            IResourceInfo[] iResourceInfoArray = cfg.getResourceInfos();
            int n = iResourceInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceInfo rcInfo = iResourceInfoArray[n2];
                ITool[] tools = rcInfo instanceof IFileInfo ? ((IFileInfo)rcInfo).getToolsToInvoke() : ((IFolderInfo)rcInfo).getFilteredTools();
                ITool[] iToolArray = tools;
                int n3 = tools.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITool tool = iToolArray[n4];
                    IInputType[] types = tool.getInputTypes();
                    if (types.length != 0) {
                        IInputType[] iInputTypeArray = types;
                        int n5 = types.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IInputType type = iInputTypeArray[n6];
                            CfgInfoContext c = new CfgInfoContext(rcInfo, tool, type);
                            this.contributeToConsoleParserList(project, map, c, workingDirectory, markerGenerator, collector, clParserList);
                            ++n6;
                        }
                    } else {
                        CfgInfoContext c = new CfgInfoContext(rcInfo, tool, null);
                        this.contributeToConsoleParserList(project, map, c, workingDirectory, markerGenerator, collector, clParserList);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        if (clParserList.size() == 0) {
            this.contributeToConsoleParserList(project, map, new CfgInfoContext(cfg), workingDirectory, markerGenerator, collector, clParserList);
        }
        if (clParserList.size() != 0) {
            return new ConsoleOutputSniffer(outputStream, errorStream, (IConsoleParser[])clParserList.toArray(new IScannerInfoConsoleParser[clParserList.size()]));
        }
        return null;
    }

    private boolean contributeToConsoleParserList(IProject project, Map<CfgInfoContext, IScannerConfigBuilderInfo2> map, CfgInfoContext context, IPath workingDirectory, IMarkerGenerator markerGenerator, IScannerInfoCollector collector, List<IScannerInfoConsoleParser> parserList) {
        IScannerConfigBuilderInfo2 info = map.get(context);
        InfoContext ic = context.toInfoContext();
        boolean added = false;
        if (info != null && info.isAutoDiscoveryEnabled() && info.isBuildOutputParserEnabled()) {
            String id = info.getSelectedProfileId();
            ScannerConfigProfile profile = ScannerConfigProfileManager.getInstance().getSCProfileConfiguration(id);
            if (profile.getBuildOutputProviderElement() != null) {
                SCProfileInstance profileInstance = ScannerConfigProfileManager.getInstance().getSCProfileInstance(project, ic, id);
                IScannerInfoConsoleParser clParser = profileInstance.createBuildOutputParser();
                if (collector == null) {
                    collector = profileInstance.getScannerInfoCollector();
                }
                if (clParser != null) {
                    clParser.startup(project, workingDirectory, collector, (IMarkerGenerator)(info.isProblemReportingEnabled() ? markerGenerator : null));
                    parserList.add(clParser);
                    added = true;
                }
            }
        }
        return added;
    }
}

