/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchKey<T extends BuildObject> {
    private T buildObject;

    public MatchKey(T builder) {
        this.buildObject = builder;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MatchKey)) {
            return false;
        }
        MatchKey other = (MatchKey)obj;
        return this.performMatchComparison(other.buildObject);
    }

    public int hashCode() {
        String name = ((BuildObject)this.buildObject).getName();
        if (name == null) {
            name = ((BuildObject)this.buildObject).getId();
        }
        int code = name.hashCode();
        String version = ManagedBuildManager.getVersionFromIdAndVersion(((BuildObject)this.buildObject).getId());
        if (version != null) {
            code += version.hashCode();
        }
        return code;
    }

    boolean performMatchComparison(T bo) {
        if (bo == null) {
            return false;
        }
        if (bo == this.buildObject) {
            return true;
        }
        if (!((BuildObject)bo).getName().equals(((BuildObject)this.buildObject).getName())) {
            return false;
        }
        String thisVersion = ManagedBuildManager.getVersionFromIdAndVersion(((BuildObject)this.buildObject).getId());
        String otherVersion = ManagedBuildManager.getVersionFromIdAndVersion(((BuildObject)bo).getId());
        return !(thisVersion == null || thisVersion.length() == 0 ? otherVersion != null && otherVersion.length() != 0 : !thisVersion.equals(otherVersion));
    }
}

