/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.dataprovider;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.util.ResourceChangeHandlerBase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResourcePropertyHolder
extends ResourceChangeHandlerBase {
    private Map<String, Map<String, Boolean>> fRcMap = new HashMap<String, Map<String, Boolean>>();
    private boolean fProjectOnly;

    public ResourcePropertyHolder(boolean projectOnly) {
        this.fProjectOnly = projectOnly;
    }

    private boolean isValidResource(IResource rc) {
        return !this.fProjectOnly || rc.getType() == 4;
    }

    protected ResourceChangeHandlerBase.IResourceMoveHandler createResourceMoveHandler(IResourceChangeEvent event) {
        return new ResourceMoveHandler();
    }

    protected String keyForResource(IResource rc) {
        return rc.getFullPath().toString();
    }

    public synchronized Boolean getProperty(IResource rc, String propKey) throws IllegalArgumentException {
        if (!this.isValidResource(rc)) {
            throw new IllegalArgumentException();
        }
        Map<String, Boolean> map = this.getResourcePropertyMap(rc, false);
        if (map == null) {
            return null;
        }
        return map.get(propKey);
    }

    private Map<String, Boolean> getResourcePropertyMap(IResource rc, boolean create) {
        String key = this.keyForResource(rc);
        Map<String, Boolean> map = this.fRcMap.get(key);
        if (map == null && create) {
            map = new HashMap<String, Boolean>();
            this.fRcMap.put(key, map);
        }
        return map;
    }

    private synchronized void removeResourcePropertyMap(IResource rc) {
        String key = this.keyForResource(rc);
        this.fRcMap.remove(key);
    }

    private synchronized void moveResourcePropertyMap(IResource fromRc, IResource toRc) {
        String fromKey = this.keyForResource(fromRc);
        String toKey = this.keyForResource(toRc);
        Map<String, Boolean> fromMap = this.fRcMap.remove(fromKey);
        if (fromMap != null) {
            this.fRcMap.put(toKey, fromMap);
        } else {
            this.fRcMap.remove(toKey);
        }
    }

    public synchronized Boolean setProperty(IResource rc, String propKey, Boolean value) throws IllegalArgumentException {
        if (!this.isValidResource(rc)) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            return this.removeProperty(rc, propKey);
        }
        Map<String, Boolean> map = this.getResourcePropertyMap(rc, true);
        return map.put(propKey, value);
    }

    private synchronized Boolean removeProperty(IResource rc, String propKey) {
        Map<String, Boolean> map = this.getResourcePropertyMap(rc, false);
        if (map == null) {
            return null;
        }
        Boolean old = map.remove(propKey);
        if (map.size() == 0) {
            this.removeResourcePropertyMap(rc);
        }
        return old;
    }

    private class ResourceMoveHandler
    implements ResourceChangeHandlerBase.IResourceMoveHandler {
        private ResourceMoveHandler() {
        }

        public void done() {
        }

        public void handleProjectClose(IProject project) {
            ResourcePropertyHolder.this.removeResourcePropertyMap((IResource)project);
        }

        public boolean handleResourceMove(IResource fromRc, IResource toRc) {
            if (ResourcePropertyHolder.this.isValidResource(fromRc)) {
                ResourcePropertyHolder.this.moveResourcePropertyMap(fromRc, toRc);
                return !ResourcePropertyHolder.this.fProjectOnly;
            }
            return false;
        }

        public boolean handleResourceRemove(IResource rc) {
            if (ResourcePropertyHolder.this.isValidResource(rc)) {
                ResourcePropertyHolder.this.removeResourcePropertyMap(rc);
                return !ResourcePropertyHolder.this.fProjectOnly;
            }
            return false;
        }
    }
}

