/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.tcmodification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.FolderInfo;
import org.eclipse.cdt.managedbuilder.internal.core.IRealBuildObjectAssociation;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceInfo;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ConflictSet;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.DbgTcmUtil;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.Messages;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.PathComparator;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.PerTypeMapStorage;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.PerTypeSetStorage;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.TcModificationUtil;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ToolChainModificationManager;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ToolListModification;
import org.eclipse.cdt.managedbuilder.tcmodification.CompatibilityStatus;
import org.eclipse.cdt.managedbuilder.tcmodification.IFolderInfoModification;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderInfoModification
extends ToolListModification
implements IFolderInfoModification {
    private ToolChain fRealToolChain;
    private ToolChainCompatibilityInfoElement fCurrentCompatibilityInfo;
    private ToolChain fSelectedToolChain;
    private IToolChain[] fAllSysToolChains;
    private Map<ToolChain, ToolChainCompatibilityInfoElement> fCompatibleToolChains;
    private Map<ToolChain, ToolChainCompatibilityInfoElement> fInCompatibleToolChains;
    private PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> fParentObjectStorage;
    private ToolChainModificationManager.ConflictMatchSet fParentConflicts;
    private boolean fCompatibilityInfoInited;
    private ToolChainApplicabilityPaths fTcApplicabilityPaths;

    public FolderInfoModification(FolderInfo foInfo) {
        super((ResourceInfo)foInfo, foInfo.getTools());
        this.fSelectedToolChain = (ToolChain)foInfo.getToolChain();
        this.fRealToolChain = (ToolChain)ManagedBuildManager.getRealToolChain(this.fSelectedToolChain);
    }

    public FolderInfoModification(FolderInfo foInfo, FolderInfoModification base) {
        super((ResourceInfo)foInfo, base);
        this.fSelectedToolChain = base.fSelectedToolChain;
        if (!this.fSelectedToolChain.isExtensionElement()) {
            this.fSelectedToolChain = (ToolChain)this.fSelectedToolChain.getExtensionObject();
        }
        this.fRealToolChain = base.fRealToolChain;
    }

    private ToolChainModificationManager.ConflictMatchSet getParentConflictMatchSet() {
        if (this.fParentConflicts == null) {
            PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> storage = this.getParentObjectStorage();
            this.fParentConflicts = ToolChainModificationManager.getInstance().getConflictInfo(1, storage);
        }
        return this.fParentConflicts;
    }

    private PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> getParentObjectStorage() {
        if (this.fParentObjectStorage == null) {
            this.fParentObjectStorage = TcModificationUtil.createParentObjectsRealToolToPathSet((FolderInfo)this.getResourceInfo());
        }
        return this.fParentObjectStorage;
    }

    private IToolChain[] getAllSysToolChains() {
        if (this.fAllSysToolChains == null) {
            this.fAllSysToolChains = ManagedBuildManager.getRealToolChains();
        }
        return this.fAllSysToolChains;
    }

    @Override
    public IToolChain[] getCompatibleToolChains() {
        this.initCompatibilityInfo();
        FolderInfo foInfo = (FolderInfo)this.getResourceInfo();
        ArrayList<ToolChain> l = new ArrayList<ToolChain>(this.fCompatibleToolChains.size());
        Set<ToolChain> keySet = this.fCompatibleToolChains.keySet();
        for (ToolChain tc : keySet) {
            if (tc == this.fRealToolChain || !foInfo.isToolChainCompatible(this.fRealToolChain, tc)) continue;
            l.add(tc);
        }
        return l.toArray(new ToolChain[l.size()]);
    }

    @Override
    public CompatibilityStatus getToolChainCompatibilityStatus() {
        return this.getCurrentCompatibilityInfo().getCompatibilityStatus();
    }

    private ToolChainCompatibilityInfoElement getCurrentCompatibilityInfo() {
        if (this.fCurrentCompatibilityInfo == null) {
            this.initCompatibilityInfo();
            ToolChainCompatibilityInfoElement info = this.fCompatibleToolChains.get(this.fRealToolChain);
            if (info == null) {
                info = this.fInCompatibleToolChains.get(this.fRealToolChain);
            }
            this.fCurrentCompatibilityInfo = info;
        }
        return this.fCurrentCompatibilityInfo;
    }

    @Override
    public boolean isToolChainCompatible() {
        return this.getCurrentCompatibilityInfo().isCompatible();
    }

    private void initCompatibilityInfo() {
        if (this.fCompatibilityInfoInited) {
            return;
        }
        this.fCompatibleToolChains = new HashMap<ToolChain, ToolChainCompatibilityInfoElement>();
        this.fInCompatibleToolChains = new HashMap<ToolChain, ToolChainCompatibilityInfoElement>();
        ToolChainModificationManager.ConflictMatchSet parentConflicts = this.getParentConflictMatchSet();
        ToolChain[] sysTCs = (ToolChain[])this.getAllSysToolChains();
        Map<? extends IRealBuildObjectAssociation, List<ToolChainModificationManager.ConflictMatch>> conflictMap = parentConflicts.fObjToConflictListMap;
        ToolChain[] toolChainArray = sysTCs;
        int n = sysTCs.length;
        int n2 = 0;
        while (n2 < n) {
            ToolChain tc = toolChainArray[n2];
            List<ToolChainModificationManager.ConflictMatch> l = conflictMap.get(tc);
            ToolChainCompatibilityInfoElement info = new ToolChainCompatibilityInfoElement(tc, l);
            if (info.isCompatible()) {
                this.fCompatibleToolChains.put(tc, info);
            } else {
                this.fInCompatibleToolChains.put(tc, info);
            }
            ++n2;
        }
        this.fCompatibilityInfoInited = true;
    }

    @Override
    public IToolChain getToolChain() {
        return this.fSelectedToolChain;
    }

    @Override
    public final void setToolChain(IToolChain tc) {
        this.setToolChain(tc, false);
    }

    public void setToolChain(IToolChain tc, boolean force) {
        if (tc == this.fSelectedToolChain && !force) {
            return;
        }
        this.applyToolChain((ToolChain)tc);
        this.fSelectedToolChain = (ToolChain)tc;
        IToolChain newReal = ManagedBuildManager.getRealToolChain(tc);
        if (newReal == this.fRealToolChain && !force) {
            return;
        }
        this.fRealToolChain = (ToolChain)newReal;
        this.clearToolInfo(tc.getTools());
        this.fCurrentCompatibilityInfo = null;
    }

    protected void clearToolChainCompatibilityInfo() {
        this.fCompatibilityInfoInited = false;
        this.fCompatibleToolChains = null;
        this.fInCompatibleToolChains = null;
        this.fCurrentCompatibilityInfo = null;
    }

    @Override
    protected boolean canRemove(ITool realTool) {
        IToolChain extTc = ManagedBuildManager.getExtensionToolChain(this.fSelectedToolChain);
        ITool[] tools = extTc.getTools();
        int i = 0;
        while (i < tools.length) {
            if (realTool == ManagedBuildManager.getRealTool(tools[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    protected boolean canAdd(Tool tool) {
        return !TcModificationUtil.containCommonEntries(this.getInputExtsSet(), tool.getPrimaryInputExtensions());
    }

    @Override
    protected boolean canReplace(Tool fromTool, Tool toTool) {
        String[] exts = toTool.getPrimaryInputExtensions();
        HashSet<String> curInputExts = null;
        Set<String> inputExts = this.getInputExtsSet();
        String[] stringArray = exts;
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            if (inputExts.contains(ext)) {
                if (curInputExts == null) {
                    curInputExts = new HashSet<String>(Arrays.asList(fromTool.getPrimaryInputExtensions()));
                }
                if (curInputExts.contains(ext)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected Set<Tool> getExtensionConflictToolSet(Tool tool, Tool[] tools) {
        String[] exts = tool.getPrimaryInputExtensions();
        HashSet<String> extsSet = new HashSet<String>(Arrays.asList(exts));
        Set<Tool> conflictsSet = null;
        int i = 0;
        while (i < tools.length) {
            Tool t = tools[i];
            if (t != tool && TcModificationUtil.containCommonEntries(extsSet, t.getPrimaryInputExtensions())) {
                if (conflictsSet == null) {
                    conflictsSet = new HashSet<Tool>();
                }
                conflictsSet.add(t);
            }
            ++i;
        }
        if (conflictsSet == null) {
            conflictsSet = Collections.emptySet();
        }
        return conflictsSet;
    }

    @Override
    protected Set<IPath> getToolApplicabilityPathSet(Tool realTool, boolean isProject) {
        if (isProject) {
            return (Set)this.getToolChainApplicabilityPaths().fToolPathMap.get(realTool);
        }
        return this.getToolChainApplicabilityPaths().fFolderInfoPaths;
    }

    @Override
    protected Tool[] filterTools(Tool[] tools) {
        IResourceInfo rcInfo = this.getResourceInfo();
        return (Tool[])((FolderInfo)rcInfo).filterTools(tools, rcInfo.getParent().getManagedProject());
    }

    private ToolChainApplicabilityPaths getToolChainApplicabilityPaths() {
        this.initToolChainApplicabilityPaths();
        return this.fTcApplicabilityPaths;
    }

    private void initToolChainApplicabilityPaths() {
        if (this.fTcApplicabilityPaths != null) {
            return;
        }
        ToolChainApplicabilityPaths tcApplicabilityPaths = new ToolChainApplicabilityPaths();
        IPath path = this.getResourceInfo().getPath();
        TreeMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> pathMap = this.getCompletePathMapStorage();
        PerTypeSetStorage<IRealBuildObjectAssociation> oSet = pathMap.get(path);
        Set<IRealBuildObjectAssociation> toolSet = oSet.getSet(2, false);
        Set<IRealBuildObjectAssociation> tcSet = oSet.getSet(1, false);
        ToolChain curTc = (ToolChain)tcSet.iterator().next();
        Set foInfoPaths = tcApplicabilityPaths.fFolderInfoPaths;
        Set fileInfoPaths = tcApplicabilityPaths.fFileInfoPaths;
        foInfoPaths.add(path);
        Map toolPathsMap = tcApplicabilityPaths.fToolPathMap;
        if (toolSet != null) {
            for (IRealBuildObjectAssociation oa : toolSet) {
                Tool tool = (Tool)oa;
                HashSet<IPath> set = new HashSet<IPath>();
                toolPathsMap.put(tool, set);
                set.add(path);
            }
        }
        FolderInfoModification.calculateChildPaths(pathMap, path, curTc, foInfoPaths, toolPathsMap, fileInfoPaths);
        this.fTcApplicabilityPaths = tcApplicabilityPaths;
    }

    @Override
    protected void clearToolInfo(ITool[] tools) {
        super.clearToolInfo(tools);
        this.fTcApplicabilityPaths = null;
    }

    private static void putToolInfo(Set<Tool> ct, Map<Tool, Set<IPath>> toolPathsMap, Set<IPath> fileInfoPaths, IPath p) {
        if (ct != null && ct.size() != 0) {
            for (Tool t : ct) {
                Set<IPath> set = toolPathsMap.get(t);
                if (set == null) continue;
                if (fileInfoPaths != null) {
                    fileInfoPaths.add(p);
                }
                set.add(p);
            }
        }
    }

    private static void calculateChildPaths(TreeMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> pathMap, IPath path, ToolChain tc, Set<IPath> tcPaths, Map<Tool, Set<IPath>> toolPathsMap, Set<IPath> fileInfoPaths) {
        SortedMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> directCMap = PathComparator.getDirectChildPathMap(pathMap, path);
        Set<Map.Entry<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>>> entrySet = directCMap.entrySet();
        for (Map.Entry<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> entry : entrySet) {
            PerTypeSetStorage<IRealBuildObjectAssociation> cst = entry.getValue();
            Set<IRealBuildObjectAssociation> ctc = cst.getSet(1, false);
            Set<IRealBuildObjectAssociation> ct = cst.getSet(2, false);
            if (ctc == null || ctc.size() == 0) {
                FolderInfoModification.putToolInfo(ct, toolPathsMap, fileInfoPaths, entry.getKey());
                continue;
            }
            if (!ctc.contains(tc)) continue;
            IPath cp = entry.getKey();
            tcPaths.add(cp);
            FolderInfoModification.putToolInfo(ct, toolPathsMap, null, entry.getKey());
            FolderInfoModification.calculateChildPaths(pathMap, cp, tc, tcPaths, toolPathsMap, fileInfoPaths);
        }
    }

    private void applyToolChain(ToolChain newNonRealTc) {
        ToolChain newRealTc = (ToolChain)ManagedBuildManager.getRealToolChain(newNonRealTc);
        ToolChainApplicabilityPaths tcApplicability = this.getToolChainApplicabilityPaths();
        PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> storage = this.getCompleteObjectStore();
        Map<IRealBuildObjectAssociation, Set<IPath>> tcMap = storage.getMap(1, false);
        Map<IRealBuildObjectAssociation, Set<IPath>> toolMap = storage.getMap(2, false);
        TcModificationUtil.removePaths(tcMap, this.fRealToolChain, tcApplicability.fFolderInfoPaths);
        TcModificationUtil.addPaths(tcMap, newRealTc, tcApplicability.fFolderInfoPaths);
        ITool[] newTools = (Tool[])newNonRealTc.getTools();
        int i = 0;
        while (i < newTools.length) {
            newTools[i] = (Tool)ManagedBuildManager.getRealTool(newTools[i]);
            ++i;
        }
        Set entrySet = tcApplicability.fToolPathMap.entrySet();
        for (Map.Entry entry : entrySet) {
            Tool tool = (Tool)entry.getKey();
            Set pathSet = (Set)entry.getValue();
            TcModificationUtil.removePaths(toolMap, tool, pathSet);
        }
        int i2 = 0;
        while (i2 < newTools.length) {
            TcModificationUtil.addPaths(toolMap, newTools[i2], tcApplicability.fFolderInfoPaths);
            ++i2;
        }
        if (tcApplicability.fFileInfoPaths.size() != 0) {
            FolderInfo foInfo = (FolderInfo)this.getResourceInfo();
            IManagedProject mProj = foInfo.getParent().getManagedProject();
            IProject project = mProj.getOwner().getProject();
            Tool[] filtered = (Tool[])foInfo.filterTools(newTools, mProj);
            if (filtered.length != 0) {
                for (IPath p : tcApplicability.fFileInfoPaths) {
                    boolean found = false;
                    String ext = p.getFileExtension();
                    if (ext == null) {
                        ext = "";
                    }
                    int i3 = 0;
                    while (i3 < filtered.length) {
                        if (filtered[i3].buildsFileType(ext, project)) {
                            TcModificationUtil.addPath(toolMap, filtered[i3], p);
                            found = true;
                            break;
                        }
                        ++i3;
                    }
                    if (found || !DbgTcmUtil.DEBUG) continue;
                    DbgTcmUtil.println("no tools found for path " + p);
                }
            } else if (DbgTcmUtil.DEBUG) {
                DbgTcmUtil.println("no filtered tools");
            }
        }
    }

    private IToolChain getDefaultToolChain() {
        IResourceInfo rcInfo = this.getResourceInfo();
        IToolChain defaultTc = null;
        if (rcInfo.getPath().segmentCount() == 0) {
            IConfiguration cfg = rcInfo.getParent();
            IConfiguration extCfg = cfg.getParent();
            defaultTc = extCfg.getToolChain();
            if (defaultTc == null && cfg.getToolChain() != null) {
                defaultTc = cfg.getToolChain().getSuperClass();
            }
        } else {
            IFolderInfo parentFo = ((ResourceInfo)rcInfo).getParentFolderInfo();
            IToolChain tc = parentFo.getToolChain();
            defaultTc = ManagedBuildManager.getExtensionToolChain(tc);
        }
        if (defaultTc != null && defaultTc.getId().equals("org.eclipse.cdt.build.core.prefbase.toolchain")) {
            defaultTc = null;
        }
        return defaultTc;
    }

    @Override
    public final void restoreDefaults() {
        IToolChain tc = this.getDefaultToolChain();
        if (tc != null) {
            this.setToolChain(tc, true);
        }
    }

    private static class ToolChainApplicabilityPaths {
        private Set<IPath> fFileInfoPaths = new HashSet<IPath>();
        private Set<IPath> fFolderInfoPaths = new HashSet<IPath>();
        private Map<Tool, Set<IPath>> fToolPathMap = new HashMap<Tool, Set<IPath>>();

        private ToolChainApplicabilityPaths() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToolChainCompatibilityInfoElement {
        private ToolChain fTc;
        private List<ToolChainModificationManager.ConflictMatch> fErrComflictMatchList;
        private CompatibilityStatus fStatus;

        ToolChainCompatibilityInfoElement(ToolChain tc, List<ToolChainModificationManager.ConflictMatch> errConflictList) {
            this.fTc = tc;
            if (errConflictList != null && errConflictList.size() != 0) {
                this.fErrComflictMatchList = errConflictList;
            }
        }

        public CompatibilityStatus getCompatibilityStatus() {
            if (this.fStatus == null) {
                String message;
                int severity;
                if (this.fErrComflictMatchList != null) {
                    severity = 4;
                    message = Messages.getString("FolderInfoModification.0");
                } else {
                    severity = 0;
                    message = "";
                }
                this.fStatus = new CompatibilityStatus(severity, message, new ConflictSet(this.fTc, this.fErrComflictMatchList, null));
            }
            return this.fStatus;
        }

        public boolean isCompatible() {
            return this.fErrComflictMatchList == null;
        }
    }
}

