/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.tcmodification;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.internal.core.IRealBuildObjectAssociation;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.IObjectSet;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.extension.MatchObjectElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectSet
implements IObjectSet {
    private int fObjectType;
    private Set<IRealBuildObjectAssociation> fObjectSet;

    public ObjectSet(int objectType, Set<IRealBuildObjectAssociation> objectSet) {
        this.fObjectType = objectType;
        this.fObjectSet = objectSet;
    }

    @Override
    public final int getObjectType() {
        return this.fObjectType;
    }

    @Override
    public IRealBuildObjectAssociation[] getRealBuildObjects() {
        return this.fObjectSet.toArray(new IRealBuildObjectAssociation[this.fObjectSet.size()]);
    }

    @Override
    public Collection<IRealBuildObjectAssociation> getRealBuildObjects(Collection<IRealBuildObjectAssociation> set) {
        if (set == null) {
            set = new HashSet<IRealBuildObjectAssociation>();
        }
        set.addAll(this.fObjectSet);
        return set;
    }

    @Override
    public boolean matchesObject(IRealBuildObjectAssociation obj) {
        return this.fObjectSet.contains(obj.getRealBuildObject());
    }

    @Override
    public boolean retainMatches(Collection<IRealBuildObjectAssociation> collection) {
        return collection.retainAll(this.fObjectSet);
    }

    @Override
    public int getNumObjects() {
        return this.fObjectSet.size();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(MatchObjectElement.TypeToStringAssociation.getAssociation(this.fObjectType).getString());
        buf.append("[");
        boolean isFirst = true;
        for (IRealBuildObjectAssociation obj : this.fObjectSet) {
            if (isFirst) {
                buf.append(", ");
                isFirst = false;
            }
            buf.append(obj.getId());
        }
        buf.append("]");
        return buf.toString();
    }
}

