/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPImplicitMethod
extends CPPImplicitFunction
implements ICPPMethod {
    public CPPImplicitMethod(ICPPClassScope scope, char[] name, ICPPFunctionType type, ICPPParameter[] params) {
        super(name, scope, type, params, false);
    }

    public int getVisibility() {
        IASTDeclaration decl = this.getPrimaryDeclaration();
        if (decl == null) {
            return 1;
        }
        IASTNode parent = decl.getParent();
        while (parent instanceof ICPPASTTemplateDeclaration) {
            decl = (ICPPASTTemplateDeclaration)parent;
            parent = parent.getParent();
        }
        if (parent instanceof IASTCompositeTypeSpecifier) {
            IASTCompositeTypeSpecifier cls = (IASTCompositeTypeSpecifier)decl.getParent();
            IASTDeclaration[] members = cls.getMembers();
            ICPPASTVisibilityLabel vis = null;
            IASTDeclaration[] iASTDeclarationArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclaration member = iASTDeclarationArray[n2];
                if (member instanceof ICPPASTVisibilityLabel) {
                    vis = (ICPPASTVisibilityLabel)member;
                } else if (member == decl) break;
                ++n2;
            }
            if (vis != null) {
                return vis.getVisibility();
            }
            if (cls.getKey() == 3) {
                return 3;
            }
        }
        return 1;
    }

    public ICPPClassType getClassOwner() {
        ICPPClassScope scope = (ICPPClassScope)this.getScope();
        return scope.getClassType();
    }

    public IASTDeclaration getPrimaryDeclaration() {
        IASTDeclaration[] members;
        if (this.declarations != null) {
            IASTDeclarator[] iASTDeclaratorArray = this.declarations;
            int n = this.declarations.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclarator dtor = iASTDeclaratorArray[n2];
                if (dtor == null) break;
                IASTDeclaration decl = (IASTDeclaration)ASTQueries.findOutermostDeclarator(dtor).getParent();
                IASTNode parent = decl.getParent();
                while (parent instanceof ICPPASTTemplateDeclaration) {
                    parent = parent.getParent();
                }
                if (parent instanceof ICPPASTCompositeTypeSpecifier) {
                    return decl;
                }
                ++n2;
            }
        }
        IType ftype = this.getType();
        IType[] params = ftype.getParameterTypes();
        ICPPASTCompositeTypeSpecifier compSpec = (ICPPASTCompositeTypeSpecifier)ASTInternal.getPhysicalNodeOfScope(this.getScope());
        if (compSpec == null) {
            return null;
        }
        IASTDeclaration[] iASTDeclarationArray = members = compSpec.getMembers();
        int n = members.length;
        int n3 = 0;
        while (n3 < n) {
            block24: {
                IASTDeclarator[] ds;
                IASTDeclaration member;
                block23: {
                    block22: {
                        member = iASTDeclarationArray[n3];
                        ds = null;
                        while (member instanceof ICPPASTTemplateDeclaration) {
                            member = ((ICPPASTTemplateDeclaration)member).getDeclaration();
                        }
                        if (!(member instanceof IASTSimpleDeclaration)) break block22;
                        ds = ((IASTSimpleDeclaration)member).getDeclarators();
                        break block23;
                    }
                    if (!(member instanceof IASTFunctionDefinition)) break block24;
                    ds = new IASTDeclarator[]{((IASTFunctionDefinition)member).getDeclarator()};
                }
                IASTDeclarator[] iASTDeclaratorArray = ds;
                int n4 = ds.length;
                int n5 = 0;
                while (n5 < n4) {
                    IASTDeclarator dtor = iASTDeclaratorArray[n5];
                    IASTName name = ASTQueries.findInnermostDeclarator(dtor).getName();
                    if (ASTQueries.findTypeRelevantDeclarator(dtor) instanceof ICPPASTFunctionDeclarator && CharArrayUtils.equals(name.getLookupKey(), this.getNameCharArray())) {
                        IType t0 = CPPVisitor.createType(dtor);
                        boolean ok = false;
                        if (t0 instanceof IFunctionType) {
                            IFunctionType t = (IFunctionType)t0;
                            IType[] ps = t.getParameterTypes();
                            if (ps.length == params.length) {
                                int idx = 0;
                                while (idx < ps.length && ps[idx] != null) {
                                    if (!ps[idx].isSameType(params[idx])) break;
                                    ++idx;
                                }
                                ok = idx == ps.length;
                            } else if (ps.length == 0 && params.length == 1) {
                                ok = SemanticUtil.isVoidType(params[0]);
                            }
                        } else {
                            ok = false;
                        }
                        if (ok) {
                            name.setBinding(this);
                            if (member instanceof IASTSimpleDeclaration) {
                                ASTInternal.addDeclaration(this, dtor);
                            } else if (member instanceof IASTFunctionDefinition) {
                                ASTInternal.addDefinition(this, dtor);
                            }
                            return member;
                        }
                    }
                    ++n5;
                }
            }
            ++n3;
        }
        return null;
    }

    public boolean isVirtual() {
        return false;
    }

    public boolean isDestructor() {
        char[] n = this.getNameCharArray();
        if (n != null && n.length > 0) {
            return n[0] == '~';
        }
        return false;
    }

    public boolean isImplicit() {
        return this.getPrimaryDeclaration() == null;
    }

    public boolean isExplicit() {
        return false;
    }

    public boolean isPureVirtual() {
        return false;
    }

    public IBinding getOwner() {
        return this.getClassOwner();
    }

    public IType[] getExceptionSpecification() {
        return ClassTypeHelper.getInheritedExceptionSpecification(this);
    }
}

