/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.util;

import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.IContentAssistMatcher;
import org.eclipse.cdt.core.parser.util.SegmentMatcher;

public class ContentAssistMatcherFactory {
    private static ContentAssistMatcherFactory instance = null;
    private boolean showCamelCaseMatches = true;

    private ContentAssistMatcherFactory() {
    }

    public static synchronized ContentAssistMatcherFactory getInstance() {
        if (instance == null) {
            instance = new ContentAssistMatcherFactory();
        }
        return instance;
    }

    public synchronized void setShowCamelCaseMatches(boolean showCamelCaseMatches) {
        this.showCamelCaseMatches = showCamelCaseMatches;
    }

    public boolean getShowCamelCaseMatches() {
        return this.showCamelCaseMatches;
    }

    public synchronized IContentAssistMatcher createMatcher(char[] pattern) {
        return this.showCamelCaseMatches ? new CamelCaseMatcher(pattern) : new PrefixMatcher(pattern);
    }

    public IContentAssistMatcher createMatcher(String pattern) {
        return this.createMatcher(pattern.toCharArray());
    }

    public boolean match(char[] pattern, char[] name) {
        return this.createMatcher(pattern).match(name);
    }

    private static class CamelCaseMatcher
    implements IContentAssistMatcher {
        private final SegmentMatcher matcher;

        public CamelCaseMatcher(char[] pattern) {
            this.matcher = new SegmentMatcher(pattern);
        }

        public char[] getPrefixForBinarySearch() {
            return this.matcher.getPrefixForBinarySearch();
        }

        public boolean matchRequiredAfterBinarySearch() {
            return this.matcher.matchRequiredAfterBinarySearch();
        }

        public boolean match(char[] name) {
            return this.matcher.match(name);
        }
    }

    private static class PrefixMatcher
    implements IContentAssistMatcher {
        private final char[] prefix;

        public PrefixMatcher(char[] prefix) {
            this.prefix = prefix;
        }

        public char[] getPrefixForBinarySearch() {
            return this.prefix;
        }

        public boolean matchRequiredAfterBinarySearch() {
            return false;
        }

        public boolean match(char[] name) {
            return CharArrayUtils.equals(name, 0, this.prefix.length, this.prefix, true);
        }
    }
}

