/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.swt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.internal.services.EclipseAdapter;
import org.eclipse.e4.core.services.adapter.Adapter;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.log.ILoggerProvider;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.core.services.translation.TranslationProviderFactory;
import org.eclipse.e4.core.services.translation.TranslationService;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.internal.workbench.ActiveChildLookupFunction;
import org.eclipse.e4.ui.internal.workbench.ActivePartLookupFunction;
import org.eclipse.e4.ui.internal.workbench.DefaultLoggerProvider;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.ExceptionHandler;
import org.eclipse.e4.ui.internal.workbench.ModelServiceImpl;
import org.eclipse.e4.ui.internal.workbench.PlaceholderResolver;
import org.eclipse.e4.ui.internal.workbench.ReflectionContributionFactory;
import org.eclipse.e4.ui.internal.workbench.ResourceHandler;
import org.eclipse.e4.ui.internal.workbench.SelectionAggregator;
import org.eclipse.e4.ui.internal.workbench.SelectionServiceImpl;
import org.eclipse.e4.ui.internal.workbench.WorkbenchLogger;
import org.eclipse.e4.ui.internal.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.e4.ui.model.application.MAddon;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.workbench.IExceptionHandler;
import org.eclipse.e4.ui.workbench.IModelResourceHandler;
import org.eclipse.e4.ui.workbench.lifecycle.PostContextCreate;
import org.eclipse.e4.ui.workbench.lifecycle.PreSave;
import org.eclipse.e4.ui.workbench.lifecycle.ProcessAdditions;
import org.eclipse.e4.ui.workbench.lifecycle.ProcessRemovals;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPlaceholderResolver;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.swt.internal.copy.WorkbenchSWTMessages;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.w3c.dom.css.CSSStyleDeclaration;

public class E4Application
implements IApplication {
    private static final String PLUGIN_ID = "org.eclipse.e4.ui.workbench.swt";
    public static final String METADATA_FOLDER = ".metadata";
    private static final String VERSION_FILENAME = "version.ini";
    private static final String WORKSPACE_VERSION_KEY = "org.eclipse.core.runtime";
    private static final String WORKSPACE_VERSION_VALUE = "2";
    private static final String APPLICATION_MODEL_PATH_DEFAULT = "Application.e4xmi";
    private String[] args;
    private IModelResourceHandler handler;
    private Display display = null;
    private E4Workbench workbench = null;
    public static final String THEME_ID = "cssTheme";
    private Object lcManager;
    private static final String CONTEXT_INITIALIZED = "org.eclipse.ui.contextInitialized";

    public Display getApplicationDisplay() {
        if (this.display == null) {
            this.display = Display.getDefault();
        }
        return this.display;
    }

    public Object start(IApplicationContext applicationContext) throws Exception {
        IProduct product = Platform.getProduct();
        if (product != null && product.getName() != null) {
            Display.setAppName((String)product.getName());
        }
        Display display = this.getApplicationDisplay();
        E4Workbench workbench = this.createE4Workbench(applicationContext, display);
        Location instanceLocation = (Location)workbench.getContext().get("instanceLocation");
        Shell shell = display.getActiveShell();
        if (shell == null) {
            shell = new Shell();
            shell.setLocation(0, 10000);
        }
        try {
            if (!this.checkInstanceLocation(instanceLocation, shell)) {
                Integer n = EXIT_OK;
                return n;
            }
            IEclipseContext workbenchContext = workbench.getContext();
            workbenchContext.set(Display.class, (Object)display);
            workbench.createAndRunUI((MApplicationElement)workbench.getApplication());
            if (this.lcManager != null) {
                ContextInjectionFactory.invoke((Object)this.lcManager, PreSave.class, (IEclipseContext)workbenchContext, null);
            }
            this.saveModel();
            workbench.close();
            Integer n = EXIT_OK;
            return n;
        }
        finally {
            if (display != null) {
                display.dispose();
            }
            if (instanceLocation != null) {
                instanceLocation.release();
            }
        }
    }

    public void saveModel() {
        try {
            this.handler.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public E4Workbench createE4Workbench(IApplicationContext applicationContext, final Display display) {
        this.args = (String[])applicationContext.getArguments().get("application.args");
        IEclipseContext appContext = E4Application.createDefaultContext();
        appContext.set(Realm.class, (Object)SWTObservables.getRealm((Display)display));
        appContext.set(UISynchronize.class, (Object)new UISynchronize(){

            public void syncExec(Runnable runnable) {
                display.syncExec(runnable);
            }

            public void asyncExec(Runnable runnable) {
                display.asyncExec(runnable);
            }
        });
        appContext.set(IApplicationContext.class, (Object)applicationContext);
        if (!appContext.containsKey("org.eclipse.e4.ui.workbench.modeling.EPartService")) {
            throw new IllegalStateException("Core services not available. Please make sure that a declarative service implementation (such as the bundle 'org.eclipse.equinox.ds') is available!");
        }
        IContributionFactory factory = (IContributionFactory)appContext.get(IContributionFactory.class.getName());
        String lifeCycleURI = this.getArgValue("lifeCycleURI", applicationContext, false);
        if (lifeCycleURI != null) {
            this.lcManager = factory.create(lifeCycleURI, appContext);
            if (this.lcManager != null) {
                ContextInjectionFactory.invoke((Object)this.lcManager, PostContextCreate.class, (IEclipseContext)appContext, null);
            }
        }
        MApplication appModel = this.loadApplicationModel(applicationContext, appContext);
        appModel.setContext(appContext);
        boolean isRtl = (Window.getDefaultOrientation() & 0x4000000) != 0;
        appModel.getTransientData().put("dir", isRtl);
        if (!E4Workbench.getServiceContext().containsKey(MApplication.class.getName())) {
            E4Workbench.getServiceContext().set(MApplication.class.getName(), (Object)appModel);
        }
        appContext.set(MApplication.class.getName(), (Object)appModel);
        ContextInjectionFactory.setDefault((IEclipseContext)appContext);
        E4Application.initializeServices(appModel);
        if (this.lcManager != null) {
            ContextInjectionFactory.invoke((Object)this.lcManager, ProcessAdditions.class, (IEclipseContext)appContext, null);
            ContextInjectionFactory.invoke((Object)this.lcManager, ProcessRemovals.class, (IEclipseContext)appContext, null);
        }
        IEclipseContext addonStaticContext = EclipseContextFactory.create();
        for (MAddon addon : appModel.getAddons()) {
            addonStaticContext.set(MAddon.class, (Object)addon);
            Object obj = factory.create(addon.getContributionURI(), appContext, addonStaticContext);
            addon.setObject(obj);
        }
        String xmiURI = this.getArgValue("applicationXMI", applicationContext, false);
        appContext.set("applicationXMI", (Object)xmiURI);
        String themeId = this.getArgValue(THEME_ID, applicationContext, false);
        appContext.set(THEME_ID, (Object)themeId);
        String cssURI = this.getArgValue("applicationCSS", applicationContext, false);
        if (cssURI != null) {
            appContext.set("applicationCSS", (Object)cssURI);
        }
        if (cssURI != null && !cssURI.startsWith("platform:")) {
            System.err.println("Warning " + cssURI + " changed its meaning it is used now to run without theme support");
            appContext.set(THEME_ID, (Object)cssURI);
        }
        String cssResourcesURI = this.getArgValue("applicationCSSResources", applicationContext, false);
        appContext.set("applicationCSSResources", (Object)cssResourcesURI);
        appContext.set("rendererFactoryUri", (Object)this.getArgValue("rendererFactoryUri", applicationContext, false));
        String presentationURI = this.getArgValue("presentationURI", applicationContext, false);
        if (presentationURI == null) {
            presentationURI = "bundleclass://org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine";
        }
        appContext.set("presentationURI", (Object)presentationURI);
        this.workbench = new E4Workbench((MApplicationElement)appModel, appContext);
        return this.workbench;
    }

    private MApplication loadApplicationModel(IApplicationContext appContext, IEclipseContext eclipseContext) {
        Bundle brandingBundle;
        MApplication theApp = null;
        Location instanceLocation = WorkbenchSWTActivator.getDefault().getInstanceLocation();
        String appModelPath = this.getArgValue("applicationXMI", appContext, false);
        if ((appModelPath == null || appModelPath.length() == 0) && (brandingBundle = appContext.getBrandingBundle()) != null) {
            appModelPath = String.valueOf(brandingBundle.getSymbolicName()) + "/" + APPLICATION_MODEL_PATH_DEFAULT;
        }
        Assert.isNotNull((Object)appModelPath, (String)"applicationXMI argument missing");
        URI initialWorkbenchDefinitionInstance = URI.createPlatformPluginURI((String)appModelPath, (boolean)true);
        eclipseContext.set("initialWorkbenchModelURI", (Object)initialWorkbenchDefinitionInstance);
        eclipseContext.set("instanceLocation", (Object)instanceLocation);
        String value = this.getArgValue("persistState", appContext, false);
        boolean saveAndRestore = value == null || Boolean.parseBoolean(value);
        eclipseContext.set("persistState", (Object)saveAndRestore);
        value = this.getArgValue("clearPersistedState", appContext, true);
        boolean clearPersistedState = value != null && Boolean.parseBoolean(value);
        eclipseContext.set("clearPersistedState", (Object)clearPersistedState);
        value = this.getArgValue("deltaRestore", appContext, false);
        boolean deltaRestore = value == null || Boolean.parseBoolean(value);
        eclipseContext.set("deltaRestore", (Object)deltaRestore);
        String resourceHandler = this.getArgValue("modelResourceHandler", appContext, false);
        if (resourceHandler == null) {
            resourceHandler = "bundleclass://org.eclipse.e4.ui.workbench/" + ResourceHandler.class.getName();
        }
        IContributionFactory factory = (IContributionFactory)eclipseContext.get(IContributionFactory.class);
        this.handler = (IModelResourceHandler)factory.create(resourceHandler, eclipseContext);
        Resource resource = this.handler.loadMostRecentModel();
        theApp = (MApplication)resource.getContents().get(0);
        return theApp;
    }

    private String getArgValue(String argName, IApplicationContext appContext, boolean singledCmdArgValue) {
        int i;
        if (argName == null || argName.length() == 0) {
            return null;
        }
        if (singledCmdArgValue) {
            i = 0;
            while (i < this.args.length) {
                if (("-" + argName).equals(this.args[i])) {
                    return "true";
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.args.length) {
                if (("-" + argName).equals(this.args[i]) && i + 1 < this.args.length) {
                    return this.args[i + 1];
                }
                ++i;
            }
        }
        String brandingProperty = appContext.getBrandingProperty(argName);
        return brandingProperty == null ? System.getProperty(argName) : brandingProperty;
    }

    public void stop() {
        if (this.workbench != null) {
            this.workbench.close();
        }
    }

    public static IEclipseContext createDefaultHeadlessContext() {
        IEclipseContext serviceContext = E4Workbench.getServiceContext();
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        ExceptionHandler exceptionHandler = new ExceptionHandler();
        ReflectionContributionFactory contributionFactory = new ReflectionContributionFactory(registry);
        serviceContext.set(IContributionFactory.class, (Object)contributionFactory);
        serviceContext.set(IExceptionHandler.class, (Object)exceptionHandler);
        serviceContext.set(IExtensionRegistry.class, (Object)registry);
        String locale = Locale.getDefault().toString();
        serviceContext.set("org.eclipse.e4.core.locale", (Object)locale);
        TranslationService bundleTranslationProvider = TranslationProviderFactory.bundleTranslationService((IEclipseContext)serviceContext);
        serviceContext.set(TranslationService.class, (Object)bundleTranslationProvider);
        serviceContext.set(Adapter.class, (Object)((Adapter)ContextInjectionFactory.make(EclipseAdapter.class, (IEclipseContext)serviceContext)));
        if (serviceContext.get(ILoggerProvider.class) == null) {
            serviceContext.set(ILoggerProvider.class, (Object)((ILoggerProvider)ContextInjectionFactory.make(DefaultLoggerProvider.class, (IEclipseContext)serviceContext)));
        }
        return serviceContext;
    }

    public static IEclipseContext createDefaultContext() {
        IEclipseContext serviceContext = E4Application.createDefaultHeadlessContext();
        IEclipseContext appContext = serviceContext.createChild("WorkbenchContext");
        appContext.set(Logger.class, (Object)((Logger)ContextInjectionFactory.make(WorkbenchLogger.class, (IEclipseContext)appContext)));
        appContext.set(EModelService.class, (Object)new ModelServiceImpl(appContext));
        appContext.set(EPlaceholderResolver.class, (Object)new PlaceholderResolver());
        appContext.set("e4ActivePart", (Object)new ActivePartLookupFunction());
        appContext.set("activeShell", (Object)new ActiveChildLookupFunction("activeShell", "localActiveShell"));
        appContext.set(IStylingEngine.class, (Object)new IStylingEngine(){

            public void setClassname(Object widget, String classname) {
            }

            public void setId(Object widget, String id) {
            }

            public void style(Object widget) {
            }

            public CSSStyleDeclaration getStyle(Object widget) {
                return null;
            }

            public void setClassnameAndId(Object widget, String classname, String id) {
            }
        });
        return appContext;
    }

    private boolean checkInstanceLocation(Location instanceLocation, Shell shell) {
        if (instanceLocation == null) {
            MessageDialog.openError((Shell)shell, (String)WorkbenchSWTMessages.IDEApplication_workspaceMandatoryTitle, (String)WorkbenchSWTMessages.IDEApplication_workspaceMandatoryMessage);
            return false;
        }
        if (instanceLocation.isSet()) {
            block8: {
                if (!this.checkValidWorkspace(shell, instanceLocation.getURL())) {
                    return false;
                }
                if (!instanceLocation.lock()) break block8;
                E4Application.writeWorkspaceVersion();
                return true;
            }
            try {
                File workspaceDirectory = new File(instanceLocation.getURL().getFile());
                if (workspaceDirectory.exists()) {
                    MessageDialog.openError((Shell)shell, (String)WorkbenchSWTMessages.IDEApplication_workspaceCannotLockTitle, (String)WorkbenchSWTMessages.IDEApplication_workspaceCannotLockMessage);
                } else {
                    MessageDialog.openError((Shell)shell, (String)WorkbenchSWTMessages.IDEApplication_workspaceCannotBeSetTitle, (String)WorkbenchSWTMessages.IDEApplication_workspaceCannotBeSetMessage);
                }
            }
            catch (IOException e) {
                WorkbenchLogger logger = new WorkbenchLogger(PLUGIN_ID);
                logger.error((Throwable)e);
                MessageDialog.openError((Shell)shell, (String)WorkbenchSWTMessages.InternalError, (String)e.getMessage());
            }
            return false;
        }
        return false;
    }

    private boolean checkValidWorkspace(Shell shell, URL url) {
        if (url == null) {
            return false;
        }
        String version = E4Application.readWorkspaceVersion(url);
        if (version == null) {
            return true;
        }
        int ide_version = Integer.parseInt(WORKSPACE_VERSION_VALUE);
        int workspace_version = Integer.parseInt(version);
        if (workspace_version == ide_version) {
            return true;
        }
        String title = WorkbenchSWTMessages.IDEApplication_versionTitle;
        String message = NLS.bind((String)WorkbenchSWTMessages.IDEApplication_versionMessage, (Object)url.getFile());
        MessageBox mbox = new MessageBox(shell, 65832);
        mbox.setText(title);
        mbox.setMessage(message);
        return mbox.open() == 32;
    }

    private static String readWorkspaceVersion(URL workspace) {
        File versionFile = E4Application.getVersionFile(workspace, false);
        if (versionFile == null || !versionFile.exists()) {
            return null;
        }
        try {
            Properties props = new Properties();
            FileInputStream is = new FileInputStream(versionFile);
            try {
                props.load(is);
            }
            finally {
                is.close();
            }
            return props.getProperty(WORKSPACE_VERSION_KEY);
        }
        catch (IOException e) {
            WorkbenchLogger logger = new WorkbenchLogger(PLUGIN_ID);
            logger.error((Throwable)e);
            return null;
        }
    }

    private static void writeWorkspaceVersion() {
        block16: {
            Location instanceLoc = Platform.getInstanceLocation();
            if (instanceLoc == null || instanceLoc.isReadOnly()) {
                return;
            }
            File versionFile = E4Application.getVersionFile(instanceLoc.getURL(), true);
            if (versionFile == null) {
                return;
            }
            OutputStream output = null;
            try {
                try {
                    String versionLine = "org.eclipse.core.runtime=2";
                    output = new FileOutputStream(versionFile);
                    output.write(versionLine.getBytes("UTF-8"));
                }
                catch (IOException e) {
                    WorkbenchLogger logger = new WorkbenchLogger(PLUGIN_ID);
                    logger.error((Throwable)e);
                    try {
                        if (output != null) {
                            output.close();
                        }
                        break block16;
                    }
                    catch (IOException iOException) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static File getVersionFile(URL workspaceUrl, boolean create) {
        File versionFile;
        block6: {
            File metaDir;
            block5: {
                if (workspaceUrl == null) {
                    return null;
                }
                try {
                    metaDir = new File(workspaceUrl.getPath(), METADATA_FOLDER);
                    if (metaDir.exists() || create && metaDir.mkdir()) break block5;
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            versionFile = new File(metaDir, VERSION_FILENAME);
            if (versionFile.exists() || create && versionFile.createNewFile()) break block6;
            return null;
        }
        return versionFile;
    }

    public static void initializeServices(MApplication appModel) {
        IEclipseContext appContext = appModel.getContext();
        if (appContext.containsKey(CONTEXT_INITIALIZED)) {
            return;
        }
        appContext.set(CONTEXT_INITIALIZED, (Object)"true");
        E4Application.initializeApplicationServices(appContext);
        List windows = appModel.getChildren();
        for (MWindow childWindow : windows) {
            E4Application.initializeWindowServices(childWindow);
        }
        ((EObject)appModel).eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (notification.getFeatureID(MApplication.class) != 15) {
                    return;
                }
                if (notification.getEventType() != 3) {
                    return;
                }
                MWindow childWindow = (MWindow)notification.getNewValue();
                E4Application.initializeWindowServices(childWindow);
            }
        });
    }

    public static void initializeApplicationServices(IEclipseContext appContext) {
        final IEclipseContext theContext = appContext;
        appContext.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                IEclipseContext activeChildContext = context.getActiveChild();
                if (activeChildContext != null) {
                    Object selection = activeChildContext.get("org.eclipse.ui.selection");
                    theContext.set("org.eclipse.ui.selection", selection);
                }
                return true;
            }
        });
        appContext.set(ESelectionService.class.getName(), (Object)new IContextFunction(){

            public Object compute(IEclipseContext context) {
                return ContextInjectionFactory.make(SelectionServiceImpl.class, (IEclipseContext)context);
            }
        });
    }

    public static void initializeWindowServices(MWindow childWindow) {
        IEclipseContext windowContext = childWindow.getContext();
        E4Application.initWindowContext(windowContext);
        ((EObject)childWindow).eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (notification.getFeatureID(MWindow.class) != 20) {
                    return;
                }
                IEclipseContext windowContext = (IEclipseContext)notification.getNewValue();
                E4Application.initWindowContext(windowContext);
            }
        });
    }

    private static void initWindowContext(IEclipseContext windowContext) {
        if (windowContext == null) {
            return;
        }
        SelectionAggregator selectionAggregator = (SelectionAggregator)ContextInjectionFactory.make(SelectionAggregator.class, (IEclipseContext)windowContext);
        windowContext.set(SelectionAggregator.class, (Object)selectionAggregator);
    }
}

