/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.build;

import com.android.ide.common.resources.ResourceUrl;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.editors.AndroidXmlEditor;
import com.android.ide.eclipse.adt.internal.resources.ResourceHelper;
import com.android.resources.ResourceType;
import com.android.utils.Pair;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class AaptQuickFix
implements IMarkerResolutionGenerator2,
IQuickAssistProcessor {
    private static String getTargetMarkerErrorMessage() {
        return "No resource found that matches the given name";
    }

    private static String getUnboundErrorMessage() {
        return "Error parsing XML: unbound prefix";
    }

    public boolean hasResolutions(IMarker marker) {
        String message = null;
        try {
            message = (String)marker.getAttribute("message");
        }
        catch (CoreException e) {
            AdtPlugin.log(e, null, new Object[0]);
        }
        return message != null && (message.contains(AaptQuickFix.getTargetMarkerErrorMessage()) || message.contains(AaptQuickFix.getUnboundErrorMessage()));
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        IResource markerResource = marker.getResource();
        IProject project = markerResource.getProject();
        try {
            String message = (String)marker.getAttribute("message");
            if (message.contains(AaptQuickFix.getUnboundErrorMessage()) && markerResource instanceof IFile) {
                return new IMarkerResolution[]{new CreateNamespaceFix((IFile)markerResource)};
            }
        }
        catch (CoreException e1) {
            AdtPlugin.log(e1, null, new Object[0]);
        }
        int start = marker.getAttribute("charStart", 0);
        int end = marker.getAttribute("charEnd", 0);
        if (end > start) {
            int length = end - start;
            TextFileDocumentProvider provider = new TextFileDocumentProvider();
            try {
                provider.connect((Object)markerResource);
                IDocument document = provider.getDocument((Object)markerResource);
                String resource = document.get(start, length);
                if (ResourceHelper.canCreateResource(resource)) {
                    IMarkerResolution[] iMarkerResolutionArray = new IMarkerResolution[]{new CreateResourceProposal(project, resource)};
                    return iMarkerResolutionArray;
                }
            }
            catch (Exception e) {
                AdtPlugin.log(e, "Can't find range information for %1$s", markerResource);
            }
            finally {
                provider.disconnect((Object)markerResource);
            }
        }
        return null;
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return true;
    }

    public boolean canFix(Annotation annotation) {
        return true;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        ISourceViewer sourceViewer = invocationContext.getSourceViewer();
        AndroidXmlEditor editor = AndroidXmlEditor.fromTextViewer((ITextViewer)sourceViewer);
        if (editor != null) {
            IFile file = editor.getInputFile();
            if (file == null) {
                return null;
            }
            IDocument document = sourceViewer.getDocument();
            List<IMarker> markers = AdtUtils.findMarkersOnLine("com.android.ide.eclipse.common.aaptProblem", (IResource)file, document, invocationContext.getOffset());
            try {
                for (IMarker marker : markers) {
                    String message = marker.getAttribute("message", "");
                    if (message.contains(AaptQuickFix.getTargetMarkerErrorMessage())) {
                        int end;
                        int length;
                        int start = marker.getAttribute("charStart", 0);
                        String resource = document.get(start, length = (end = marker.getAttribute("charEnd", 0)) - start);
                        if (!ResourceHelper.canCreateResource(resource)) continue;
                        IProject project = editor.getProject();
                        return new ICompletionProposal[]{new CreateResourceProposal(project, resource)};
                    }
                    if (!message.contains(AaptQuickFix.getUnboundErrorMessage())) continue;
                    return new ICompletionProposal[]{new CreateNamespaceFix(null)};
                }
            }
            catch (BadLocationException e) {
                AdtPlugin.log(e, null, new Object[0]);
            }
        }
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    private static final class CreateNamespaceFix
    implements ICompletionProposal,
    IMarkerResolution2 {
        private IFile mFile;

        public CreateNamespaceFix(IFile file) {
            this.mFile = file;
        }

        private IndexedRegion perform(IDocument doc) {
            IModelManager manager = StructuredModelManager.getModelManager();
            IStructuredModel model = manager.getExistingModelForEdit(doc);
            if (model != null) {
                try {
                    this.perform(model);
                }
                finally {
                    model.releaseFromEdit();
                }
            }
            return null;
        }

        private IndexedRegion perform(IFile file) {
            block5: {
                IModelManager manager = StructuredModelManager.getModelManager();
                try {
                    IStructuredModel model = manager.getModelForEdit(file);
                    if (model == null) break block5;
                    try {
                        this.perform(model);
                    }
                    finally {
                        model.releaseFromEdit();
                    }
                }
                catch (Exception e) {
                    AdtPlugin.log(e, "Can't look up XML model", new Object[0]);
                }
            }
            return null;
        }

        private IndexedRegion perform(IStructuredModel model) {
            if (model instanceof IDOMModel) {
                IDOMModel domModel = (IDOMModel)model;
                IDOMDocument document = domModel.getDocument();
                Element element = document.getDocumentElement();
                Attr attr = document.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:android");
                attr.setValue("http://schemas.android.com/apk/res/android");
                element.getAttributes().setNamedItemNS(attr);
                return (IndexedRegion)attr;
            }
            return null;
        }

        public void apply(IDocument document) {
            this.perform(document);
        }

        public String getAdditionalProposalInfo() {
            return "Adds an Android namespace declaratiopn to the root element.";
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public String getDisplayString() {
            return "Insert namespace binding";
        }

        public Image getImage() {
            return AdtPlugin.getAndroidLogo();
        }

        public Point getSelection(IDocument doc) {
            return null;
        }

        public String getLabel() {
            return this.getDisplayString();
        }

        public void run(IMarker marker) {
            try {
                AdtPlugin.openFile(this.mFile, null);
            }
            catch (PartInitException e) {
                AdtPlugin.log(e, "Can't open file %1$s", this.mFile.getName());
            }
            IndexedRegion indexedRegion = this.perform(this.mFile);
            if (indexedRegion != null) {
                try {
                    Region region = new Region(indexedRegion.getStartOffset(), indexedRegion.getLength());
                    AdtPlugin.openFile(this.mFile, (IRegion)region);
                }
                catch (PartInitException e) {
                    AdtPlugin.log(e, "Can't open file %1$s", this.mFile.getName());
                }
            }
        }

        public String getDescription() {
            return this.getAdditionalProposalInfo();
        }
    }

    private static class CreateResourceProposal
    implements ICompletionProposal,
    IMarkerResolution2 {
        private final IProject mProject;
        private final String mResource;

        CreateResourceProposal(IProject project, String resource) {
            this.mProject = project;
            this.mResource = resource;
        }

        private void perform() {
            ResourceUrl resource = ResourceUrl.parse((String)this.mResource);
            if (resource == null) {
                return;
            }
            ResourceType type = resource.type;
            String name = resource.name;
            assert (!resource.framework);
            String value = "";
            switch (type) {
                case STRING: {
                    value = "TODO";
                    break;
                }
                case DIMEN: {
                    value = "1dp";
                    break;
                }
                case BOOL: {
                    value = "true";
                    break;
                }
                case COLOR: {
                    value = "#000000";
                    break;
                }
                case INTEGER: {
                    value = "1";
                    break;
                }
                case ARRAY: {
                    value = "<item>1</item>";
                }
            }
            Pair<IFile, IRegion> location = ResourceHelper.createResource(this.mProject, type, name, value);
            if (location != null) {
                IFile file = (IFile)location.getFirst();
                IRegion region = (IRegion)location.getSecond();
                try {
                    AdtPlugin.openFile(file, region);
                }
                catch (PartInitException e) {
                    AdtPlugin.log(e, "Can't open file %1$s", file.getName());
                }
            }
        }

        public void apply(IDocument document) {
            this.perform();
        }

        public String getAdditionalProposalInfo() {
            return "Creates an XML file entry for the given missing resource and opens it in the editor.";
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public String getDisplayString() {
            return String.format("Create resource %1$s", this.mResource);
        }

        public Image getImage() {
            return AdtPlugin.getAndroidLogo();
        }

        public Point getSelection(IDocument document) {
            return null;
        }

        public String getLabel() {
            return this.getDisplayString();
        }

        public void run(IMarker marker) {
            this.perform();
        }

        public String getDescription() {
            return this.getAdditionalProposalInfo();
        }
    }
}

