/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.build.builders;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.build.Messages;
import com.android.ide.eclipse.adt.internal.build.builders.BaseBuilder;
import com.android.ide.eclipse.adt.internal.preferences.AdtPrefs;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.project.ProjectHelper;
import com.android.ide.eclipse.adt.internal.sdk.ProjectState;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.utils.Pair;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class ResourceManagerBuilder
extends BaseBuilder {
    public static final String ID = "com.android.ide.eclipse.adt.ResourceManagerBuilder";

    protected void clean(IProgressMonitor monitor) throws CoreException {
        super.clean(monitor);
        IProject project = this.getProject();
        this.removeMarkersFromContainer((IContainer)project, "com.android.ide.eclipse.adt.adtProblem");
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IFolder binResFolder;
        final IProject project = this.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        this.removeMarkersFromContainer((IContainer)project, "com.android.ide.eclipse.adt.adtProblem");
        try {
            this.abortOnBadSetup(javaProject, null);
        }
        catch (BaseBuilder.AbortBuildException abortBuildException) {
            return null;
        }
        Pair<Integer, String> result = ProjectHelper.checkCompilerCompliance(project);
        String errorMessage = null;
        switch ((Integer)result.getFirst()) {
            case 1: {
                errorMessage = Messages.Requires_Compiler_Compliance_s;
                break;
            }
            case 2: {
                errorMessage = Messages.Requires_Source_Compatibility_s;
                break;
            }
            case 3: {
                errorMessage = Messages.Requires_Class_Compatibility_s;
            }
        }
        if (errorMessage != null) {
            Sdk currentSdk;
            errorMessage = String.format(errorMessage, result.getSecond() == null ? "(no value)" : (String)result.getSecond());
            if ("1.7".equals(result.getSecond()) && (currentSdk = Sdk.getCurrent()) != null) {
                ProjectState projectState;
                IAndroidTarget target = currentSdk.getTarget(project.getProject());
                if (target != null && target.getVersion().getApiLevel() < 19) {
                    errorMessage = "Using 1.7 requires compiling with Android 4.4 (KitKat); currently using " + target.getVersion();
                }
                if ((projectState = Sdk.getProjectState(project)) != null) {
                    BuildToolInfo buildToolInfo = projectState.getBuildToolInfo();
                    if (buildToolInfo == null) {
                        buildToolInfo = currentSdk.getLatestBuildTool();
                    }
                    if (buildToolInfo != null && buildToolInfo.getRevision().getMajor() < 19) {
                        errorMessage = "Using 1.7 requires using Android Build Tools version 19 or later; currently using " + buildToolInfo.getRevision();
                    }
                }
            }
            this.markProject("com.android.ide.eclipse.adt.adtProblem", errorMessage, 2);
            AdtPlugin.printErrorToConsole(project, new Object[]{errorMessage});
            return null;
        }
        String osSdkFolder = AdtPlugin.getOsSdkFolder();
        if (osSdkFolder == null || osSdkFolder.length() == 0) {
            AdtPlugin.printErrorToConsole(project, new Object[]{Messages.No_SDK_Setup_Error});
            this.markProject("com.android.ide.eclipse.adt.adtProblem", Messages.No_SDK_Setup_Error, 2);
            return null;
        }
        boolean hasGenSrcFolder = false;
        IClasspathEntry[] classpaths = javaProject.readRawClasspath();
        if (classpaths != null) {
            IClasspathEntry[] iClasspathEntryArray = classpaths;
            int n = classpaths.length;
            int n2 = 0;
            while (n2 < n) {
                IPath path;
                IClasspathEntry e = iClasspathEntryArray[n2];
                if (e.getEntryKind() == 3 && (path = e.getPath()).segmentCount() == 2 && path.segment(1).equals("gen")) {
                    hasGenSrcFolder = true;
                    break;
                }
                ++n2;
            }
        }
        boolean genFolderPresent = false;
        IResource resource = project.findMember("gen");
        boolean bl = genFolderPresent = resource != null && resource.exists();
        if (!hasGenSrcFolder && genFolderPresent) {
            String message = resource.getType() == 2 ? String.format("%1$s already exists but is not a source folder. Convert to a source folder or rename it.", resource.getFullPath().toString()) : String.format("Resource %1$s is in the way. ADT needs a source folder called 'gen' to work. Rename or delete resource.", resource.getFullPath().toString());
            AdtPlugin.printErrorToConsole(project, new Object[]{message});
            this.markProject("com.android.ide.eclipse.adt.adtProblem", message, 2);
            return null;
        }
        if (!hasGenSrcFolder || !genFolderPresent) {
            List<IPath> sourceFolders = BaseProjectHelper.getSourceClasspaths(javaProject);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            for (IPath path : sourceFolders) {
                IResource member = root.findMember(path);
                if (member == null) continue;
                this.removeDerivedResources(member, monitor);
            }
            IFolder genFolder = project.getFolder("gen");
            if (!genFolderPresent) {
                AdtPlugin.printBuildToConsole(AdtPrefs.BuildVerbosity.VERBOSE, project, "Creating 'gen' source folder for generated Java files");
                genFolder.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            }
            if (!hasGenSrcFolder) {
                IClasspathEntry[] entries = javaProject.getRawClasspath();
                entries = ProjectHelper.addEntryToClasspath(entries, JavaCore.newSourceEntry((IPath)genFolder.getFullPath()));
                javaProject.setRawClasspath(entries, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            }
            genFolder.refreshLocal(0, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            this.launchJob(new Job("rebuild"){

                protected IStatus run(IProgressMonitor m) {
                    try {
                        project.build(10, m);
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                }
            });
        }
        IFolder androidOutput = BaseProjectHelper.getAndroidOutputFolder(project);
        IFolder javaOutput = BaseProjectHelper.getJavaOutputFolder(project);
        if (!androidOutput.exists() || javaOutput == null || !javaOutput.getParent().equals((Object)androidOutput)) {
            IFolder newJavaOutput = androidOutput.getFolder("classes");
            if (!androidOutput.exists()) {
                androidOutput.create(true, true, monitor);
            }
            if (!newJavaOutput.exists()) {
                newJavaOutput.create(true, true, monitor);
            }
            javaProject.setOutputLocation(newJavaOutput.getFullPath(), monitor);
            this.launchJob(new Job("rebuild"){

                protected IStatus run(IProgressMonitor jobMonitor) {
                    try {
                        project.build(15, jobMonitor);
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                }
            });
        }
        if (!(binResFolder = androidOutput.getFolder("res")).exists()) {
            binResFolder.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            project.refreshLocal(1, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
        if (AdtPrefs.getPrefs().getBuildForceResResfresh()) {
            AdtPlugin.printBuildToConsole(AdtPrefs.BuildVerbosity.VERBOSE, project, Messages.Refreshing_Res);
            IFolder resFolder = project.getFolder("/res");
            resFolder.refreshLocal(2, monitor);
            IFolder assetsFolder = project.getFolder("/assets");
            assetsFolder.refreshLocal(2, monitor);
        }
        return null;
    }
}

