/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors;

import com.android.ide.common.api.IAttributeInfo;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.AndroidXmlEditor;
import com.android.ide.eclipse.adt.internal.editors.CompletionProposal;
import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.IDescriptorProvider;
import com.android.ide.eclipse.adt.internal.editors.descriptors.SeparatorAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.TextValueDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.DomUtilities;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiAttributeNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiFlagAttributeNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiResourceAttributeNode;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.utils.Pair;
import com.android.utils.XmlUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.w3c.dom.Node;

public abstract class AndroidContentAssist
implements IContentAssistProcessor {
    private static Pattern sFirstAttribute = Pattern.compile("^ *[a-zA-Z_:]+ *= *(?:\"[^<\"]*\"|'[^<']*')");
    private static Pattern sFirstElementWord = Pattern.compile("^[a-zA-Z0-9_:.-]+");
    private static Pattern sWhitespace = Pattern.compile("\\s+");
    protected static final String ROOT_ELEMENT = "";
    private ElementDescriptor mRootDescriptor;
    private final int mDescriptorId;
    protected AndroidXmlEditor mEditor;
    private static final String[] sDimensionUnits = new String[]{"dp", "<b>Density-independent Pixels</b> - an abstract unit that is based on the physical density of the screen.", "sp", "<b>Scale-independent Pixels</b> - this is like the dp unit, but it is also scaled by the user's font size preference.", "pt", "<b>Points</b> - 1/72 of an inch based on the physical size of the screen.", "mm", "<b>Millimeters</b> - based on the physical size of the screen.", "in", "<b>Inches</b> - based on the physical size of the screen.", "px", "<b>Pixels</b> - corresponds to actual pixels on the screen. Not recommended."};
    private static final String[] sFractionUnits = new String[]{"%", "<b>Fraction</b> - a percentage of the base size", "%p", "<b>Fraction</b> - a percentage relative to parent container"};

    public AndroidContentAssist(int descriptorId) {
        this.mDescriptorId = descriptorId;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String wordPrefix = this.extractElementPrefix(viewer, offset);
        if (this.mEditor == null) {
            this.mEditor = AndroidXmlEditor.fromTextViewer(viewer);
            if (this.mEditor == null) {
                AdtPlugin.log(4, "Editor not found during completion", new Object[0]);
                return null;
            }
        }
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>(80);
        Pair<Node, Node> context = DomUtilities.getNodeContext(viewer.getDocument(), offset);
        if (context == null) {
            return null;
        }
        Node parentNode = (Node)context.getFirst();
        Node currentNode = (Node)context.getSecond();
        assert (parentNode != null || currentNode != null);
        UiElementNode rootUiNode = this.mEditor.getUiRootNode();
        if (currentNode == null || currentNode.getNodeType() == 3) {
            UiElementNode parentUiNode = rootUiNode == null ? null : rootUiNode.findXmlNode(parentNode);
            this.computeTextValues(proposals, offset, parentNode, currentNode, parentUiNode, wordPrefix);
        } else if (currentNode.getNodeType() == 1) {
            String parent = currentNode.getNodeName();
            AttribInfo info = this.parseAttributeInfo(viewer, offset, offset - wordPrefix.length());
            char nextChar = this.extractChar(viewer, offset);
            if (info != null) {
                UiElementNode currentUiNode = rootUiNode == null ? null : rootUiNode.findXmlNode(currentNode);
                this.computeAttributeProposals(proposals, viewer, offset, wordPrefix, currentUiNode, parentNode, currentNode, parent, info, nextChar);
            } else {
                this.computeNonAttributeProposals(viewer, offset, wordPrefix, proposals, parentNode, currentNode, parent, nextChar);
            }
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private void computeNonAttributeProposals(ITextViewer viewer, int offset, String wordPrefix, List<ICompletionProposal> proposals, Node parentNode, Node currentNode, String parent, char nextChar) {
        if (AndroidContentAssist.startsWith(parent, wordPrefix)) {
            boolean isNew;
            Object[] choices = this.getChoicesForElement(parent, currentNode);
            if (choices == null || choices.length == 0) {
                return;
            }
            int replaceLength = parent.length() - wordPrefix.length();
            boolean bl = isNew = replaceLength == 0 && this.nextNonspaceChar(viewer, offset) == '<';
            if (wordPrefix.length() == 0 && nextChar == '<') {
                replaceLength = 0;
                isNew = true;
            }
            char needTag = this.computeElementNeedTag(viewer, offset, wordPrefix);
            this.addMatchingProposals(proposals, choices, offset, parentNode != null ? parentNode : null, wordPrefix, needTag, false, isNew, false, replaceLength);
        }
    }

    private void computeAttributeProposals(List<ICompletionProposal> proposals, ITextViewer viewer, int offset, String wordPrefix, UiElementNode currentUiNode, Node parentNode, Node currentNode, String parent, AttribInfo info, char nextChar) {
        if (info.isInValue && this.computeAttributeValues(proposals, offset, parent, info.name, currentNode, wordPrefix, info.skipEndTag, info.replaceLength)) {
            return;
        }
        Object[] choices = this.getChoicesForAttribute(parent, currentNode, currentUiNode, info, wordPrefix);
        if (choices == null || choices.length == 0) {
            return;
        }
        int replaceLength = info.replaceLength;
        if (info.correctedPrefix != null) {
            wordPrefix = info.correctedPrefix;
        }
        char needTag = info.needTag;
        boolean isNew = replaceLength == 0 && (Character.isWhitespace(nextChar) || nextChar == '>' || nextChar == '/');
        this.addMatchingProposals(proposals, choices, offset, parentNode != null ? parentNode : null, wordPrefix, needTag, true, isNew, info.skipEndTag, replaceLength);
    }

    private char computeElementNeedTag(ITextViewer viewer, int offset, String wordPrefix) {
        int needTag = 0;
        int offset2 = offset - wordPrefix.length() - 1;
        char c1 = this.extractChar(viewer, offset2);
        if (c1 != '<' && (c1 != '/' || this.extractChar(viewer, offset2 - 1) != '<')) {
            needTag = 60;
        }
        return (char)needTag;
    }

    protected int computeTextReplaceLength(Node currentNode, int offset) {
        int relativeOffset;
        if (currentNode == null) {
            return 0;
        }
        assert (currentNode != null && currentNode.getNodeType() == 3);
        String nodeValue = currentNode.getNodeValue();
        int lineEnd = nodeValue.indexOf(10, relativeOffset = offset - ((IndexedRegion)currentNode).getStartOffset());
        if (lineEnd == -1) {
            lineEnd = nodeValue.length();
        }
        return lineEnd - relativeOffset;
    }

    protected Object[] getChoicesForElement(String parent, Node currentNode) {
        ElementDescriptor grandparent = null;
        if (currentNode.getParentNode().getNodeType() == 1) {
            grandparent = this.getDescriptor(currentNode.getParentNode().getNodeName());
        } else if (currentNode.getParentNode().getNodeType() == 9) {
            grandparent = this.getRootDescriptor();
        }
        if (grandparent != null) {
            ElementDescriptor[] elementDescriptorArray = grandparent.getChildren();
            int n = elementDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                ElementDescriptor e = elementDescriptorArray[n2];
                if (e.getXmlName().startsWith(parent)) {
                    return AndroidContentAssist.sort(grandparent.getChildren());
                }
                ++n2;
            }
        }
        return null;
    }

    protected static ElementDescriptor[] sort(ElementDescriptor[] elements) {
        if (elements != null && elements.length > 1) {
            ElementDescriptor[] copy = new ElementDescriptor[elements.length];
            System.arraycopy(elements, 0, copy, 0, elements.length);
            Arrays.sort(copy, new Comparator<ElementDescriptor>(){

                @Override
                public int compare(ElementDescriptor e1, ElementDescriptor e2) {
                    return e1.getXmlLocalName().compareTo(e2.getXmlLocalName());
                }
            });
            return copy;
        }
        return elements;
    }

    private Object[] getChoicesForAttribute(String parent, Node currentNode, UiElementNode currentUiNode, AttribInfo attrInfo, String wordPrefix) {
        Object[] choices = null;
        if (attrInfo.isInValue) {
            String value = attrInfo.valuePrefix;
            if (value.startsWith("'") || value.startsWith("\"")) {
                attrInfo.correctedPrefix = value = value.substring(1);
            } else {
                attrInfo.needTag = (char)34;
            }
            if (currentUiNode != null) {
                String attrName = attrInfo.name;
                int pos = attrName.indexOf(58);
                if (pos >= 0) {
                    attrName = attrName.substring(pos + 1);
                }
                UiAttributeNode currAttrNode = null;
                for (UiAttributeNode attrNode : currentUiNode.getAllUiAttributes()) {
                    if (!attrNode.getDescriptor().getXmlLocalName().equals(attrName)) continue;
                    currAttrNode = attrNode;
                    break;
                }
                if (currAttrNode != null) {
                    choices = this.getAttributeValueChoices(currAttrNode, attrInfo, value);
                }
            }
            if (choices == null) {
                AndroidTargetData data;
                Node greatGrandParent;
                String greatGrandParentName = null;
                Node grandParent = currentNode.getParentNode();
                if (grandParent != null && (greatGrandParent = grandParent.getParentNode()) != null) {
                    greatGrandParentName = greatGrandParent.getLocalName();
                }
                if ((data = this.mEditor.getTargetData()) != null) {
                    choices = data.getAttributeValues(parent, attrInfo.name, greatGrandParentName);
                }
            }
        } else if (currentUiNode != null) {
            choices = currentUiNode.getAttributeDescriptors();
        } else {
            ElementDescriptor parentDesc = this.getDescriptor(parent);
            if (parentDesc != null) {
                choices = parentDesc.getAttributes();
            }
        }
        return choices;
    }

    protected Object[] getAttributeValueChoices(UiAttributeNode currAttrNode, AttribInfo attrInfo, String value) {
        Object[] choices = currAttrNode.getPossibleValues(value);
        if (choices != null && currAttrNode instanceof UiResourceAttributeNode) {
            attrInfo.skipEndTag = false;
        }
        if (currAttrNode instanceof UiFlagAttributeNode) {
            int pos = value.lastIndexOf(124);
            if (pos >= 0) {
                attrInfo.correctedPrefix = value = value.substring(pos + 1);
                attrInfo.needTag = '\u0000';
            }
            attrInfo.skipEndTag = false;
        }
        choices = this.completeSuffix(choices, value, currAttrNode);
        AttributeDescriptor attributeDescriptor = currAttrNode.getDescriptor();
        IAttributeInfo attributeInfo = attributeDescriptor.getAttributeInfo();
        if (value.startsWith("@") && !attributeInfo.getFormats().contains(IAttributeInfo.Format.REFERENCE)) {
            choices = UiResourceAttributeNode.computeResourceStringMatches(this.mEditor, attributeDescriptor, value);
            attrInfo.skipEndTag = false;
        } else if (value.startsWith("?") && !attributeInfo.getFormats().contains(IAttributeInfo.Format.REFERENCE)) {
            choices = UiResourceAttributeNode.computeResourceStringMatches(this.mEditor, attributeDescriptor, value);
            attrInfo.skipEndTag = false;
        }
        return choices;
    }

    protected boolean computeAttributeValues(List<ICompletionProposal> proposals, int offset, String parentTagName, String attributeName, Node node, String wordPrefix, boolean skipEndTag, int replaceLength) {
        return false;
    }

    protected void computeTextValues(List<ICompletionProposal> proposals, int offset, Node parentNode, Node currentNode, UiElementNode uiParent, String wordPrefix) {
        Object[] choices;
        if (parentNode != null && (choices = this.getElementChoicesForTextNode(parentNode)) != null && choices.length > 0) {
            ISourceViewer viewer = this.mEditor.getStructuredSourceViewer();
            char needTag = this.computeElementNeedTag((ITextViewer)viewer, offset, wordPrefix);
            int replaceLength = 0;
            this.addMatchingProposals(proposals, choices, offset, parentNode, wordPrefix, needTag, false, false, false, replaceLength);
        }
    }

    protected ElementDescriptor[] getElementChoicesForTextNode(Node parentNode) {
        ElementDescriptor[] choices = null;
        if (parentNode.getNodeType() == 1) {
            String parent = parentNode.getNodeName();
            ElementDescriptor desc = this.getDescriptor(parent);
            if (desc == null && parent.indexOf(46) != -1) {
                desc = this.mRootDescriptor;
            }
            if (desc != null) {
                choices = AndroidContentAssist.sort(desc.getChildren());
            }
        } else if (parentNode.getNodeType() == 9) {
            choices = AndroidContentAssist.sort(this.getRootDescriptor().getChildren());
        }
        return choices;
    }

    protected void addMatchingProposals(List<ICompletionProposal> proposals, Object[] choices, int offset, Node currentNode, String wordPrefix, char needTag, boolean isAttribute, boolean isNew, boolean skipEndTag, int replaceLength) {
        String nsPrefix;
        if (choices == null) {
            return;
        }
        HashMap<String, String> nsUriMap = new HashMap<String, String>();
        boolean haveLayoutParams = false;
        Object[] objectArray = choices;
        int n = choices.length;
        int n2 = 0;
        while (n2 < n) {
            block28: {
                String nsKeyword;
                String tooltip;
                Image icon;
                String nsUri;
                String nsPrefix2;
                String keyword;
                Object choice;
                block27: {
                    block31: {
                        block30: {
                            block29: {
                                block26: {
                                    choice = objectArray[n2];
                                    keyword = null;
                                    nsPrefix2 = null;
                                    nsUri = null;
                                    icon = null;
                                    tooltip = null;
                                    if (!(choice instanceof ElementDescriptor)) break block26;
                                    keyword = ((ElementDescriptor)choice).getXmlName();
                                    icon = ((ElementDescriptor)choice).getGenericIcon();
                                    break block27;
                                }
                                if (choice instanceof TextValueDescriptor || choice instanceof SeparatorAttributeDescriptor) break block28;
                                if (!(choice instanceof AttributeDescriptor)) break block29;
                                keyword = ((AttributeDescriptor)choice).getXmlLocalName();
                                icon = ((AttributeDescriptor)choice).getGenericIcon();
                                nsUri = ((AttributeDescriptor)choice).getNamespaceUri();
                                if (nsUri != null && (nsPrefix2 = (String)nsUriMap.get(nsUri)) == null) {
                                    nsPrefix2 = XmlUtils.lookupNamespacePrefix((Node)currentNode, (String)nsUri, (boolean)false);
                                    nsUriMap.put(nsUri, nsPrefix2);
                                }
                                if (nsPrefix2 != null) {
                                    nsPrefix2 = String.valueOf(nsPrefix2) + ":";
                                }
                                break block27;
                            }
                            if (!(choice instanceof String)) break block30;
                            keyword = (String)choice;
                            if (isAttribute) {
                                icon = IconFactory.getInstance().getIcon("attribute");
                            }
                            break block27;
                        }
                        if (!(choice instanceof Pair)) break block31;
                        Pair pair = (Pair)choice;
                        keyword = (String)pair.getFirst();
                        tooltip = (String)pair.getSecond();
                        if (isAttribute) {
                            icon = IconFactory.getInstance().getIcon("attribute");
                        }
                        break block27;
                    }
                    if (!(choice instanceof IType)) break block28;
                    IType type = (IType)choice;
                    keyword = type.getFullyQualifiedName();
                    icon = JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jcu_obj.gif");
                }
                String string = nsKeyword = nsPrefix2 == null ? keyword : String.valueOf(nsPrefix2) + keyword;
                if (AndroidContentAssist.nameStartsWith(nsKeyword, wordPrefix, nsPrefix2)) {
                    String displayString;
                    int cursorPosition;
                    String suffix;
                    keyword = nsKeyword;
                    String endTag = ROOT_ELEMENT;
                    if (needTag != '\u0000') {
                        if (needTag == '\"') {
                            keyword = String.valueOf(needTag) + keyword;
                            endTag = String.valueOf(needTag);
                        } else if (needTag == '<') {
                            endTag = this.elementCanHaveChildren(choice) ? String.format("></%1$s>", keyword) : "/>";
                            keyword = String.valueOf(needTag) + keyword + ' ';
                        } else if (needTag == ' ') {
                            keyword = String.valueOf(needTag) + keyword;
                        }
                    } else if (!isAttribute && isNew) {
                        endTag = this.elementCanHaveChildren(choice) ? String.format("></%1$s>", keyword) : "/>";
                        keyword = String.valueOf(keyword) + ' ';
                    }
                    if (choice instanceof AttributeDescriptor && isNew) {
                        suffix = "=\"\"";
                        cursorPosition = keyword.length() + suffix.length() - 1;
                        displayString = String.valueOf(keyword) + endTag;
                    } else {
                        suffix = endTag;
                        cursorPosition = keyword.length();
                        displayString = null;
                    }
                    if (skipEndTag) {
                        assert (isAttribute);
                        ++cursorPosition;
                    }
                    if (nsPrefix2 != null && keyword.startsWith("layout_", nsPrefix2.length())) {
                        haveLayoutParams = true;
                    }
                    proposals.add(new CompletionProposal(this, choice, String.valueOf(keyword) + suffix, offset - wordPrefix.length(), wordPrefix.length() + replaceLength, cursorPosition, icon, displayString, null, tooltip, nsPrefix2, nsUri));
                }
            }
            ++n2;
        }
        if (!(wordPrefix.length() <= 0 || !haveLayoutParams || wordPrefix.startsWith("layout_") || wordPrefix.startsWith(nsPrefix = (nsPrefix = (String)nsUriMap.get("http://schemas.android.com/apk/res/android")) == null ? "android:" : String.valueOf(nsPrefix) + ':') && wordPrefix.startsWith("layout_", nsPrefix.length()))) {
            int nextLayoutIndex = 0;
            int i = 0;
            int n3 = proposals.size();
            while (i < n3) {
                ICompletionProposal proposal = proposals.get(i);
                String keyword = proposal.getDisplayString();
                if (keyword.startsWith(nsPrefix) && keyword.startsWith("layout_", nsPrefix.length()) && i != nextLayoutIndex) {
                    ICompletionProposal temp = proposals.get(nextLayoutIndex);
                    proposals.set(nextLayoutIndex, proposal);
                    proposals.set(i, temp);
                    ++nextLayoutIndex;
                }
                ++i;
            }
        }
    }

    protected static boolean startsWith(String word, String prefix) {
        int prefixLength = prefix.length();
        int wordLength = word.length();
        if (wordLength < prefixLength) {
            return false;
        }
        int i = 0;
        while (i < prefixLength) {
            if (Character.toLowerCase(prefix.charAt(i)) != Character.toLowerCase(word.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    AndroidXmlEditor getEditor() {
        return this.mEditor;
    }

    protected static boolean nameStartsWith(String word, String prefix, String nsPrefix) {
        char c2;
        char c1;
        if (nsPrefix == null) {
            nsPrefix = ROOT_ELEMENT;
        }
        int wordStart = nsPrefix.length();
        int prefixStart = 0;
        if (AndroidContentAssist.startsWith(prefix, nsPrefix)) {
            prefixStart = wordStart;
        } else if (AndroidContentAssist.startsWith(nsPrefix, prefix)) {
            return true;
        }
        int prefixLength = prefix.length();
        int wordLength = word.length();
        if (wordLength - wordStart < prefixLength - prefixStart) {
            return false;
        }
        boolean matches = true;
        int i = prefixStart;
        int j = wordStart;
        while (i < prefixLength) {
            c1 = Character.toLowerCase(prefix.charAt(i));
            if (c1 != (c2 = Character.toLowerCase(word.charAt(j)))) {
                matches = false;
                break;
            }
            ++i;
            ++j;
        }
        if (!matches && word.startsWith("layout_", wordStart) && !prefix.startsWith("layout_", prefixStart)) {
            if (wordLength - (wordStart += "layout_".length()) < prefixLength - prefixStart) {
                return false;
            }
            i = prefixStart;
            j = wordStart;
            while (i < prefixLength) {
                c1 = Character.toLowerCase(prefix.charAt(i));
                if (c1 != (c2 = Character.toLowerCase(word.charAt(j)))) {
                    return false;
                }
                ++i;
                ++j;
            }
            return true;
        }
        return matches;
    }

    private boolean elementCanHaveChildren(Object descriptor) {
        if (descriptor instanceof ElementDescriptor) {
            ElementDescriptor desc = (ElementDescriptor)descriptor;
            if (desc.hasChildren()) {
                return true;
            }
            AttributeDescriptor[] attributeDescriptorArray = desc.getAttributes();
            int n = attributeDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                AttributeDescriptor attrDesc = attributeDescriptorArray[n2];
                if (attrDesc instanceof TextValueDescriptor) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private ElementDescriptor getDescriptor(String nodeName) {
        return this.getRootDescriptor().findChildrenDescriptor(nodeName, true);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'<', ':', '='};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected String extractElementPrefix(ITextViewer viewer, int offset) {
        i = offset;
        document = viewer.getDocument();
        if (i <= document.getLength()) ** GOTO lbl7
        return "";
        {
            while (!Character.isWhitespace(ch = document.getChar(i - 1)) && ch != '<' && ch != '>' && ch != '\'' && ch != '\"' && ch != '=') {
                --i;
lbl7:
                // 2 sources

                if (i > 0) continue;
            }
            return document.get(i, offset - i);
        }
    }

    protected char extractChar(ITextViewer viewer, int offset) {
        IDocument document = viewer.getDocument();
        if (offset > document.getLength()) {
            return '\u0000';
        }
        try {
            return document.getChar(offset);
        }
        catch (BadLocationException badLocationException) {
            return '\u0000';
        }
    }

    private char nextNonspaceChar(ITextViewer viewer, int offset) {
        IDocument document = viewer.getDocument();
        int length = document.getLength();
        while (offset < length) {
            try {
                char c = document.getChar(offset);
                if (!Character.isWhitespace(c)) {
                    return c;
                }
            }
            catch (BadLocationException badLocationException) {
                return '\u0000';
            }
            ++offset;
        }
        return '\u0000';
    }

    private AttribInfo parseAttributeInfo(ITextViewer viewer, int offset, int prefixStartOffset) {
        AttribInfo info = new AttribInfo();
        int originalOffset = offset;
        IDocument document = viewer.getDocument();
        int n = document.getLength();
        if (offset <= n) {
            String text;
            block22: {
                block21: {
                    if (offset >= n || document.getChar(offset) != '<') break block21;
                    return null;
                }
                n = offset;
                while (offset > 0) {
                    char ch = document.getChar(offset - 1);
                    if (ch == '>' || ch == '<') break;
                    --offset;
                }
                text = document.get(offset, n - offset);
                text = sWhitespace.matcher(text).replaceAll(" ");
                if ((text = sFirstElementWord.matcher(text).replaceFirst(ROOT_ELEMENT)).startsWith(" ")) break block22;
                return null;
            }
            try {
                String temp;
                while (!(temp = text).equals(text = sFirstAttribute.matcher(temp).replaceFirst(ROOT_ELEMENT))) {
                }
                IRegion lineInfo = document.getLineInformationOfOffset(originalOffset);
                int lineStart = lineInfo.getOffset();
                String line = document.get(lineStart, lineInfo.getLength());
                int cursorColumn = originalOffset - lineStart;
                int prefixLength = originalOffset - prefixStartOffset;
                int posEqual = text.indexOf(61);
                if (posEqual == -1) {
                    char prevChar;
                    int nameStart;
                    info.isInValue = false;
                    info.name = text.trim();
                    int nameEnd = nameStart = cursorColumn;
                    while (nameEnd < line.length()) {
                        char c = line.charAt(nameEnd);
                        if (!Character.isLetter(c) && c != ':' && c != '_') {
                            String nameSuffix = line.substring(nameStart, nameEnd);
                            info.name = String.valueOf(text.trim()) + nameSuffix;
                            break;
                        }
                        ++nameEnd;
                    }
                    info.replaceLength = info.name.length() - prefixLength;
                    if (info.name.length() == 0 && originalOffset > 0 && ((prevChar = this.extractChar(viewer, originalOffset - 1)) == '\"' || prevChar == '\'')) {
                        info.needTag = (char)32;
                    }
                    info.skipEndTag = false;
                } else {
                    int valueStart;
                    info.isInValue = true;
                    info.name = text.substring(0, posEqual).trim();
                    info.valuePrefix = text.substring(posEqual + 1);
                    char quoteChar = '\"';
                    int i = posEqual + 1;
                    while (i < text.length()) {
                        if (!Character.isWhitespace(text.charAt(i))) {
                            quoteChar = text.charAt(i);
                            break;
                        }
                        ++i;
                    }
                    int valueEnd = valueStart = cursorColumn;
                    while (valueEnd < line.length()) {
                        char c = line.charAt(valueEnd);
                        if (c == quoteChar) {
                            boolean isFirst = false;
                            int j = valueEnd - 1;
                            while (j >= 0) {
                                char pc = line.charAt(j);
                                if (pc == '=') {
                                    isFirst = true;
                                    break;
                                }
                                if (pc == quoteChar) {
                                    valueStart = j;
                                    break;
                                }
                                --j;
                            }
                            if (!isFirst) {
                                info.skipEndTag = true;
                                break;
                            }
                        }
                        ++valueEnd;
                    }
                    int valueEndOffset = valueEnd + lineStart;
                    info.replaceLength = valueEndOffset - (prefixStartOffset + prefixLength);
                    int valueStartOffset = valueStart + lineStart;
                    if (valueStartOffset == prefixStartOffset && valueEnd > valueStart) {
                        ++info.replaceLength;
                    }
                }
                return info;
            }
            catch (BadLocationException badLocationException) {}
        }
        return null;
    }

    protected int getRootDescriptorId() {
        return this.mDescriptorId;
    }

    protected ElementDescriptor getRootDescriptor() {
        IDescriptorProvider descriptorProvider;
        AndroidTargetData data;
        if (this.mRootDescriptor == null && (data = this.mEditor.getTargetData()) != null && (descriptorProvider = data.getDescriptorProvider(this.getRootDescriptorId())) != null) {
            this.mRootDescriptor = new ElementDescriptor(ROOT_ELEMENT, descriptorProvider.getRootElementDescriptors());
        }
        return this.mRootDescriptor;
    }

    private Object[] completeSuffix(Object[] choices, String value, UiAttributeNode currAttrNode) {
        boolean hasFlag;
        IAttributeInfo attributeInfo = currAttrNode.getDescriptor().getAttributeInfo();
        EnumSet formats = attributeInfo.getFormats();
        ArrayList<Object> suffixes = new ArrayList<Object>();
        if (value.length() > 0 && Character.isDigit(value.charAt(0))) {
            boolean hasDimension = formats.contains(IAttributeInfo.Format.DIMENSION);
            boolean hasFraction = formats.contains(IAttributeInfo.Format.FRACTION);
            if (hasDimension || hasFraction) {
                String description;
                String unit;
                int i;
                int suffixBegin = 0;
                while (suffixBegin < value.length()) {
                    if (!Character.isDigit(value.charAt(suffixBegin))) break;
                    ++suffixBegin;
                }
                String number = value.substring(0, suffixBegin);
                String suffix = value.substring(suffixBegin);
                if (hasDimension) {
                    i = 0;
                    while (i < sDimensionUnits.length) {
                        unit = sDimensionUnits[i];
                        if (AndroidContentAssist.startsWith(unit, suffix)) {
                            description = sDimensionUnits[i + 1];
                            suffixes.add(Pair.of((Object)(String.valueOf(number) + unit), (Object)description));
                        }
                        i += 2;
                    }
                    if (AndroidContentAssist.startsWith(suffix, "di") || AndroidContentAssist.startsWith(suffix, "dip")) {
                        suffixes.add(Pair.of((Object)(String.valueOf(number) + "dip"), (Object)"Alternative name for \"dp\""));
                    }
                }
                if (hasFraction) {
                    i = 0;
                    while (i < sFractionUnits.length) {
                        unit = sFractionUnits[i];
                        if (AndroidContentAssist.startsWith(unit, suffix)) {
                            description = sFractionUnits[i + 1];
                            suffixes.add(Pair.of((Object)(String.valueOf(number) + unit), (Object)description));
                        }
                        i += 2;
                    }
                }
            }
        }
        if (hasFlag = formats.contains(IAttributeInfo.Format.FLAG)) {
            String[] flagValues;
            boolean isDone = false;
            String[] stringArray = flagValues = attributeInfo.getFlagValues();
            int n = flagValues.length;
            int suffix = 0;
            while (suffix < n) {
                String flagValue = stringArray[suffix];
                if (flagValue.equals(value)) {
                    isDone = true;
                    break;
                }
                ++suffix;
            }
            if (isDone) {
                String currentValue = currAttrNode.getCurrentValue();
                String[] stringArray2 = flagValues;
                int n2 = flagValues.length;
                n = 0;
                while (n < n2) {
                    String flagValue = stringArray2[n];
                    if (currentValue == null || !currentValue.contains(flagValue)) {
                        suffixes.add(String.valueOf(value) + '|' + flagValue);
                    }
                    ++n;
                }
            }
        }
        if (suffixes.size() > 0) {
            ArrayList<Object> all = new ArrayList<Object>();
            if (choices != null) {
                Object[] objectArray = choices;
                int n = choices.length;
                int n3 = 0;
                while (n3 < n) {
                    Object s = objectArray[n3];
                    all.add(s);
                    ++n3;
                }
            }
            all.addAll(suffixes);
            choices = all.toArray();
        }
        return choices;
    }

    protected static class AttribInfo {
        public boolean isInValue = false;
        public String name = null;
        public String valuePrefix = null;
        public String correctedPrefix = null;
        public char needTag = '\u0000';
        public int replaceLength = 0;
        public boolean skipEndTag = false;
    }
}

