/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.draw9patch.graphics;

import org.eclipse.swt.graphics.ImageData;

public class GraphicsUtilities {
    public static ImageData convertToNinePatch(ImageData image) {
        if (image == null) {
            return null;
        }
        ImageData result = new ImageData(image.width + 2, image.height + 2, image.depth, image.palette);
        int[] colors = new int[image.width];
        byte[] alpha = new byte[image.width];
        int y = 0;
        while (y < image.height) {
            image.getPixels(0, y, image.width, colors, 0);
            result.setPixels(1, y + 1, image.width, colors, 0);
            image.getAlphas(0, y, image.width, alpha, 0);
            result.setAlphas(1, y + 1, image.width, alpha, 0);
            ++y;
        }
        return result;
    }

    public static void clearImageData(ImageData imageData) {
        if (imageData == null) {
            throw new IllegalArgumentException("image data must not be null");
        }
        int width = imageData.width;
        int height = imageData.height;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                imageData.setPixel(x, y, 0);
                imageData.setAlpha(x, y, 0);
                ++x;
            }
            ++y;
        }
    }

    public static ImageData copy(ImageData image) {
        if (image == null) {
            return null;
        }
        ImageData result = new ImageData(image.width, image.height, image.depth, image.palette);
        int[] colors = new int[image.width];
        byte[] alpha = new byte[image.width];
        int y = 0;
        while (y < image.height) {
            image.getPixels(0, y, image.width, colors, 0);
            result.setPixels(0, y, image.width, colors, 0);
            image.getAlphas(0, y, image.width, alpha, 0);
            result.setAlphas(0, y, image.width, alpha, 0);
            ++y;
        }
        return result;
    }

    public static int getVerticalPixels(ImageData data, int x, int y, int height, int[] out) {
        if (data == null) {
            throw new IllegalArgumentException("data must not be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("out array must not be null");
        }
        if (height > out.length) {
            throw new IllegalArgumentException("out array length must be > height");
        }
        if (data.height < y + height) {
            throw new IllegalArgumentException("image height must be > (y + height)");
        }
        if (x < 0 || y < 0) {
            throw new IllegalArgumentException("argument x, y must be >= 0");
        }
        if (x >= data.width) {
            throw new IllegalArgumentException("argument x must be < data.width");
        }
        if (y >= data.height) {
            throw new IllegalArgumentException("argument y must be < data.height");
        }
        if (height <= 0) {
            throw new IllegalArgumentException("argument height must be > 0");
        }
        int idx = 0;
        while (idx < height) {
            data.getPixels(x, y + idx, 1, out, idx);
            ++idx;
        }
        return idx;
    }

    public static void getHorizontalPixels(ImageData data, int x, int y, int width, int[] out) {
        if (data == null) {
            throw new IllegalArgumentException("data must not be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("out array must not be null");
        }
        if (width > out.length) {
            throw new IllegalArgumentException("out array length must be > width");
        }
        if (data.width < x + width) {
            throw new IllegalArgumentException("image height must be > (x + width)");
        }
        if (x < 0 || y < 0) {
            throw new IllegalArgumentException("argument x, y must be >= 0");
        }
        if (x >= data.width) {
            throw new IllegalArgumentException("argument x must be < data.width");
        }
        if (y >= data.height) {
            throw new IllegalArgumentException("argument y must be < data.height");
        }
        if (width <= 0) {
            throw new IllegalArgumentException("argument width must be > 0");
        }
        data.getPixels(x, y, width, out, 0);
    }
}

