/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.drawable;

import com.android.ide.common.api.IAttributeInfo;
import com.android.ide.common.resources.platform.AttributeInfo;
import com.android.ide.common.resources.platform.DeclareStyleableInfo;
import com.android.ide.eclipse.adt.internal.editors.animator.AnimatorDescriptors;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.IDescriptorProvider;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ReferenceAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.XmlnsAttributeDescriptor;
import com.android.resources.ResourceType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DrawableDescriptors
implements IDescriptorProvider {
    private static final String SDK_URL_BASE = "http://d.android.com/guide/topics/resources/";
    private ElementDescriptor mDescriptor;
    private ElementDescriptor[] mRootDescriptors;
    private Map<String, ElementDescriptor> nameToDescriptor;

    @Override
    public ElementDescriptor getDescriptor() {
        if (this.mDescriptor == null) {
            this.mDescriptor = new ElementDescriptor("", this.getRootElementDescriptors());
        }
        return this.mDescriptor;
    }

    @Override
    public ElementDescriptor[] getRootElementDescriptors() {
        return this.mRootDescriptors;
    }

    public ElementDescriptor getElementDescriptor(String tag) {
        ElementDescriptor descriptor;
        if (this.nameToDescriptor == null) {
            this.nameToDescriptor = new HashMap<String, ElementDescriptor>();
            ElementDescriptor[] elementDescriptorArray = this.getRootElementDescriptors();
            int n = elementDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                descriptor = elementDescriptorArray[n2];
                this.nameToDescriptor.put(descriptor.getXmlName(), descriptor);
                ++n2;
            }
        }
        if ((descriptor = this.nameToDescriptor.get(tag)) == null) {
            descriptor = this.getDescriptor();
        }
        return descriptor;
    }

    public synchronized void updateDescriptors(Map<String, DeclareStyleableInfo> styleMap) {
        ElementDescriptor[] elementDescriptorArray;
        ElementDescriptor[] elementDescriptorArray2;
        ElementDescriptor[] elementDescriptorArray3;
        XmlnsAttributeDescriptor xmlns = new XmlnsAttributeDescriptor("android", "http://schemas.android.com/apk/res/android");
        ArrayList<ElementDescriptor> descriptors = new ArrayList<ElementDescriptor>();
        AnimatorDescriptors.addElement(descriptors, styleMap, "animation-list", "Animation List", "AnimationDrawable", null, "An animation defined in XML that shows a sequence of images in order (like a film)", "http://d.android.com/guide/topics/resources/animation-resource.html#Frame", xmlns, null, true);
        AnimatorDescriptors.addElement(descriptors, styleMap, "bitmap", "BitMap", "BitmapDrawable", null, "An XML bitmap is a resource defined in XML that points to a bitmap file. The effect is an alias for a raw bitmap file. The XML can specify additional properties for the bitmap such as dithering and tiling.", "http://d.android.com/guide/topics/resources/drawable-resource.html#Bitmap", xmlns, null, true);
        AnimatorDescriptors.addElement(descriptors, styleMap, "clip", "Clip", "ClipDrawable", null, "An XML file that defines a drawable that clips another Drawable based on this Drawable's current level value.", "http://d.android.com/guide/topics/resources/drawable-resource.html#Clip", xmlns, null, true);
        AnimatorDescriptors.addElement(descriptors, styleMap, "color", "Color", "ColorDrawable", null, "XML resource that carries a color value (a hexadecimal color)", "http://d.android.com/guide/topics/resources/more-resources.html#Color", xmlns, null, true);
        AnimatorDescriptors.addElement(descriptors, styleMap, "inset", "Inset", "InsetDrawable", null, "An XML file that defines a drawable that insets another drawable by a specified distance. This is useful when a View needs a background drawble that is smaller than the View's actual bounds.", "http://d.android.com/guide/topics/resources/drawable-resource.html#Inset", xmlns, null, true);
        ElementDescriptor layerItem = AnimatorDescriptors.addElement(null, styleMap, "item", "Item", "LayerDrawableItem", null, "Defines a drawable to place in the layer drawable, in a position defined by its attributes. Must be a child of a <selector> element. Accepts child <bitmap> elements.", "http://d.android.com/guide/topics/resources/drawable-resource.html#LayerList", null, null, false);
        if (layerItem != null) {
            ElementDescriptor[] elementDescriptorArray4 = new ElementDescriptor[1];
            elementDescriptorArray3 = elementDescriptorArray4;
            elementDescriptorArray4[0] = layerItem;
        } else {
            elementDescriptorArray3 = null;
        }
        ElementDescriptor[] layerChildren = elementDescriptorArray3;
        AnimatorDescriptors.addElement(descriptors, styleMap, "layer-list", "Layer List", "LayerDrawable", null, "A Drawable that manages an array of other Drawables. These are drawn in array order, so the element with the largest index is be drawn on top.", "http://d.android.com/guide/topics/resources/drawable-resource.html#LayerList", xmlns, layerChildren, true);
        ElementDescriptor levelListItem = AnimatorDescriptors.addElement(null, styleMap, "item", "Item", "LevelListDrawableItem", null, "Defines a drawable to use at a certain level.", "http://d.android.com/guide/topics/resources/drawable-resource.html#LevelList", null, null, false);
        if (levelListItem != null) {
            ElementDescriptor[] elementDescriptorArray5 = new ElementDescriptor[1];
            elementDescriptorArray2 = elementDescriptorArray5;
            elementDescriptorArray5[0] = levelListItem;
        } else {
            elementDescriptorArray2 = null;
        }
        AnimatorDescriptors.addElement(descriptors, styleMap, "level-list", "Level List", "LevelListDrawable", null, "An XML file that defines a drawable that manages a number of alternate Drawables, each assigned a maximum numerical value", "http://d.android.com/guide/topics/resources/drawable-resource.html#LevelList", xmlns, elementDescriptorArray2, true);
        AnimatorDescriptors.addElement(descriptors, styleMap, "nine-patch", "Nine Patch", "NinePatchDrawable", null, "A PNG file with stretchable regions to allow image resizing based on content (.9.png).", "http://d.android.com/guide/topics/resources/drawable-resource.html#NinePatch", xmlns, null, true);
        AnimatorDescriptors.addElement(descriptors, styleMap, "rotate", "Rotate", "RotateDrawable", null, null, null, xmlns, null, true);
        AnimatorDescriptors.addElement(descriptors, styleMap, "scale", "Shape", "ScaleDrawable", null, "An XML file that defines a drawable that changes the size of another Drawable based on its current level value.", "http://d.android.com/guide/topics/resources/drawable-resource.html#Scale", xmlns, null, true);
        ElementDescriptor selectorItem = AnimatorDescriptors.addElement(null, styleMap, "item", "Item", "DrawableStates", null, "Defines a drawable to use during certain states, as described by its attributes. Must be a child of a <selector> element.", "http://d.android.com/guide/topics/resources/drawable-resource.html#StateList", new ReferenceAttributeDescriptor(ResourceType.DRAWABLE, "drawable", "http://schemas.android.com/apk/res/android", new AttributeInfo("drawable", IAttributeInfo.Format.REFERENCE_SET)).setTooltip("Reference to a drawable resource."), null, false);
        if (selectorItem != null) {
            ElementDescriptor[] elementDescriptorArray6 = new ElementDescriptor[1];
            elementDescriptorArray = elementDescriptorArray6;
            elementDescriptorArray6[0] = selectorItem;
        } else {
            elementDescriptorArray = null;
        }
        AnimatorDescriptors.addElement(descriptors, styleMap, "selector", "Selector", "StateListDrawable", null, "An XML file that references different bitmap graphics for different states (for example, to use a different image when a button is pressed).", "http://d.android.com/guide/topics/resources/drawable-resource.html#StateList", xmlns, elementDescriptorArray, true);
        ArrayList<ElementDescriptor> shapeChildren = new ArrayList<ElementDescriptor>();
        AnimatorDescriptors.addElement(shapeChildren, styleMap, "size", "Size", "GradientDrawableSize", null, null, null, null, null, false);
        AnimatorDescriptors.addElement(shapeChildren, styleMap, "gradient", "Gradient", "GradientDrawableGradient", null, null, null, null, null, false);
        AnimatorDescriptors.addElement(shapeChildren, styleMap, "solid", "Solid", "GradientDrawableSolid", null, null, null, null, null, false);
        AnimatorDescriptors.addElement(shapeChildren, styleMap, "stroke", "Stroke", "GradientDrawableStroke", null, null, null, null, null, false);
        AnimatorDescriptors.addElement(shapeChildren, styleMap, "corners", "Corners", "DrawableCorners", null, null, null, null, null, false);
        AnimatorDescriptors.addElement(shapeChildren, styleMap, "padding", "Padding", "GradientDrawablePadding", null, null, null, null, null, false);
        AnimatorDescriptors.addElement(descriptors, styleMap, "shape", "Shape", "GradientDrawable", null, "An XML file that defines a geometric shape, including colors and gradients.", "http://d.android.com/guide/topics/resources/drawable-resource.html#Shape", xmlns, shapeChildren.toArray(new ElementDescriptor[shapeChildren.size()]), true);
        AnimatorDescriptors.addElement(descriptors, styleMap, "transition", "Transition", "TransitionDrawable", null, "An XML file that defines a drawable that can cross-fade between two drawable resources. Each drawable is represented by an <item> element inside a single <transition> element. No more than two items are supported. To transition forward, call startTransition(). To transition backward, call reverseTransition().", "http://d.android.com/guide/topics/resources/drawable-resource.html#Transition", xmlns, layerChildren, true);
        this.mRootDescriptors = descriptors.toArray(new ElementDescriptor[descriptors.size()]);
        if (selectorItem != null) {
            selectorItem.setChildren(this.mRootDescriptors);
        }
        if (layerItem != null) {
            layerItem.setChildren(this.mRootDescriptors);
        }
    }
}

