/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.configuration;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.Configuration;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.ConfigurationChooser;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.ConfigurationMatcher;
import com.android.ide.eclipse.adt.internal.preferences.AdtPrefs;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import java.util.List;
import java.util.RandomAccess;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;

class TargetMenuListener
extends SelectionAdapter {
    private final ConfigurationChooser mConfigChooser;
    private final IAndroidTarget mTarget;
    private final boolean mPickBest;

    TargetMenuListener(@NonNull ConfigurationChooser configChooser, @Nullable IAndroidTarget target, boolean pickBest) {
        this.mConfigChooser = configChooser;
        this.mTarget = target;
        this.mPickBest = pickBest;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void widgetSelected(SelectionEvent e) {
        IAndroidTarget target = this.mTarget;
        AdtPrefs prefs = AdtPrefs.getPrefs();
        if (this.mPickBest) {
            boolean autoPick = prefs.isAutoPickRenderTarget();
            autoPick = !autoPick;
            prefs.setAutoPickRenderTarget(autoPick);
            if (!autoPick) return;
            target = ConfigurationMatcher.findDefaultRenderTarget(this.mConfigChooser);
        } else {
            prefs.setAutoPickRenderTarget(false);
        }
        this.mConfigChooser.selectTarget(target);
        this.mConfigChooser.onRenderingTargetChange();
    }

    static void show(ConfigurationChooser chooser, ToolItem combo) {
        Menu menu = new Menu((Decorations)chooser.getShell(), 8);
        Configuration configuration = chooser.getConfiguration();
        IAndroidTarget current = configuration.getTarget();
        List<IAndroidTarget> targets = chooser.getTargetList();
        boolean haveRecent = false;
        MenuItem menuItem = new MenuItem(menu, 32);
        menuItem.setText("Automatically Pick Best");
        menuItem.addSelectionListener((SelectionListener)new TargetMenuListener(chooser, null, true));
        if (AdtPrefs.getPrefs().isAutoPickRenderTarget()) {
            menuItem.setSelection(true);
        }
        new MenuItem(menu, 2);
        assert (targets instanceof RandomAccess);
        int i = targets.size() - 1;
        while (i >= 0) {
            boolean selected;
            IAndroidTarget target = targets.get(i);
            AndroidVersion version = target.getVersion();
            if (version.getApiLevel() >= 7) {
                haveRecent = true;
            } else if (haveRecent) break;
            String title = ConfigurationChooser.getRenderingTargetLabel(target, false);
            MenuItem item = new MenuItem(menu, 32);
            item.setText(title);
            boolean bl = selected = current == target;
            if (selected) {
                item.setSelection(true);
            }
            item.addSelectionListener((SelectionListener)new TargetMenuListener(chooser, target, false));
            --i;
        }
        Rectangle bounds = combo.getBounds();
        Point location = new Point(bounds.x, bounds.y + bounds.height);
        location = combo.getParent().toDisplay(location);
        menu.setLocation(location.x, location.y);
        menu.setVisible(true);
    }
}

