/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gle2;

import com.android.ide.common.rendering.api.Capability;
import com.android.ide.common.rendering.api.IAnimationListener;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.layout.LayoutEditorDelegate;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.CanvasViewInfo;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.GraphicalEditorPart;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.HoverOverlay;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.ImageOverlay;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.LayoutCanvas;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SelectionItem;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SelectionManager;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SelectionOverlay;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SubmenuAction;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.ViewHierarchy;
import com.android.ide.eclipse.adt.internal.wizards.newxmlfile.NewXmlFileWizard;
import com.android.resources.ResourceType;
import com.android.utils.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;

public class PlayAnimationMenu
extends SubmenuAction {
    private final LayoutCanvas mCanvas;
    private boolean mFramework;

    public PlayAnimationMenu(LayoutCanvas canvas) {
        this(canvas, "Play Animation", false);
    }

    private PlayAnimationMenu(LayoutCanvas canvas, String title, boolean framework) {
        super(title);
        this.mCanvas = canvas;
        this.mFramework = framework;
    }

    @Override
    protected void addMenuItems(Menu menu) {
        SelectionManager selectionManager = this.mCanvas.getSelectionManager();
        List<SelectionItem> selection = selectionManager.getSelections();
        if (selection.size() != 1) {
            this.addDisabledMessageItem("Select exactly one widget");
            return;
        }
        GraphicalEditorPart graphicalEditor = this.mCanvas.getEditorDelegate().getGraphicalEditor();
        if (graphicalEditor.renderingSupports(Capability.PLAY_ANIMATION)) {
            Collection<String> animationNames = graphicalEditor.getResourceNames(this.mFramework, ResourceType.ANIMATOR);
            if (animationNames.size() > 0) {
                ArrayList<String> sortedNames = new ArrayList<String>(animationNames);
                Collections.sort(sortedNames);
                Iterator iterator = sortedNames.iterator();
                while (iterator.hasNext()) {
                    String animation;
                    String title = animation = (String)iterator.next();
                    PlayAnimationAction action = new PlayAnimationAction(title, animation, this.mFramework);
                    new ActionContributionItem((IAction)action).fill(menu, -1);
                }
                new Separator().fill(menu, -1);
            }
            if (!this.mFramework) {
                new ActionContributionItem((IAction)new CreateAnimationAction()).fill(menu, -1);
                new Separator().fill(menu, -1);
                PlayAnimationMenu sub = new PlayAnimationMenu(this.mCanvas, "Android Builtin", true);
                new ActionContributionItem((IAction)sub).fill(menu, -1);
            }
        } else {
            this.addDisabledMessageItem("Not supported for this SDK version; try changing the Render Target");
        }
    }

    private class CreateAnimationAction
    extends Action {
        public CreateAnimationAction() {
            super("Create...", 1);
        }

        public void run() {
            Shell parent = PlayAnimationMenu.this.mCanvas.getShell();
            NewXmlFileWizard wizard = new NewXmlFileWizard();
            LayoutEditorDelegate editor = PlayAnimationMenu.this.mCanvas.getEditorDelegate();
            IWorkbenchWindow workbenchWindow = editor.getEditor().getEditorSite().getWorkbenchWindow();
            IWorkbench workbench = workbenchWindow.getWorkbench();
            String animationDir = "res/animator";
            Pair pair = Pair.of((Object)editor.getEditor().getProject(), (Object)animationDir);
            StructuredSelection selection = new StructuredSelection((Object)pair);
            wizard.init(workbench, (IStructuredSelection)selection);
            WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
            dialog.create();
            dialog.open();
        }
    }

    private class PlayAnimationAction
    extends Action {
        private final String mAnimationName;
        private final boolean mIsFrameworkAnim;

        public PlayAnimationAction(String title, String animationName, boolean isFrameworkAnim) {
            super(title, 1);
            this.mAnimationName = animationName;
            this.mIsFrameworkAnim = isFrameworkAnim;
        }

        public void run() {
            ViewHierarchy viewHierarchy;
            RenderSession session;
            Result r;
            SelectionManager selectionManager = PlayAnimationMenu.this.mCanvas.getSelectionManager();
            List<SelectionItem> selection = selectionManager.getSelections();
            SelectionItem canvasSelection = selection.get(0);
            CanvasViewInfo info = canvasSelection.getViewInfo();
            Object viewObject = info.getViewObject();
            if (viewObject != null && !(r = (session = (viewHierarchy = PlayAnimationMenu.this.mCanvas.getViewHierarchy()).getSession()).animate(viewObject, this.mAnimationName, this.mIsFrameworkAnim, new IAnimationListener(){
                private boolean mPendingDrawing = false;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onNewFrame(RenderSession s) {
                    HoverOverlay hoverOverlay;
                    SelectionOverlay selectionOverlay = PlayAnimationMenu.this.mCanvas.getSelectionOverlay();
                    if (!selectionOverlay.isHiding()) {
                        selectionOverlay.setHiding(true);
                    }
                    if (!(hoverOverlay = PlayAnimationMenu.this.mCanvas.getHoverOverlay()).isHiding()) {
                        hoverOverlay.setHiding(true);
                    }
                    ImageOverlay imageOverlay = PlayAnimationMenu.this.mCanvas.getImageOverlay();
                    imageOverlay.setImage(s.getImage(), s.isAlphaChannelImage());
                    1 var5_5 = this;
                    synchronized (var5_5) {
                        if (!this.mPendingDrawing) {
                            PlayAnimationMenu.this.mCanvas.getDisplay().asyncExec(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    PlayAnimationAction.1 var1_1 = this;
                                    synchronized (var1_1) {
                                        mPendingDrawing = false;
                                    }
                                    PlayAnimationMenu.this.mCanvas.redraw();
                                }
                            });
                            this.mPendingDrawing = true;
                        }
                    }
                }

                public boolean isCanceled() {
                    return false;
                }

                public void done(Result result) {
                    SelectionOverlay selectionOverlay = PlayAnimationMenu.this.mCanvas.getSelectionOverlay();
                    selectionOverlay.setHiding(false);
                    HoverOverlay hoverOverlay = PlayAnimationMenu.this.mCanvas.getHoverOverlay();
                    hoverOverlay.setHiding(false);
                    PlayAnimationMenu.this.mCanvas.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            GraphicalEditorPart graphicalEditor = PlayAnimationMenu.this.mCanvas.getEditorDelegate().getGraphicalEditor();
                            graphicalEditor.recomputeLayout();
                        }
                    });
                }
            })).isSuccess() && r.getErrorMessage() != null) {
                AdtPlugin.log(r.getException(), r.getErrorMessage(), new Object[0]);
            }
        }
    }
}

