/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gle2;

import com.android.ide.eclipse.adt.internal.editors.layout.gle2.LayoutPoint;

public class SelectionHandle {
    public static final int PIXEL_RADIUS = 3;
    public static final int PIXEL_MARGIN = 2;
    public final int centerX;
    public final int centerY;
    private final Position mPosition;

    public SelectionHandle(int centerX, int centerY, Position position) {
        this.mPosition = position;
        this.centerX = centerX;
        this.centerY = centerY;
    }

    public boolean contains(LayoutPoint point, int distance) {
        return point.x >= this.centerX - distance && point.x <= this.centerX + distance && point.y >= this.centerY - distance && point.y <= this.centerY + distance;
    }

    public Position getPosition() {
        return this.mPosition;
    }

    public int getSwtCursorType() {
        return this.mPosition.getCursorType();
    }

    static enum Position {
        TOP_MIDDLE(10),
        TOP_RIGHT(14),
        RIGHT_MIDDLE(12),
        BOTTOM_RIGHT(15),
        BOTTOM_MIDDLE(11),
        BOTTOM_LEFT(16),
        LEFT_MIDDLE(13),
        TOP_LEFT(17);

        private int mSwtCursor;

        private Position(int swtCursor) {
            this.mSwtCursor = swtCursor;
        }

        private int getCursorType() {
            return this.mSwtCursor;
        }

        boolean isLeft() {
            return this == TOP_LEFT || this == LEFT_MIDDLE || this == BOTTOM_LEFT;
        }

        boolean isRight() {
            return this == TOP_RIGHT || this == RIGHT_MIDDLE || this == BOTTOM_RIGHT;
        }

        boolean isTop() {
            return this == TOP_LEFT || this == TOP_MIDDLE || this == TOP_RIGHT;
        }

        boolean isBottom() {
            return this == BOTTOM_LEFT || this == BOTTOM_MIDDLE || this == BOTTOM_RIGHT;
        }
    }
}

