/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gle2;

import com.android.ide.common.api.DrawingStyle;
import org.eclipse.swt.graphics.RGB;

public enum SwtDrawingStyle {
    SELECTION(new RGB(0, 153, 255), 192, new RGB(0, 153, 255), 192, 1, 1),
    GUIDELINE(new RGB(0, 170, 0), 192, 1),
    GUIDELINE_SHADOW(new RGB(0, 170, 0), 192, 1),
    GUIDELINE_DASHED(new RGB(0, 170, 0), 192, 6),
    DISTANCE(new RGB(255, 0, 0), 160, 1),
    GRID(new RGB(170, 170, 170), 128, 1),
    HOVER(null, 0, new RGB(255, 255, 255), 40, 1, 3),
    HOVER_SELECTION(null, 0, new RGB(255, 255, 255), 10, 1, 3),
    ANCHOR(new RGB(0, 153, 255), 96, 1),
    OUTLINE(new RGB(136, 255, 136), 160, 1),
    DROP_RECIPIENT(new RGB(255, 153, 0), 255, new RGB(255, 153, 0), 160, 2, 1),
    DROP_ZONE(new RGB(0, 170, 0), 220, new RGB(85, 170, 0), 200, 1, 1),
    DROP_ZONE_ACTIVE(new RGB(0, 170, 0), 220, new RGB(0, 170, 0), 128, 2, 1),
    DROP_PREVIEW(new RGB(255, 153, 0), 255, null, 0, 2, 6),
    RESIZE_PREVIEW(new RGB(255, 153, 0), 255, null, 0, 2, 1),
    RESIZE_FAIL(new RGB(255, 153, 0), 255, null, 0, 2, 6),
    HELP(new RGB(255, 255, 255), 255, new RGB(0, 0, 0), 128, 1, 1),
    INVALID(new RGB(255, 255, 255), 255, new RGB(255, 0, 0), 64, 2, 1),
    DEPENDENCY(new RGB(255, 255, 255), 255, new RGB(255, 255, 0), 24, 2, 1),
    CYCLE(new RGB(255, 0, 0), 192, null, 0, 1, 1),
    DRAGGED(new RGB(255, 255, 255), 255, new RGB(0, 255, 0), 16, 2, 1),
    EMPTY(new RGB(255, 255, 85), 255, new RGB(255, 255, 85), 255, 1, 2),
    CUSTOM1(new RGB(255, 0, 255), 255, null, 0, 1, 1),
    CUSTOM2(new RGB(0, 255, 255), 255, null, 0, 1, 3);

    private final RGB mStroke;
    private final RGB mFill;
    private final int mLineWidth;
    private final int mLineStyle;
    private final int mStrokeAlpha;
    private final int mFillAlpha;

    private SwtDrawingStyle(RGB stroke, int strokeAlpha, RGB fill, int fillAlpha, int lineWidth, int lineStyle) {
        this.mStroke = stroke;
        this.mFill = fill;
        this.mLineWidth = lineWidth;
        this.mLineStyle = lineStyle;
        this.mStrokeAlpha = strokeAlpha;
        this.mFillAlpha = fillAlpha;
    }

    private SwtDrawingStyle(RGB stroke, int strokeAlpha, int lineStyle) {
        this(stroke, strokeAlpha, null, 255, 1, lineStyle);
    }

    public RGB getStrokeColor() {
        return this.mStroke;
    }

    public RGB getFillColor() {
        return this.mFill;
    }

    public int getLineWidth() {
        return this.mLineWidth;
    }

    public int getLineStyle() {
        return this.mLineStyle;
    }

    public int getStrokeAlpha() {
        return this.mStrokeAlpha;
    }

    public int getFillAlpha() {
        return this.mFillAlpha;
    }

    public static SwtDrawingStyle of(DrawingStyle style) {
        switch (style) {
            case SELECTION: {
                return SELECTION;
            }
            case GUIDELINE: {
                return GUIDELINE;
            }
            case GUIDELINE_SHADOW: {
                return GUIDELINE_SHADOW;
            }
            case GUIDELINE_DASHED: {
                return GUIDELINE_DASHED;
            }
            case DISTANCE: {
                return DISTANCE;
            }
            case GRID: {
                return GRID;
            }
            case HOVER: {
                return HOVER;
            }
            case HOVER_SELECTION: {
                return HOVER_SELECTION;
            }
            case ANCHOR: {
                return ANCHOR;
            }
            case OUTLINE: {
                return OUTLINE;
            }
            case DROP_ZONE: {
                return DROP_ZONE;
            }
            case DROP_ZONE_ACTIVE: {
                return DROP_ZONE_ACTIVE;
            }
            case DROP_RECIPIENT: {
                return DROP_RECIPIENT;
            }
            case DROP_PREVIEW: {
                return DROP_PREVIEW;
            }
            case RESIZE_PREVIEW: {
                return RESIZE_PREVIEW;
            }
            case RESIZE_FAIL: {
                return RESIZE_FAIL;
            }
            case HELP: {
                return HELP;
            }
            case INVALID: {
                return INVALID;
            }
            case DEPENDENCY: {
                return DEPENDENCY;
            }
            case CYCLE: {
                return CYCLE;
            }
            case DRAGGED: {
                return DRAGGED;
            }
            case EMPTY: {
                return EMPTY;
            }
            case CUSTOM1: {
                return CUSTOM1;
            }
            case CUSTOM2: {
                return CUSTOM2;
            }
        }
        throw new IllegalArgumentException("Unknown style " + style);
    }
}

