/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.properties;

import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.eclipse.adt.internal.editors.AndroidXmlEditor;
import com.android.ide.eclipse.adt.internal.editors.common.CommonXmlEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.properties.XmlProperty;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiResourceAttributeNode;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectResources;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceManager;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.resources.ResourceType;
import com.android.utils.SdkUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

class ResourceValueCompleter
implements IContentProposalProvider {
    protected final XmlProperty xmlProperty;

    ResourceValueCompleter(XmlProperty xmlProperty) {
        this.xmlProperty = xmlProperty;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        CommonXmlEditor editor;
        if (contents.startsWith("@") && (editor = this.xmlProperty.getXmlEditor()) != null) {
            String[] matches = ResourceValueCompleter.computeResourceStringMatches(editor, this.xmlProperty.mDescriptor, contents.substring(0, position));
            ArrayList<ContentProposal> proposals = null;
            if (matches != null && matches.length > 0) {
                proposals = new ArrayList<ContentProposal>(matches.length);
                String[] stringArray = matches;
                int n = matches.length;
                int n2 = 0;
                while (n2 < n) {
                    String match = stringArray[n2];
                    proposals.add(new ContentProposal(match));
                    ++n2;
                }
                return proposals.toArray(new IContentProposal[proposals.size()]);
            }
        }
        return new IContentProposal[0];
    }

    static String[] computeResourceStringMatches(AndroidXmlEditor editor, AttributeDescriptor attributeDescriptor, String prefix) {
        ResourceManager manager;
        ProjectResources repository;
        IProject project;
        ResourceRepository repository2;
        AndroidTargetData data;
        ArrayList<String> results = new ArrayList<String>(200);
        if (prefix.startsWith("@a") && prefix.regionMatches(true, 0, "@android:", 0, Math.min(prefix.length() - 1, "@android:".length()))) {
            data = editor.getTargetData();
            if (data != null) {
                repository2 = data.getFrameworkResources();
                ResourceValueCompleter.addMatches(repository2, prefix, true, results);
            }
        } else if (prefix.startsWith("?") && prefix.regionMatches(true, 0, "?android:", 0, Math.min(prefix.length() - 1, "?android:".length())) && (data = editor.getTargetData()) != null) {
            repository2 = data.getFrameworkResources();
            ResourceValueCompleter.addMatches(repository2, prefix, true, results);
        }
        if (!prefix.startsWith("@and") && !prefix.startsWith("?and") && (project = editor.getProject()) != null && (repository = (manager = ResourceManager.getInstance()).getProjectResources(project)) != null) {
            ResourceValueCompleter.addMatches(repository, prefix, false, results);
        }
        if (attributeDescriptor != null) {
            UiResourceAttributeNode.sortAttributeChoices(attributeDescriptor, results);
        } else {
            Collections.sort(results);
        }
        return results.toArray(new String[results.size()]);
    }

    private static void addMatches(ResourceRepository repository, String prefix, boolean isSystem, List<String> results) {
        int typeStart = isSystem ? "@android:".length() : "@".length();
        for (ResourceType type : repository.getAvailableResourceTypes()) {
            if (!prefix.regionMatches(typeStart, type.getName(), 0, Math.min(type.getName().length(), prefix.length() - typeStart))) continue;
            StringBuilder sb = new StringBuilder();
            if (prefix.length() == 0 || prefix.startsWith("@")) {
                sb.append("@");
            } else {
                if (type != ResourceType.ATTR) continue;
                sb.append("?");
            }
            if (type == ResourceType.ID && prefix.startsWith("@+id/")) {
                sb.append('+');
            }
            if (isSystem) {
                sb.append("android").append(':');
            }
            sb.append(type.getName()).append('/');
            String base = sb.toString();
            int nameStart = typeStart + type.getName().length() + 1;
            String namePrefix = prefix.length() <= nameStart ? "" : prefix.substring(nameStart);
            for (ResourceItem item : repository.getResourceItemsOfType(type)) {
                String name = item.getName();
                if (!SdkUtils.startsWithIgnoreCase((String)name, (String)namePrefix)) continue;
                results.add(String.valueOf(base) + name);
            }
        }
    }
}

