/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.refactoring;

import com.android.annotations.NonNull;
import com.android.ide.common.xml.XmlFormatStyle;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.LayoutEditorDelegate;
import com.android.ide.eclipse.adt.internal.editors.layout.descriptors.ViewElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.CanvasViewInfo;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.DomUtilities;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.LayoutCanvas;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.ViewHierarchy;
import com.android.ide.eclipse.adt.internal.editors.layout.refactoring.ChangeLayoutWizard;
import com.android.ide.eclipse.adt.internal.editors.layout.refactoring.GridLayoutConverter;
import com.android.ide.eclipse.adt.internal.editors.layout.refactoring.RelativeLayoutConversionHelper;
import com.android.ide.eclipse.adt.internal.editors.layout.refactoring.VisualRefactoring;
import com.android.ide.eclipse.adt.internal.editors.layout.refactoring.VisualRefactoringWizard;
import com.android.ide.eclipse.adt.internal.preferences.AdtPrefs;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChangeLayoutRefactoring
extends VisualRefactoring {
    private static final String KEY_TYPE = "type";
    private static final String KEY_FLATTEN = "flatten";
    private String mTypeFqcn;
    private String mInitializedAttributes;
    private boolean mFlatten;
    protected CanvasViewInfo mRootView;

    ChangeLayoutRefactoring(Map<String, String> arguments) {
        super(arguments);
        this.mTypeFqcn = arguments.get(KEY_TYPE);
        this.mFlatten = Boolean.parseBoolean(arguments.get(KEY_FLATTEN));
    }

    ChangeLayoutRefactoring(List<Element> selectedElements, LayoutEditorDelegate delegate) {
        super(selectedElements, delegate);
    }

    public ChangeLayoutRefactoring(IFile file, LayoutEditorDelegate delegate, ITextSelection selection, ITreeSelection treeSelection) {
        super(file, delegate, selection, treeSelection);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            pm.beginTask("Checking preconditions...", 2);
            if (this.mSelectionStart == -1 || this.mSelectionEnd == -1) {
                status.addFatalError("No selection to convert");
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            if (this.mElements.size() != 1) {
                status.addFatalError("Select precisely one layout to convert");
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    @Override
    protected VisualRefactoring.VisualRefactoringDescriptor createDescriptor() {
        String comment = this.getName();
        return new Descriptor(this.mProject.getName(), comment, comment, this.createArgumentMap());
    }

    @Override
    protected Map<String, String> createArgumentMap() {
        Map<String, String> args = super.createArgumentMap();
        args.put(KEY_TYPE, this.mTypeFqcn);
        args.put(KEY_FLATTEN, Boolean.toString(this.mFlatten));
        return args;
    }

    public String getName() {
        return "Change Layout";
    }

    void setType(String typeFqcn) {
        this.mTypeFqcn = typeFqcn;
    }

    void setInitializedAttributes(String initializedAttributes) {
        this.mInitializedAttributes = initializedAttributes;
    }

    void setFlatten(boolean flatten) {
        this.mFlatten = flatten;
    }

    @Override
    protected List<Element> initElements() {
        List<Element> elements = super.initElements();
        for (Element element : elements) {
            String tagName = element.getTagName();
            if (!tagName.equals("GestureOverlayView") && !tagName.equals("android.gesture.GestureOverlayView")) continue;
            ArrayList<Element> replacement = new ArrayList<Element>(elements.size());
            for (Element e : elements) {
                tagName = e.getTagName();
                if (tagName.equals("GestureOverlayView") || tagName.equals("android.gesture.GestureOverlayView")) {
                    NodeList children = e.getChildNodes();
                    Element first = null;
                    int i = 0;
                    int n = children.getLength();
                    while (i < n) {
                        Node node = children.item(i);
                        if (node.getNodeType() == 1) {
                            first = (Element)node;
                            break;
                        }
                        ++i;
                    }
                    if (first != null) {
                        e = first;
                    }
                }
                replacement.add(e);
            }
            return replacement;
        }
        return elements;
    }

    @Override
    @NonNull
    protected List<Change> computeChanges(IProgressMonitor monitor) {
        MultiTextEdit formatted;
        String name = this.getViewClass(this.mTypeFqcn);
        IFile file = this.mDelegate.getEditor().getInputFile();
        ArrayList<Change> changes = new ArrayList<Change>();
        if (file == null) {
            return changes;
        }
        TextFileChange change = new TextFileChange(file.getName(), file);
        MultiTextEdit rootEdit = new MultiTextEdit();
        change.setTextType("xml");
        changes.add((Change)change);
        String text = this.getText(this.mSelectionStart, this.mSelectionEnd);
        Element layout = this.getPrimaryElement();
        String oldName = layout.getNodeName();
        int open = text.indexOf(oldName);
        int close = text.lastIndexOf(oldName);
        if (open != -1 && close != -1) {
            int oldLength = oldName.length();
            rootEdit.addChild((TextEdit)new ReplaceEdit(this.mSelectionStart + open, oldLength, name));
            if (close != open) {
                rootEdit.addChild((TextEdit)new ReplaceEdit(this.mSelectionStart + close, oldLength, name));
            }
        }
        String oldId = ChangeLayoutRefactoring.getId(layout);
        String newId = this.ensureIdMatchesType(layout, this.mTypeFqcn, rootEdit);
        if (oldId != null && newId != null) {
            IStructuredModel model = this.mDelegate.getEditor().getModelForRead();
            try {
                IStructuredDocument doc = model.getStructuredDocument();
                if (doc != null) {
                    List<TextEdit> replaceIds = ChangeLayoutRefactoring.replaceIds(this.getAndroidNamespacePrefix(), doc, this.mSelectionStart, this.mSelectionEnd, oldId, newId);
                    for (TextEdit edit : replaceIds) {
                        rootEdit.addChild(edit);
                    }
                }
            }
            finally {
                model.releaseFromRead();
            }
        }
        String oldType = this.getOldType();
        String newType = this.mTypeFqcn;
        if (newType.equals("android.widget.RelativeLayout")) {
            if (oldType.equals("android.widget.LinearLayout") && !this.mFlatten) {
                this.convertLinearToRelative(rootEdit);
                this.removeUndefinedAttrs(rootEdit, layout);
                this.addMissingWrapContentAttributes(rootEdit, layout, oldType, newType, null);
            } else {
                this.convertAnyToRelative(rootEdit, oldType, newType);
            }
        } else if (newType.equals("android.widget.GridLayout")) {
            this.convertAnyToGridLayout(rootEdit);
            this.removeUndefinedAttrs(rootEdit, layout, false);
        } else if (oldType.equals("android.widget.RelativeLayout") && newType.equals("android.widget.LinearLayout")) {
            this.convertRelativeToLinear(rootEdit);
            this.removeUndefinedAttrs(rootEdit, layout);
            this.addMissingWrapContentAttributes(rootEdit, layout, oldType, newType, null);
        } else if (oldType.equals("android.widget.LinearLayout") && newType.equals("android.widget.TableLayout")) {
            this.convertLinearToTable(rootEdit);
            this.removeUndefinedAttrs(rootEdit, layout);
            this.addMissingWrapContentAttributes(rootEdit, layout, oldType, newType, null);
        } else {
            this.convertGeneric(rootEdit, oldType, newType, layout);
        }
        if (this.mInitializedAttributes != null && this.mInitializedAttributes.length() > 0) {
            String namespace = this.getAndroidNamespacePrefix();
            String[] stringArray = this.mInitializedAttributes.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                String[] nameValue = s.split("=");
                String attribute = nameValue[0];
                String value = nameValue[1];
                String prefix = null;
                String namespaceUri = null;
                if (attribute.startsWith("android:")) {
                    prefix = namespace;
                    namespaceUri = "http://schemas.android.com/apk/res/android";
                    attribute = attribute.substring("android:".length());
                }
                this.setAttribute(rootEdit, layout, namespaceUri, prefix, attribute, value);
                ++n2;
            }
        }
        if (AdtPrefs.getPrefs().getFormatGuiXml() && (formatted = this.reformat(rootEdit, XmlFormatStyle.LAYOUT)) != null) {
            rootEdit = formatted;
        }
        change.setEdit((TextEdit)rootEdit);
        return changes;
    }

    private void addMissingWrapContentAttributes(MultiTextEdit rootEdit, Element layout, String oldType, String newType, Set<Element> skip) {
        if (oldType.equals("android.widget.GridLayout") && !newType.equals("android.widget.GridLayout")) {
            String namespace = this.getAndroidNamespacePrefix();
            for (Element child : DomUtilities.getChildren(layout)) {
                if (skip != null && skip.contains(child)) continue;
                if (!child.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_width")) {
                    this.setAttribute(rootEdit, child, "http://schemas.android.com/apk/res/android", namespace, "layout_width", "wrap_content");
                }
                if (child.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_height")) continue;
                this.setAttribute(rootEdit, child, "http://schemas.android.com/apk/res/android", namespace, "layout_height", "wrap_content");
            }
        }
    }

    private void convertLinearToTable(MultiTextEdit rootEdit) {
        Element layout = this.getPrimaryElement();
        this.removeOrientationAttribute(rootEdit, layout);
        NodeList children = layout.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            Node node = children.item(i);
            if (node.getNodeType() == 1) {
                Element child = (Element)node;
                if (node instanceof IndexedRegion) {
                    IndexedRegion region = (IndexedRegion)node;
                    int start = region.getStartOffset();
                    int end = region.getEndOffset();
                    String text = this.getText(start, end);
                    String oldName = child.getNodeName();
                    if (oldName.equals("LinearLayout")) {
                        this.removeOrientationAttribute(rootEdit, child);
                        int open = text.indexOf(oldName);
                        int close = text.lastIndexOf(oldName);
                        if (open != -1 && close != -1) {
                            int oldLength = oldName.length();
                            rootEdit.addChild((TextEdit)new ReplaceEdit(this.mSelectionStart + open, oldLength, "TableRow"));
                            if (close != open) {
                                rootEdit.addChild((TextEdit)new ReplaceEdit(this.mSelectionStart + close, oldLength, "TableRow"));
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    private void convertLinearToRelative(MultiTextEdit rootEdit) {
        Element layout = this.getPrimaryElement();
        boolean isVertical = "vertical".equals(layout.getAttributeNS("http://schemas.android.com/apk/res/android", "orientation"));
        String attributePrefix = this.getAndroidNamespacePrefix();
        if (isVertical) {
            NodeList children = layout.getChildNodes();
            String prevId = null;
            int i = 0;
            int n = children.getLength();
            while (i < n) {
                Node node = children.item(i);
                if (node.getNodeType() == 1) {
                    Element child = (Element)node;
                    String id = this.ensureHasId(rootEdit, child, null);
                    if (prevId != null) {
                        this.setAttribute(rootEdit, child, "http://schemas.android.com/apk/res/android", attributePrefix, "layout_below", prevId);
                    }
                    prevId = id;
                }
                ++i;
            }
        } else {
            NodeList children = layout.getChildNodes();
            boolean isBaselineAligned = !"false".equals(layout.getAttributeNS("http://schemas.android.com/apk/res/android", "baselineAligned"));
            String prevId = null;
            int i = 0;
            int n = children.getLength();
            while (i < n) {
                Node node = children.item(i);
                if (node.getNodeType() == 1) {
                    Element child = (Element)node;
                    String id = this.ensureHasId(rootEdit, child, null);
                    if (prevId != null) {
                        this.setAttribute(rootEdit, child, "http://schemas.android.com/apk/res/android", attributePrefix, "layout_toRightOf", prevId);
                        if (isBaselineAligned) {
                            this.setAttribute(rootEdit, child, "http://schemas.android.com/apk/res/android", attributePrefix, "layout_alignBaseline", prevId);
                        }
                    }
                    prevId = id;
                }
                ++i;
            }
        }
    }

    private void removeOrientationAttribute(MultiTextEdit rootEdit, Element layout) {
        assert (layout.getTagName().equals("LinearLayout"));
        this.removeAttribute(rootEdit, layout, "http://schemas.android.com/apk/res/android", "orientation");
    }

    private void convertRelativeToLinear(MultiTextEdit rootEdit) {
    }

    private void convertGeneric(MultiTextEdit rootEdit, String oldType, String newType, Element layout) {
        this.removeUndefinedAttrs(rootEdit, layout);
        this.addMissingWrapContentAttributes(rootEdit, layout, oldType, newType, null);
    }

    private void removeUndefinedAttrs(MultiTextEdit rootEdit, Element layout) {
        this.removeUndefinedAttrs(rootEdit, layout, true);
    }

    private void removeUndefinedAttrs(MultiTextEdit rootEdit, Element layout, boolean removeLayoutAttrs) {
        Object node;
        int n;
        int i;
        AttributeDescriptor attribute;
        HashSet<String> defined;
        ViewElementDescriptor descriptor = this.getElementDescriptor(this.mTypeFqcn);
        if (descriptor == null) {
            return;
        }
        if (removeLayoutAttrs) {
            AttributeDescriptor[] layoutAttributes;
            defined = new HashSet<String>();
            AttributeDescriptor[] attributeDescriptorArray = layoutAttributes = descriptor.getLayoutAttributes();
            int n2 = layoutAttributes.length;
            int n3 = 0;
            while (n3 < n2) {
                attribute = attributeDescriptorArray[n3];
                defined.add(attribute.getXmlLocalName());
                ++n3;
            }
            NodeList children = layout.getChildNodes();
            i = 0;
            n = children.getLength();
            while (i < n) {
                node = children.item(i);
                if (node.getNodeType() == 1) {
                    Element child = (Element)node;
                    List<Attr> attributes = this.findLayoutAttributes(child);
                    for (Attr attribute2 : attributes) {
                        String name = attribute2.getLocalName();
                        if (defined.contains(name)) continue;
                        try {
                            this.removeAttribute(rootEdit, child, attribute2.getNamespaceURI(), name);
                        }
                        catch (MalformedTreeException malformedTreeException) {
                            AdtPlugin.log(2, "Could not remove unsupported attribute %1$s; already modified during refactoring?", attribute2.getLocalName());
                        }
                    }
                }
                ++i;
            }
        }
        defined = new HashSet();
        AttributeDescriptor[] attributes = descriptor.getAttributes();
        node = attributes;
        n = attributes.length;
        i = 0;
        while (i < n) {
            attribute = node[i];
            defined.add(attribute.getXmlLocalName());
            ++i;
        }
        NamedNodeMap attributeMap = layout.getAttributes();
        i = 0;
        n = attributeMap.getLength();
        while (i < n) {
            Node attributeNode = attributeMap.item(i);
            String name = attributeNode.getLocalName();
            if (!name.startsWith("layout_") && "http://schemas.android.com/apk/res/android".equals(attributeNode.getNamespaceURI()) && !defined.contains(name)) {
                this.removeAttribute(rootEdit, layout, "http://schemas.android.com/apk/res/android", name);
            }
            ++i;
        }
    }

    private void convertAnyToRelative(MultiTextEdit rootEdit, String oldType, String newType) {
        Element layout = this.getPrimaryElement();
        CanvasViewInfo rootView = this.mRootView;
        if (rootView == null) {
            LayoutCanvas canvas = this.mDelegate.getGraphicalEditor().getCanvasControl();
            ViewHierarchy viewHierarchy = canvas.getViewHierarchy();
            rootView = viewHierarchy.getRoot();
        }
        RelativeLayoutConversionHelper helper = new RelativeLayoutConversionHelper(this, layout, this.mFlatten, rootEdit, rootView);
        helper.convertToRelative();
        List<Element> deletedElements = helper.getDeletedElements();
        HashSet<Element> deleted = null;
        if (deletedElements != null && deletedElements.size() > 0) {
            deleted = new HashSet<Element>(deletedElements);
        }
        this.addMissingWrapContentAttributes(rootEdit, layout, oldType, newType, deleted);
    }

    private void convertAnyToGridLayout(MultiTextEdit rootEdit) {
        Element layout = this.getPrimaryElement();
        CanvasViewInfo rootView = this.mRootView;
        if (rootView == null) {
            LayoutCanvas canvas = this.mDelegate.getGraphicalEditor().getCanvasControl();
            ViewHierarchy viewHierarchy = canvas.getViewHierarchy();
            rootView = viewHierarchy.getRoot();
        }
        GridLayoutConverter converter = new GridLayoutConverter(this, layout, this.mFlatten, rootEdit, rootView);
        converter.convertToGridLayout();
    }

    String getOldType() {
        Element primary = this.getPrimaryElement();
        if (primary != null) {
            String oldType = primary.getTagName();
            if (oldType.indexOf(46) == -1) {
                oldType = "android.widget." + oldType;
            }
            return oldType;
        }
        return null;
    }

    public void setRootView(CanvasViewInfo rootView) {
        this.mRootView = rootView;
    }

    @Override
    VisualRefactoringWizard createWizard() {
        return new ChangeLayoutWizard(this, this.mDelegate);
    }

    public static class Descriptor
    extends VisualRefactoring.VisualRefactoringDescriptor {
        public Descriptor(String project, String description, String comment, Map<String, String> arguments) {
            super("com.android.ide.eclipse.adt.refactoring.convert", project, description, comment, arguments);
        }

        @Override
        protected Refactoring createRefactoring(Map<String, String> args) {
            return new ChangeLayoutRefactoring(args);
        }
    }
}

