/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.otherxml;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.common.CommonXmlDelegate;
import com.android.ide.eclipse.adt.internal.editors.common.CommonXmlEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DocumentDescriptor;
import com.android.ide.eclipse.adt.internal.editors.otherxml.OtherXmlContentAssist;
import com.android.ide.eclipse.adt.internal.editors.otherxml.OtherXmlTreePage;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.resources.ResourceFolderType;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.w3c.dom.Document;

public class OtherXmlEditorDelegate
extends CommonXmlDelegate {
    public static final String LEGACY_EDITOR_ID = "com.android.ide.eclipse.editors.xml.XmlEditor";

    public OtherXmlEditorDelegate(CommonXmlEditor editor) {
        super(editor, new OtherXmlContentAssist());
        editor.addDefaultTargetListener();
    }

    @Override
    public void delegateCreateFormPages() {
        try {
            this.getEditor().addPage((IFormPage)new OtherXmlTreePage(this.getEditor()));
        }
        catch (PartInitException e) {
            AdtPlugin.log(e, "Error creating nested page", new Object[0]);
        }
    }

    @Override
    public void delegateXmlModelChanged(Document xml_doc) {
        this.delegateInitUiRootNode(false);
        this.getUiRootNode().loadFromXmlNode(xml_doc);
    }

    @Override
    public void delegateInitUiRootNode(boolean force) {
        if (this.getUiRootNode() == null || force) {
            AndroidTargetData data;
            Document doc = null;
            if (this.getUiRootNode() != null) {
                doc = this.getUiRootNode().getXmlDocument();
            }
            DocumentDescriptor desc = (data = this.getEditor().getTargetData()) == null ? new DocumentDescriptor("temp", null) : data.getXmlDescriptors().getDescriptor();
            this.setUiRootNode(desc.createUiNode());
            this.getUiRootNode().setEditor(this.getEditor());
            this.onDescriptorsChanged(doc);
        }
    }

    private void onDescriptorsChanged(Document document) {
        if (document != null) {
            this.getUiRootNode().loadFromXmlNode(document);
        } else {
            this.getUiRootNode().reloadFromXmlNode(this.getUiRootNode().getXmlNode());
        }
    }

    public static class Creator
    implements CommonXmlDelegate.IDelegateCreator {
        public OtherXmlEditorDelegate createForFile(@NonNull CommonXmlEditor delegator, @Nullable ResourceFolderType type) {
            if (ResourceFolderType.XML == type) {
                return new OtherXmlEditorDelegate(delegator);
            }
            return null;
        }
    }
}

