/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.ui;

import com.android.ide.eclipse.adt.AdtPlugin;
import java.lang.reflect.Method;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public final class SectionHelper {
    public static Composite createTableLayout(Composite composite, FormToolkit toolkit, int numColumns) {
        Composite table = toolkit.createComposite(composite);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = numColumns;
        table.setLayout((Layout)layout);
        toolkit.paintBordersFor(table);
        if (composite instanceof Section) {
            ((Section)composite).setClient((Control)table);
        }
        return table;
    }

    public static Composite createGridLayout(Composite composite, FormToolkit toolkit, int numColumns) {
        Composite grid = toolkit.createComposite(composite);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        grid.setLayout((Layout)layout);
        toolkit.paintBordersFor(grid);
        if (composite instanceof Section) {
            ((Section)composite).setClient((Control)grid);
        }
        return grid;
    }

    public static Text createLabelAndText(Composite parent, FormToolkit toolkit, String label_text, String value, String tooltip) {
        Label label = toolkit.createLabel(parent, label_text);
        label.setLayoutData((Object)new TableWrapData(2, 32));
        Text text = toolkit.createText(parent, value);
        text.setLayoutData((Object)new TableWrapData(256, 32));
        SectionHelper.addControlTooltip((Control)label, tooltip);
        return text;
    }

    public static Label createLabel(Composite parent, FormToolkit toolkit, String label_text, String tooltip) {
        Label label = toolkit.createLabel(parent, label_text);
        TableWrapData twd = new TableWrapData(256);
        if (parent.getLayout() instanceof TableWrapLayout) {
            twd.colspan = ((TableWrapLayout)parent.getLayout()).numColumns;
        }
        label.setLayoutData((Object)twd);
        SectionHelper.addControlTooltip((Control)label, tooltip);
        return label;
    }

    public static void addControlTooltip(final Control control, String tooltip) {
        if (control == null || tooltip == null || tooltip.length() == 0) {
            return;
        }
        if (control instanceof Button) {
            control.setToolTipText(tooltip);
            return;
        }
        control.setToolTipText(null);
        final DefaultInformationControl ic = new DefaultInformationControl(control.getShell());
        ic.setInformation(tooltip);
        Point sz = ic.computeSizeHint();
        ic.setSize(sz.x, sz.y);
        ic.setVisible(false);
        control.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                ic.setVisible(false);
            }

            public void mouseHover(MouseEvent e) {
                ic.setLocation(control.toDisplay(10, 25));
                ic.setVisible(true);
            }
        });
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ic.dispose();
            }
        });
    }

    public static FormText createFormText(Composite parent, FormToolkit toolkit, boolean isHtml, String label, boolean setupLayoutData) {
        FormText text = toolkit.createFormText(parent, true);
        if (setupLayoutData) {
            TableWrapData twd = new TableWrapData(256);
            twd.maxWidth = 50;
            if (parent.getLayout() instanceof TableWrapLayout) {
                twd.colspan = ((TableWrapLayout)parent.getLayout()).numColumns;
            }
            text.setLayoutData((Object)twd);
        }
        text.setWhitespaceNormalized(true);
        if (isHtml && !label.startsWith("<form>")) {
            label = "<form>" + label + "</form>";
        }
        text.setText(label, isHtml, isHtml);
        return text;
    }

    public static class ManifestSectionPart
    extends SectionPart {
        public ManifestSectionPart(Composite body, FormToolkit toolkit) {
            this(body, toolkit, 0, false);
        }

        public ManifestSectionPart(Composite body, FormToolkit toolkit, int extra_style, boolean use_description) {
            super(body, toolkit, extra_style | 0x100 | (use_description ? 128 : 0));
        }

        public Composite createTableLayout(FormToolkit toolkit, int numColumns) {
            return SectionHelper.createTableLayout((Composite)this.getSection(), toolkit, numColumns);
        }

        public Label createLabel(Composite parent, FormToolkit toolkit, String label, String tooltip) {
            return SectionHelper.createLabel(parent, toolkit, label, tooltip);
        }

        public Text createLabelAndText(Composite parent, FormToolkit toolkit, String label, String value, String tooltip) {
            return SectionHelper.createLabelAndText(parent, toolkit, label, value, tooltip);
        }

        public FormText createFormText(Composite parent, FormToolkit toolkit, boolean isHtml, String label, boolean setupLayoutData) {
            return SectionHelper.createFormText(parent, toolkit, isHtml, label, setupLayoutData);
        }

        public void layoutChanged() {
            Section section = this.getSection();
            try {
                Method reflow = section.getClass().getDeclaredMethod("reflow", null);
                reflow.setAccessible(true);
                reflow.invoke((Object)section, new Object[0]);
            }
            catch (Exception e) {
                AdtPlugin.log(e, "Error when invoking Section.reflow", new Object[0]);
            }
            section.layout(true, true);
        }
    }
}

