/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.values;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.common.CommonXmlDelegate;
import com.android.ide.eclipse.adt.internal.editors.common.CommonXmlEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.values.ValuesContentAssist;
import com.android.ide.eclipse.adt.internal.editors.values.ValuesTreePage;
import com.android.ide.eclipse.adt.internal.editors.values.descriptors.ValuesDescriptors;
import com.android.resources.ResourceFolderType;
import com.android.xml.AndroidXPathFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ValuesEditorDelegate
extends CommonXmlDelegate {
    public static final String LEGACY_EDITOR_ID = "com.android.ide.eclipse.editors.resources.ResourcesEditor";

    private ValuesEditorDelegate(CommonXmlEditor editor) {
        super(editor, new ValuesContentAssist());
        editor.addDefaultTargetListener();
    }

    @Override
    public void delegateCreateFormPages() {
        try {
            this.getEditor().addPage((IFormPage)new ValuesTreePage(this.getEditor()));
        }
        catch (PartInitException e) {
            AdtPlugin.log(4, "Error creating nested page", new Object[0]);
            AdtPlugin.getDefault().getLog().log(e.getStatus());
        }
    }

    @Override
    public void delegateXmlModelChanged(Document xml_doc) {
        this.delegateInitUiRootNode(false);
        this.getUiRootNode().setXmlDocument(xml_doc);
        if (xml_doc != null) {
            ElementDescriptor resources_desc = ValuesDescriptors.getInstance().getElementDescriptor();
            try {
                XPath xpath = AndroidXPathFactory.newXPath();
                Node node = (Node)xpath.evaluate("/" + resources_desc.getXmlName(), xml_doc, XPathConstants.NODE);
                assert (node == null || node.getNodeName().equals(resources_desc.getXmlName()));
                this.getUiRootNode().loadFromXmlNode(node);
            }
            catch (XPathExpressionException e) {
                AdtPlugin.log(e, "XPath error when trying to find '%s' element in XML.", resources_desc.getXmlName());
            }
        }
    }

    @Override
    public void delegateInitUiRootNode(boolean force) {
        if (this.getUiRootNode() == null || force) {
            ElementDescriptor resources_desc = ValuesDescriptors.getInstance().getElementDescriptor();
            this.setUiRootNode(resources_desc.createUiNode());
            this.getUiRootNode().setEditor(this.getEditor());
            this.onDescriptorsChanged();
        }
    }

    private void onDescriptorsChanged() {
    }

    /* synthetic */ ValuesEditorDelegate(CommonXmlEditor commonXmlEditor, ValuesEditorDelegate valuesEditorDelegate) {
        this(commonXmlEditor);
    }

    public static class Creator
    implements CommonXmlDelegate.IDelegateCreator {
        public ValuesEditorDelegate createForFile(@NonNull CommonXmlEditor delegator, @Nullable ResourceFolderType type) {
            if (ResourceFolderType.VALUES == type) {
                return new ValuesEditorDelegate(delegator, null);
            }
            return null;
        }
    }
}

