/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.launch;

import com.android.ide.common.xml.ManifestData;
import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.launch.AndroidLaunchController;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestHelper;
import com.android.ide.eclipse.adt.internal.project.ProjectChooserHelper;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MainLaunchConfigTab
extends AbstractLaunchConfigurationTab {
    public static final String LAUNCH_TAB_IMAGE = "mainLaunchTab";
    protected static final String EMPTY_STRING = "";
    protected Text mProjText;
    private Button mProjButton;
    private Combo mActivityCombo;
    private final ArrayList<ManifestData.Activity> mActivities = new ArrayList();
    private WidgetListener mListener = new WidgetListener();
    private Button mDefaultActionButton;
    private Button mActivityActionButton;
    private Button mDoNothingActionButton;
    private int mLaunchAction = 0;
    private ProjectChooserHelper mProjectChooserHelper;

    protected ProjectChooserHelper.IProjectChooserFilter getProjectFilter() {
        return new ProjectChooserHelper.NonLibraryProjectOnlyFilter();
    }

    public void createControl(Composite parent) {
        this.mProjectChooserHelper = new ProjectChooserHelper(parent.getShell(), this.getProjectFilter());
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.verticalSpacing = 0;
        comp.setLayout((Layout)topLayout);
        comp.setFont(font);
        this.createProjectEditor(comp);
        this.createVerticalSpacer(comp, 1);
        Group group = new Group(comp, 0);
        group.setText("Launch Action:");
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.mDefaultActionButton = new Button((Composite)group, 16);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.mDefaultActionButton.setLayoutData((Object)gd);
        this.mDefaultActionButton.setText("Launch Default Activity");
        this.mDefaultActionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MainLaunchConfigTab.this.mDefaultActionButton.getSelection()) {
                    MainLaunchConfigTab.this.mLaunchAction = 0;
                    MainLaunchConfigTab.this.mActivityCombo.setEnabled(false);
                    MainLaunchConfigTab.this.checkParameters();
                }
            }
        });
        this.mActivityActionButton = new Button((Composite)group, 16);
        this.mActivityActionButton.setText("Launch:");
        this.mActivityActionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MainLaunchConfigTab.this.mActivityActionButton.getSelection()) {
                    MainLaunchConfigTab.this.mLaunchAction = 1;
                    MainLaunchConfigTab.this.mActivityCombo.setEnabled(true);
                    MainLaunchConfigTab.this.checkParameters();
                }
            }
        });
        this.mActivityCombo = new Combo((Composite)group, 12);
        gd = new GridData(768);
        this.mActivityCombo.setLayoutData((Object)gd);
        this.mActivityCombo.clearSelection();
        this.mActivityCombo.setEnabled(false);
        this.mActivityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainLaunchConfigTab.this.checkParameters();
            }
        });
        this.mDoNothingActionButton = new Button((Composite)group, 16);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.mDoNothingActionButton.setLayoutData((Object)gd);
        this.mDoNothingActionButton.setText("Do Nothing");
        this.mDoNothingActionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MainLaunchConfigTab.this.mDoNothingActionButton.getSelection()) {
                    MainLaunchConfigTab.this.mLaunchAction = 2;
                    MainLaunchConfigTab.this.mActivityCombo.setEnabled(false);
                    MainLaunchConfigTab.this.checkParameters();
                }
            }
        });
    }

    public String getName() {
        return "Android";
    }

    public Image getImage() {
        return IconFactory.getInstance().getIcon(LAUNCH_TAB_IMAGE);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.mProjText.getText());
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, true);
        configuration.setAttribute("com.android.ide.eclipse.adt.action", this.mLaunchAction);
        int selection = this.mActivityCombo.getSelectionIndex();
        if (this.mActivities != null && selection >= 0 && selection < this.mActivities.size()) {
            configuration.setAttribute("com.android.ide.eclipse.adt.activity", this.mActivities.get(selection).getName());
        }
        this.mapResources(configuration);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("com.android.ide.eclipse.adt.action", 0);
    }

    protected void createProjectEditor(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText("Project:");
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.mProjText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.mProjText.setLayoutData((Object)gd);
        this.mProjText.setFont(font);
        this.mProjText.addModifyListener((ModifyListener)this.mListener);
        this.mProjButton = this.createPushButton((Composite)group, "Browse...", null);
        this.mProjButton.addSelectionListener((SelectionListener)this.mListener);
    }

    protected WidgetListener getDefaultListener() {
        return this.mListener;
    }

    protected IJavaProject getJavaProject(IJavaModel javaModel) {
        String projectName = this.mProjText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return javaModel.getJavaProject(projectName);
    }

    protected void handleProjectButtonSelected() {
        IJavaProject javaProject = this.mProjectChooserHelper.chooseJavaProject(this.mProjText.getText().trim(), "Please select a project to launch");
        if (javaProject == null) {
            return;
        }
        String projectName = javaProject.getElementName();
        this.mProjText.setText(projectName);
        IProject project = javaProject.getProject();
        this.loadActivities(project);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        String projectName = EMPTY_STRING;
        try {
            projectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, EMPTY_STRING);
        }
        catch (CoreException coreException) {}
        this.mProjText.setText(projectName);
        IProject proj = this.mProjectChooserHelper.getAndroidProject(projectName);
        this.loadActivities(proj);
        this.mLaunchAction = 0;
        try {
            this.mLaunchAction = config.getAttribute("com.android.ide.eclipse.adt.action", this.mLaunchAction);
        }
        catch (CoreException coreException) {}
        this.mDefaultActionButton.setSelection(this.mLaunchAction == 0);
        this.mActivityActionButton.setSelection(this.mLaunchAction == 1);
        this.mDoNothingActionButton.setSelection(this.mLaunchAction == 2);
        String activityName = EMPTY_STRING;
        try {
            activityName = config.getAttribute("com.android.ide.eclipse.adt.activity", EMPTY_STRING);
        }
        catch (CoreException coreException) {}
        if (this.mLaunchAction != 1) {
            this.mActivityCombo.setEnabled(false);
            this.mActivityCombo.clearSelection();
        } else {
            this.mActivityCombo.setEnabled(true);
            if (activityName == null || activityName.equals(EMPTY_STRING)) {
                this.mActivityCombo.clearSelection();
            } else if (this.mActivities != null && this.mActivities.size() > 0) {
                boolean found = false;
                int i = 0;
                while (i < this.mActivities.size()) {
                    if (activityName.equals(this.mActivities.get(i).getName())) {
                        found = true;
                        this.mActivityCombo.select(i);
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    this.mActivityCombo.clearSelection();
                }
            }
        }
    }

    protected void mapResources(ILaunchConfigurationWorkingCopy config) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)workspaceRoot);
        IJavaProject javaProject = this.getJavaProject(javaModel);
        IResource[] resources = null;
        if (javaProject != null) {
            resources = AndroidLaunchController.getResourcesToMap(javaProject.getProject());
        }
        config.setMappedResources(resources);
    }

    private void loadActivities(IProject project) {
        ManifestData manifestData;
        if (project != null && (manifestData = AndroidManifestHelper.parseForData(project)) != null) {
            ManifestData.Activity[] activities = manifestData.getActivities();
            this.mActivities.clear();
            this.mActivityCombo.removeAll();
            ManifestData.Activity[] activityArray = activities;
            int n = activities.length;
            int n2 = 0;
            while (n2 < n) {
                ManifestData.Activity activity = activityArray[n2];
                if (activity.isExported() && activity.hasAction()) {
                    this.mActivities.add(activity);
                    this.mActivityCombo.add(activity.getName());
                }
                ++n2;
            }
            if (this.mActivities.size() > 0) {
                if (this.mLaunchAction == 1) {
                    this.mActivityCombo.setEnabled(true);
                }
            } else {
                this.mActivityCombo.setEnabled(false);
            }
            this.mActivityCombo.clearSelection();
            return;
        }
        this.mActivityCombo.removeAll();
        this.mActivities.clear();
    }

    private IProject checkParameters() {
        block9: {
            try {
                String text = this.mProjText.getText();
                if (text.length() == 0) {
                    this.setErrorMessage("Project Name is required!");
                    break block9;
                }
                if (!text.matches("[a-zA-Z0-9_ \\.-]+")) {
                    this.setErrorMessage("Project name contains unsupported characters!");
                    break block9;
                }
                IJavaProject[] projects = this.mProjectChooserHelper.getAndroidProjects(null);
                IProject found = null;
                IJavaProject[] iJavaProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaProject javaProject = iJavaProjectArray[n2];
                    if (javaProject.getProject().getName().equals(text)) {
                        found = javaProject.getProject();
                        break;
                    }
                    ++n2;
                }
                if (found != null) {
                    this.setErrorMessage(null);
                } else {
                    this.setErrorMessage(String.format("There is no android project named '%1$s'", text));
                }
                IProject iProject = found;
                return iProject;
            }
            finally {
                this.updateLaunchConfigurationDialog();
            }
        }
        return null;
    }

    private class WidgetListener
    implements ModifyListener,
    SelectionListener {
        private WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            IProject project = MainLaunchConfigTab.this.checkParameters();
            MainLaunchConfigTab.this.loadActivities(project);
            MainLaunchConfigTab.this.setDirty(true);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == MainLaunchConfigTab.this.mProjButton) {
                MainLaunchConfigTab.this.handleProjectButtonSelected();
            } else {
                MainLaunchConfigTab.this.checkParameters();
            }
        }
    }
}

