/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.lint;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.DomUtilities;
import com.android.ide.eclipse.adt.internal.lint.LintFix;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.w3c.dom.Node;

abstract class DocumentFix
extends LintFix {
    protected DocumentFix(String id, IMarker marker) {
        super(id, marker);
    }

    protected abstract void apply(IDocument var1, IStructuredModel var2, Node var3, int var4, int var5);

    public void apply(IDocument document) {
        if (!(document instanceof IStructuredDocument)) {
            AdtPlugin.log(null, "Unexpected document type: %1$s. Can't fix.", document.getClass().getName());
            return;
        }
        int start = this.mMarker.getAttribute("charStart", -1);
        int end = this.mMarker.getAttribute("charEnd", -1);
        if (start != -1 && end != -1) {
            IModelManager manager = StructuredModelManager.getModelManager();
            IStructuredModel model = manager.getModelForEdit((IStructuredDocument)document);
            Node node = DomUtilities.getNode(document, start);
            try {
                this.apply(document, model, node, start, end);
            }
            finally {
                model.releaseFromEdit();
            }
            if (!this.isCancelable()) {
                this.deleteMarker();
            }
        }
    }
}

