/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.lint;

import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.editors.layout.LayoutEditorDelegate;
import com.android.ide.eclipse.adt.internal.editors.layout.refactoring.UnwrapRefactoring;
import com.android.ide.eclipse.adt.internal.editors.layout.refactoring.VisualRefactoringWizard;
import com.android.ide.eclipse.adt.internal.lint.DocumentFix;
import com.android.tools.lint.checks.UselessViewDetector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class RemoveUselessViewFix
extends DocumentFix {
    private RemoveUselessViewFix(String id, IMarker marker) {
        super(id, marker);
    }

    @Override
    public boolean needsFocus() {
        return this.isCancelable();
    }

    @Override
    public boolean isCancelable() {
        return this.mId.equals(this.mId.equals(UselessViewDetector.USELESS_PARENT.getId()));
    }

    @Override
    protected void apply(IDocument document, IStructuredModel model, Node node, int start, int end) {
        if (node instanceof Element && node.getParentNode() instanceof Element) {
            Element element = (Element)node;
            Element parent = (Element)node.getParentNode();
            if (this.mId.equals(UselessViewDetector.USELESS_LEAF.getId())) {
                parent.removeChild(element);
            } else {
                assert (this.mId.equals(UselessViewDetector.USELESS_PARENT.getId()));
                LayoutEditorDelegate delegate = LayoutEditorDelegate.fromEditor(AdtUtils.getActiveEditor());
                if (delegate != null) {
                    IFile file = (IFile)this.mMarker.getResource();
                    TextSelection textSelection = new TextSelection(start, end - start);
                    UnwrapRefactoring refactoring = new UnwrapRefactoring(file, delegate, (ITextSelection)textSelection, null);
                    VisualRefactoringWizard wizard = refactoring.createWizard();
                    RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
                    try {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        op.run(window.getShell(), wizard.getDefaultPageTitle());
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    @Override
    public String getDisplayString() {
        return "Remove unnecessary view";
    }

    @Override
    public Image getImage() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        return sharedImages.getImage("IMG_ETOOL_DELETE");
    }
}

