/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.manager;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ScanningContext;
import com.android.ide.common.resources.platform.AttributeInfo;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.build.AaptParser;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.utils.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class IdeScanningContext
extends ScanningContext {
    private final IProject mProject;
    private final List<IResource> mScannedResources = new ArrayList<IResource>();
    private IResource mCurrentFile;
    private List<Pair<IResource, String>> mErrors;
    private Set<IProject> mFullAaptProjects;
    private boolean mValidate;
    private Map<String, AttributeInfo> mAttributeMap;
    private ResourceRepository mFrameworkResources;

    public IdeScanningContext(@NonNull ResourceRepository repository, @NonNull IProject project, boolean validate) {
        super(repository);
        AndroidTargetData targetData;
        this.mProject = project;
        this.mValidate = validate;
        Sdk sdk = Sdk.getCurrent();
        if (sdk != null && (targetData = sdk.getTargetData(project)) != null) {
            this.mAttributeMap = targetData.getAttributeMap();
            this.mFrameworkResources = targetData.getFrameworkResources();
        }
    }

    public void addError(@NonNull String error) {
        super.addError(error);
        if (this.mErrors == null) {
            this.mErrors = new ArrayList<Pair<IResource, String>>();
        }
        this.mErrors.add((Pair<IResource, String>)Pair.of((Object)this.mCurrentFile, (Object)error));
    }

    public void startScanning(@NonNull IResource resource) {
        assert (this.mCurrentFile == null) : this.mCurrentFile;
        this.mCurrentFile = resource;
        this.mScannedResources.add(resource);
    }

    public void finishScanning(@NonNull IResource resource) {
        assert (this.mCurrentFile != null);
        this.mCurrentFile = null;
    }

    public void updateMarkers(boolean async) {
        if (async) {
            AdtPlugin.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IdeScanningContext.this.updateMarkers(false);
                }
            });
            return;
        }
        for (IResource resource : this.mScannedResources) {
            try {
                if (!resource.exists()) continue;
                int depth = resource instanceof IFolder ? 1 : 0;
                resource.deleteMarkers("com.android.ide.eclipse.common.aaptProblem", true, depth);
            }
            catch (CoreException coreException) {}
        }
        if (this.mErrors != null && this.mErrors.size() > 0) {
            ArrayList<String> errors = new ArrayList<String>();
            for (Pair<IResource, String> pair : this.mErrors) {
                errors.add((String)pair.getSecond());
            }
            AaptParser.parseOutput(errors, this.mProject);
        }
    }

    public boolean needsFullAapt() {
        return super.needsFullAapt() || this.hasModifiedFilesWithErrors();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasModifiedFilesWithErrors() {
        for (IResource resource : this.mScannedResources) {
            try {
                IMarker[] markers;
                int depth;
                int n = depth = resource instanceof IFolder ? 1 : 0;
                if (!resource.exists()) continue;
                IMarker[] iMarkerArray = markers = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, depth);
                int n2 = markers.length;
                int n3 = 0;
                while (n3 < n2) {
                    IMarker marker = iMarkerArray[n3];
                    if (marker.getAttribute("severity", 0) == 2) {
                        return true;
                    }
                    ++n3;
                }
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    protected void requestFullAapt() {
        super.requestFullAapt();
        if (this.mCurrentFile != null) {
            if (this.mFullAaptProjects == null) {
                this.mFullAaptProjects = new HashSet<IProject>();
            }
            this.mFullAaptProjects.add(this.mCurrentFile.getProject());
        } else assert (false) : "No current context to apply IdeScanningContext to";
    }

    public Collection<IProject> getAaptRequestedProjects() {
        return this.mFullAaptProjects;
    }

    public boolean checkValue(@Nullable String uri, @NonNull String name, @NonNull String value) {
        AttributeInfo info;
        if (!this.mValidate) {
            return true;
        }
        if (!this.needsFullAapt() && this.mAttributeMap != null && "http://schemas.android.com/apk/res/android".equals(uri) && (info = this.mAttributeMap.get(name)) != null && !info.isValid(value, this.mRepository, this.mFrameworkResources)) {
            return false;
        }
        return super.checkValue(uri, name, value);
    }
}

