/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.welcome;

import com.android.SdkConstants;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.LayoutWindowCoordinator;
import com.android.ide.eclipse.adt.internal.preferences.AdtPrefs;
import com.android.ide.eclipse.adt.internal.welcome.WelcomeWizard;
import com.android.ide.eclipse.base.InstallDetails;
import com.android.sdkstats.DdmsPreferenceStore;
import com.android.sdkstats.SdkStatsService;
import com.android.utils.GrabProcessOutput;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Version;

public class AdtStartup
implements IStartup,
IWindowListener {
    private DdmsPreferenceStore mStore = new DdmsPreferenceStore();

    public void earlyStartup() {
        boolean showOptInDialogPage;
        File bundledSdk;
        if (!this.isSdkSpecified() && (bundledSdk = this.getBundledSdk()) != null) {
            AdtPrefs.getPrefs().setSdkLocation(bundledSdk);
        }
        boolean showSdkInstallationPage = !this.isSdkSpecified() && this.isFirstTime();
        boolean bl = showOptInDialogPage = !this.mStore.hasPingId();
        if (showSdkInstallationPage || showOptInDialogPage) {
            this.showWelcomeWizard(showSdkInstallationPage, showOptInDialogPage);
        }
        if (this.mStore.isPingOptIn()) {
            this.sendUsageStats();
        }
        this.initializeWindowCoordinator();
        AdtPlugin.getDefault().workbenchStarted();
    }

    private boolean isSdkSpecified() {
        String osSdkFolder = AdtPrefs.getPrefs().getOsSdkFolder();
        return osSdkFolder != null && !osSdkFolder.isEmpty();
    }

    private File getBundledSdk() {
        File sdkFolder;
        File toolsFolder;
        Location install = Platform.getInstallLocation();
        if (install != null && install.getURL() != null && (toolsFolder = new File(install.getURL().getFile()).getParentFile()) != null && (sdkFolder = new File(toolsFolder, "sdk")).exists() && AdtPlugin.getDefault().checkSdkLocationAndId(sdkFolder.getAbsolutePath(), new SdkValidator())) {
            return sdkFolder;
        }
        return null;
    }

    private boolean isFirstTime() {
        int i = 0;
        while (i < 2) {
            String osSdkPath = null;
            if (i == 0) {
                osSdkPath = this.mStore.getLastSdkPath();
            } else if (i == 1) {
                osSdkPath = this.getSdkPathFromWindowsRegistry();
            }
            if (osSdkPath != null && osSdkPath.length() > 0) {
                boolean ok = new File(osSdkPath).isDirectory();
                if (!ok) {
                    osSdkPath = osSdkPath.trim();
                    ok = new File(osSdkPath).isDirectory();
                }
                if (ok && (ok = AdtPlugin.getDefault().checkSdkLocationAndId(osSdkPath, new SdkValidator()))) {
                    AdtPrefs.getPrefs().setSdkLocation(new File(osSdkPath));
                    return false;
                }
            }
            ++i;
        }
        return !this.mStore.isAdtUsed();
    }

    private String getSdkPathFromWindowsRegistry() {
        if (SdkConstants.CURRENT_PLATFORM != 2) {
            return null;
        }
        final AtomicReference result = new AtomicReference();
        final Pattern regexp = Pattern.compile("^\\s+Path\\s+REG_SZ\\s+(.*)$");
        String[] stringArray = new String[]{"HKLM\\Software\\Android SDK Tools", "HKLM\\Software\\Wow6432Node\\Android SDK Tools"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String[] command = new String[]{"reg", "query", key, "/v", "Path"};
            try {
                Process process = Runtime.getRuntime().exec(command);
                GrabProcessOutput.grabProcessOutput((Process)process, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.WAIT_FOR_READERS, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(){

                    public void out(@Nullable String line) {
                        Matcher m;
                        if (line != null && (m = regexp.matcher(line)).matches()) {
                            result.set(m.group(1));
                        }
                    }

                    public void err(@Nullable String line) {
                    }
                });
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
            String str = (String)result.get();
            if (str != null) {
                if (new File(str).isDirectory()) {
                    return str;
                }
                if (new File(str = str.trim()).isDirectory()) {
                    return str;
                }
            }
            ++n2;
        }
        return null;
    }

    private void initializeWindowCoordinator() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.addWindowListener((IWindowListener)this);
        workbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
                int n = iWorkbenchWindowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    LayoutWindowCoordinator.get(window, true);
                    ++n2;
                }
            }
        });
    }

    private void showWelcomeWizard(final boolean showSdkInstallPage, final boolean showUsageOptInPage) {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window != null) {
                    WelcomeWizard wizard = new WelcomeWizard(AdtStartup.this.mStore, showSdkInstallPage, showUsageOptInPage);
                    WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard);
                    dialog.open();
                }
                AdtStartup.this.mStore.setAdtUsed(true);
                if (AdtStartup.this.mStore.isPingOptIn()) {
                    AdtStartup.this.sendUsageStats();
                }
            }
        });
    }

    private void sendUsageStats() {
        Job pingJob = this.createPingUsageServerJob();
        pingJob.setPriority(40);
        pingJob.schedule(30000L);
    }

    private Job createPingUsageServerJob() {
        Job job = new Job("Android SDK Ping"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    AdtStartup.this.pingUsageServer();
                    return Status.OK_STATUS;
                }
                catch (Throwable t) {
                    AdtPlugin.log(t, "pingUsageServer failed", new Object[0]);
                    return new Status(4, "com.android.ide.eclipse.adt", "pingUsageServer failed", t);
                }
            }
        };
        return job;
    }

    private static Version getVersion(Plugin plugin) {
        String version = (String)plugin.getBundle().getHeaders().get("Bundle-Version");
        return new Version(version);
    }

    private void pingUsageServer() {
        Version version = AdtStartup.getVersion((Plugin)AdtPlugin.getDefault());
        String adtVersionString = String.format("%1$d.%2$d.%3$d", version.getMajor(), version.getMinor(), version.getMicro());
        Version eclipseVersion = InstallDetails.getPlatformVersion();
        String eclipseVersionString = String.format("%1$d.%2$d", eclipseVersion.getMajor(), eclipseVersion.getMinor());
        SdkStatsService stats = new SdkStatsService();
        stats.ping("adt", adtVersionString);
        stats.ping("eclipse", eclipseVersionString);
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        LayoutWindowCoordinator listener = LayoutWindowCoordinator.get(window, false);
        if (listener != null) {
            listener.dispose();
        }
    }

    public void windowOpened(IWorkbenchWindow window) {
        LayoutWindowCoordinator.get(window, true);
    }

    private static class SdkValidator
    extends AdtPlugin.CheckSdkErrorHandler {
        private SdkValidator() {
        }

        @Override
        public boolean handleError(AdtPlugin.CheckSdkErrorHandler.Solution solution, String message) {
            return false;
        }

        @Override
        public boolean handleWarning(AdtPlugin.CheckSdkErrorHandler.Solution solution, String message) {
            return true;
        }
    }
}

