/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.templates;

import java.io.File;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TemplateTestPage
extends WizardPage
implements SelectionListener,
ModifyListener {
    private Text mLocation;
    private Button mButton;
    private static String sLocation;
    private Button mProjectToggle;
    private File mTemplate;

    TemplateTestPage() {
        super("testWizardPage");
        this.setTitle("Wizard Tester");
        this.setDescription("Test a new template");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(container, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label.setText("Template Location:");
        this.mLocation = new Text(container, 2048);
        GridData gd_mLocation = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_mLocation.widthHint = 400;
        this.mLocation.setLayoutData((Object)gd_mLocation);
        if (sLocation != null) {
            this.mLocation.setText(sLocation);
        }
        this.mLocation.addModifyListener((ModifyListener)this);
        this.mButton = new Button(container, 0x800000);
        this.mButton.setText("...");
        this.mProjectToggle = new Button(container, 32);
        this.mProjectToggle.setEnabled(false);
        this.mProjectToggle.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.mProjectToggle.setText("Full project template");
        new Label(container, 0);
        this.mButton.addSelectionListener((SelectionListener)this);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.validatePage();
    }

    private boolean validatePage() {
        String error = null;
        String path = this.mLocation.getText().trim();
        if (path == null || path.length() == 0) {
            error = "Select a template directory";
            this.mTemplate = null;
        } else {
            this.mTemplate = new File(path);
            if (!this.mTemplate.exists()) {
                error = String.format("%1$s does not exist", path);
            } else {
                sLocation = path;
                if (this.mTemplate.isDirectory()) {
                    if (!new File(this.mTemplate, "template.xml").exists()) {
                        error = String.format("Not a template: missing template.xml file in %1$s ", path);
                    }
                } else if (this.mTemplate.getName().equals("template.xml")) {
                    this.mTemplate = this.mTemplate.getParentFile();
                } else {
                    error = String.format("Select a directory containing a template", new Object[0]);
                }
            }
        }
        this.setPageComplete(error == null);
        if (error != null) {
            this.setMessage(error, 3);
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
        }
        return error == null;
    }

    public void modifyText(ModifyEvent e) {
        this.validatePage();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.mButton) {
            String file;
            DirectoryDialog dialog = new DirectoryDialog(this.mButton.getShell(), 4096);
            String path = this.mLocation.getText().trim();
            if (path.length() > 0) {
                dialog.setFilterPath(path);
            }
            if ((file = dialog.open()) != null) {
                this.mLocation.setText(file);
            }
        }
        this.validatePage();
    }

    File getLocation() {
        return this.mTemplate;
    }

    boolean isProjectTemplate() {
        return this.mProjectToggle.getSelection();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

