/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.codan.internal.core.model.CodanProblemMarker;
import org.eclipse.cdt.codan.internal.ui.CodanUIActivator;
import org.eclipse.cdt.codan.ui.ICodanMarkerResolution;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;

public class CodanProblemMarkerResolutionGenerator
implements IMarkerResolutionGenerator {
    private static final String EXTENSION_POINT_NAME = "codanMarkerResolution";
    private static Map<String, Collection<ConditionalResolution>> resolutions = new HashMap<String, Collection<ConditionalResolution>>();
    private static boolean resolutionsLoaded = false;

    public IMarkerResolution[] getResolutions(IMarker marker) {
        String id;
        if (!resolutionsLoaded) {
            CodanProblemMarkerResolutionGenerator.readExtensions();
        }
        if ((id = marker.getAttribute("id", null)) == null && resolutions.get(null) == null) {
            return new IMarkerResolution[0];
        }
        String message = marker.getAttribute("message", "");
        Collection<ConditionalResolution> collection = resolutions.get(id);
        if (collection != null) {
            ArrayList<IMarkerResolution> list = new ArrayList<IMarkerResolution>();
            for (ConditionalResolution res : collection) {
                block8: {
                    if (res.messagePattern != null) {
                        try {
                            Pattern pattern = Pattern.compile(res.messagePattern);
                            Matcher matcher = pattern.matcher(message);
                            if (!matcher.matches()) continue;
                            if (id != null) break block8;
                            this.setArgumentsFromPattern(matcher, marker);
                        }
                        catch (Exception exception) {
                            CodanUIActivator.log("Cannot compile regex: " + res.messagePattern);
                            continue;
                        }
                    }
                }
                if (res.res instanceof ICodanMarkerResolution && !((ICodanMarkerResolution)res.res).isApplicable(marker)) continue;
                list.add(res.res);
            }
            if (list.size() > 0) {
                return list.toArray(new IMarkerResolution[list.size()]);
            }
        }
        return new IMarkerResolution[0];
    }

    private void setArgumentsFromPattern(Matcher matcher, IMarker marker) {
        int n = matcher.groupCount();
        if (n == 0) {
            return;
        }
        Object[] res = new String[n];
        int i = 0;
        while (i < n) {
            res[i] = matcher.group(i + 1);
            ++i;
        }
        Object[] old = CodanProblemMarker.getProblemArguments((IMarker)marker);
        if (!Arrays.deepEquals(res, old)) {
            try {
                CodanProblemMarker.setProblemArguments((IMarker)marker, (String[])res);
            }
            catch (CoreException e) {
                CodanUIActivator.log(e);
            }
        }
    }

    private static synchronized void readExtensions() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.codan.ui", EXTENSION_POINT_NAME);
        if (ep == null) {
            return;
        }
        try {
            IConfigurationElement[] elements = ep.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement configurationElement = elements[i];
                CodanProblemMarkerResolutionGenerator.processResolution(configurationElement);
                ++i;
            }
        }
        finally {
            resolutionsLoaded = true;
        }
    }

    private static void processResolution(IConfigurationElement configurationElement) {
        if (configurationElement.getName().equals("resolution")) {
            IMarkerResolution res;
            String id = configurationElement.getAttribute("problemId");
            String messagePattern = configurationElement.getAttribute("messagePattern");
            if (id == null && messagePattern == null) {
                CodanUIActivator.log("Extension for codanMarkerResolution problemId is not defined");
                return;
            }
            try {
                res = (IMarkerResolution)configurationElement.createExecutableExtension("class");
            }
            catch (CoreException e) {
                CodanUIActivator.log(e);
                return;
            }
            if (messagePattern != null) {
                try {
                    Pattern.compile(messagePattern);
                }
                catch (Exception e) {
                    CodanUIActivator.log("Extension for codanMarkerResolution messagePattern is invalid: " + e.getMessage());
                    return;
                }
            }
            ConditionalResolution co = new ConditionalResolution(res, messagePattern);
            CodanProblemMarkerResolutionGenerator.addResolution(id, co);
        }
    }

    public static void addResolution(String id, IMarkerResolution res, String messagePattern) {
        CodanProblemMarkerResolutionGenerator.addResolution(id, new ConditionalResolution(res, messagePattern));
    }

    private static void addResolution(String id, ConditionalResolution res) {
        Collection<ConditionalResolution> collection = resolutions.get(id);
        if (collection == null) {
            collection = new ArrayList<ConditionalResolution>();
            resolutions.put(id, collection);
        }
        collection.add(res);
    }

    static class ConditionalResolution {
        IMarkerResolution res;
        String messagePattern;

        public ConditionalResolution(IMarkerResolution res2, String messagePattern2) {
            this.res = res2;
            this.messagePattern = messagePattern2;
        }
    }
}

