/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.dialogfields;

import org.eclipse.cdt.debug.internal.ui.dialogfields.IStringButtonAdapter;
import org.eclipse.cdt.debug.internal.ui.dialogfields.StringButtonDialogField;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class StringButtonStatusDialogField
extends StringButtonDialogField {
    private Label fStatusLabelControl;
    private Object fStatus = null;
    private String fWidthHintString = null;
    private int fWidthHint = -1;

    public StringButtonStatusDialogField(IStringButtonAdapter adapter) {
        super(adapter);
    }

    public void setStatus(String status) {
        if (this.isOkToUse((Control)this.fStatusLabelControl)) {
            this.fStatusLabelControl.setText(status);
        }
        this.fStatus = status;
    }

    public void setStatus(Image image) {
        if (this.isOkToUse((Control)this.fStatusLabelControl)) {
            if (image == null) {
                this.fStatusLabelControl.setImage(null);
            } else {
                this.fStatusLabelControl.setImage(image);
            }
        }
        this.fStatus = image;
    }

    public void setStatusWidthHint(String widthHintString) {
        this.fWidthHintString = widthHintString;
        this.fWidthHint = -1;
    }

    public void setStatusWidthHint(int widthHint) {
        this.fWidthHint = widthHint;
        this.fWidthHintString = null;
    }

    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)StringButtonStatusDialogField.gridDataForLabel(1));
        Text text = this.getTextControl(parent);
        text.setLayoutData((Object)StringButtonStatusDialogField.gridDataForText(nColumns - 3));
        Label status = this.getStatusLabelControl(parent);
        status.setLayoutData((Object)this.gridDataForStatusLabel((Control)parent, 1));
        Button button = this.getChangeControl(parent);
        button.setLayoutData((Object)StringButtonStatusDialogField.gridDataForButton(button, 1));
        return new Control[]{label, text, status, button};
    }

    public int getNumberOfControls() {
        return 4;
    }

    protected GridData gridDataForStatusLabel(Control aControl, int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalIndent = 0;
        if (this.fWidthHintString != null) {
            GC gc = new GC((Drawable)aControl);
            gd.widthHint = gc.textExtent((String)this.fWidthHintString).x;
            gc.dispose();
        } else {
            gd.widthHint = this.fWidthHint != -1 ? this.fWidthHint : -1;
        }
        return gd;
    }

    public Label getStatusLabelControl(Composite parent) {
        if (this.fStatusLabelControl == null) {
            this.assertCompositeNotNull(parent);
            this.fStatusLabelControl = new Label(parent, 16384);
            this.fStatusLabelControl.setFont(parent.getFont());
            this.fStatusLabelControl.setEnabled(this.isEnabled());
            if (this.fStatus instanceof Image) {
                this.fStatusLabelControl.setImage((Image)this.fStatus);
            } else if (this.fStatus instanceof String) {
                this.fStatusLabelControl.setText((String)this.fStatus);
            }
        }
        return this.fStatusLabelControl;
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fStatusLabelControl)) {
            this.fStatusLabelControl.setEnabled(this.isEnabled());
        }
    }
}

