/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTFunctionStyleMacroParameter;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorFunctionStyleMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfdefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfndefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.ISemanticProblem;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICCompositeTypeScope;
import org.eclipse.cdt.core.dom.ast.c.ICFunctionPrototypeScope;
import org.eclipse.cdt.core.dom.ast.c.ICFunctionScope;
import org.eclipse.cdt.core.dom.ast.c.ICScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.refactoring.rename.ASTSpecificNameVisitor;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRefactoringArgument;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRefactoringMatch;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRefactoringMatchStore;
import org.eclipse.cdt.internal.ui.refactoring.rename.RenameMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.services.IDisposable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTManager
implements IDisposable {
    private static final int PARSE_MODE = 230;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int UNKNOWN = -1;
    private IASTTranslationUnit fSharedAST;
    private Map<IFile, IASTTranslationUnit> fTranslationUnits = new HashMap<IFile, IASTTranslationUnit>();
    private HashSet<String> fProblemUnits = new HashSet();
    private CRefactoringArgument fArgument;
    private IBinding[] fValidBindings;
    private String fRenameTo;
    private HashMap<IBinding, Integer> fKnownBindings;
    private HashSet<IBinding> fConflictingBinding;
    private boolean fDisposed;

    public static String nth_of_m(int n, int m) {
        StringBuilder nofm = new StringBuilder();
        ASTManager.append_nth_of_m(n, m, nofm);
        return nofm.toString();
    }

    static void append_nth_of_m(int n, int m, StringBuilder buf) {
        buf.append(n);
        switch (n) {
            case 1: {
                buf.append("st");
                break;
            }
            case 2: {
                buf.append("nd");
                break;
            }
            case 3: {
                buf.append("rd");
                break;
            }
            default: {
                buf.append("th");
            }
        }
        buf.append(" of ");
        buf.append(m);
    }

    public static IASTFileLocation getLocationInTranslationUnit(IASTNode node) {
        return node.getFileLocation();
    }

    public static IASTName getSimpleName(IASTName name) {
        IASTName[] names;
        if (name instanceof ICPPASTQualifiedName && (names = ((ICPPASTQualifiedName)name).getNames()).length > 0) {
            name = names[names.length - 1];
        }
        return name;
    }

    public static int isSameBinding(IIndex index, IBinding b1, IBinding b2) throws DOMException {
        if (b1 == null || b2 == null) {
            return -1;
        }
        if (b1.equals(b2)) {
            return 1;
        }
        if ((b1 instanceof IIndexBinding || b2 instanceof IIndexBinding) && index != null) {
            IIndexBinding b21;
            IIndexBinding b11 = index.adaptBinding(b1);
            if (b11 != null) {
                b1 = b11;
            }
            if ((b21 = index.adaptBinding(b2)) != null) {
                b2 = b21;
            }
            if (b1.equals(b2)) {
                return 1;
            }
        }
        String n1 = b1.getName();
        String n2 = b2.getName();
        if (n1 == null || n2 == null) {
            return -1;
        }
        if (!n1.equals(n2)) {
            return 0;
        }
        if (b1 instanceof ICompositeType) {
            IScope s2;
            if (!(b2 instanceof ICompositeType)) {
                return 0;
            }
            ICompositeType c1 = (ICompositeType)b1;
            ICompositeType c2 = (ICompositeType)b2;
            if (c1.getKey() != c2.getKey()) {
                return 0;
            }
            IScope s1 = c1.getCompositeScope();
            if (s1 != null) {
                s1 = s1.getParent();
            }
            if ((s2 = c2.getCompositeScope()) != null) {
                s2 = s2.getParent();
            }
            return ASTManager.isSameScope(s1, s2, false);
        }
        if (b1 instanceof IFunction) {
            int r2;
            int r1;
            if (!(b2 instanceof IFunction)) {
                return 0;
            }
            boolean isStatic = false;
            boolean checkSig = true;
            IFunction c1 = (IFunction)b1;
            IFunction c2 = (IFunction)b2;
            if (b1 instanceof ICPPMethod) {
                if (!(b2 instanceof ICPPMethod)) {
                    return 0;
                }
            } else {
                if (b2 instanceof ICPPMethod) {
                    return 0;
                }
                boolean bl = isStatic = c1.isStatic() || c2.isStatic();
                if (!(b1 instanceof ICPPFunction) && !(b2 instanceof ICPPFunction)) {
                    checkSig = false;
                }
            }
            if ((r1 = ASTManager.isSameScope(b1.getScope(), b2.getScope(), isStatic)) == 0) {
                return 0;
            }
            int n = r2 = checkSig ? ASTManager.hasSameSignature(c1, c2) : 1;
            if (r2 == 0) {
                return 0;
            }
            if (r1 != r2) {
                return -1;
            }
            return r1;
        }
        if (b1 instanceof IVariable) {
            int result;
            boolean fileStatic = false;
            if (!(b2 instanceof IVariable)) {
                return 0;
            }
            IVariable c1 = (IVariable)b1;
            IVariable c2 = (IVariable)b2;
            if (b1 instanceof IField) {
                if (!(b2 instanceof IField)) {
                    return 0;
                }
            } else if (b1 instanceof IParameter) {
                if (!(b2 instanceof IParameter)) {
                    return 0;
                }
            } else {
                if (b2 instanceof IField || b2 instanceof IParameter) {
                    return 0;
                }
                fileStatic = c1.isStatic() || c2.isStatic();
            }
            return (result = ASTManager.isSameScope(c1.getScope(), c2.getScope(), fileStatic)) == -1 ? 1 : result;
        }
        if (b1 instanceof IEnumerator) {
            if (!(b2 instanceof IEnumerator)) {
                return 0;
            }
            return ASTManager.isSameScope(b1.getScope(), b2.getScope(), false);
        }
        if (b1 instanceof ITypedef) {
            if (!(b2 instanceof ITypedef)) {
                return 0;
            }
            return ASTManager.isSameScope(b1.getScope(), b2.getScope(), false);
        }
        if (b1 instanceof IMacroBinding) {
            if (!(b2 instanceof IMacroBinding)) {
                return 0;
            }
            return 1;
        }
        if (b1 instanceof IEnumeration) {
            if (!(b2 instanceof IEnumeration)) {
                return 0;
            }
            return ASTManager.isSameScope(b1.getScope(), b2.getScope(), false);
        }
        int scopeCmp = ASTManager.isSameScope(b1.getScope(), b2.getScope(), false);
        if (scopeCmp != 1) {
            return scopeCmp;
        }
        if (b1.getClass().equals(b2.getClass())) {
            return 1;
        }
        return -1;
    }

    public static int isSameScope(IScope s1, IScope s2, boolean fileStatic) throws DOMException {
        if (s1 == s2) {
            return 1;
        }
        IASTNode node1 = ASTInternal.getPhysicalNodeOfScope((IScope)s1);
        IASTNode node2 = ASTInternal.getPhysicalNodeOfScope((IScope)s2);
        if (s1 == null) {
            if (!fileStatic && node2 instanceof IASTTranslationUnit) {
                return 1;
            }
            return -1;
        }
        if (s2 == null) {
            if (!fileStatic && node1 instanceof IASTTranslationUnit) {
                return 1;
            }
            return -1;
        }
        if (s1.equals(s2)) {
            return 1;
        }
        if (node1 instanceof IASTTranslationUnit && node2 instanceof IASTTranslationUnit) {
            return ASTManager.hasSameLocation(node1, node2, fileStatic);
        }
        String name1 = ASTManager.getName(s1);
        String name2 = ASTManager.getName(s2);
        if (s1 instanceof ICPPBlockScope) {
            if (s2 instanceof ICPPBlockScope) {
                return ASTManager.hasSameLocation(node1, node2, fileStatic);
            }
            return 0;
        }
        if (s1 instanceof ICPPNamespaceScope) {
            if (s2 instanceof ICPPNamespaceScope) {
                ICPPNamespaceScope n1 = (ICPPNamespaceScope)s1;
                ICPPNamespaceScope n2 = (ICPPNamespaceScope)s2;
                int r1 = ASTManager.hasSameLocation(node1, node2, fileStatic);
                if (r1 == 1) {
                    return r1;
                }
                if (!name1.equals(name2)) {
                    return 0;
                }
                return ASTManager.isSameScope(n1.getParent(), n2.getParent(), fileStatic);
            }
            return 0;
        }
        if (!name1.equals(name2)) {
            return 0;
        }
        if (s1 instanceof ICPPClassScope || s1 instanceof ICCompositeTypeScope) {
            if (s2 instanceof ICPPClassScope || s2 instanceof ICCompositeTypeScope) {
                return ASTManager.isSameScope(s1.getParent(), s2.getParent(), fileStatic);
            }
            return 0;
        }
        if (s1 instanceof ICPPFunctionScope) {
            if (s2 instanceof ICPPFunctionScope) {
                return ASTManager.hasSameLocation(node1, node2, true);
            }
            return 0;
        }
        if (s1 instanceof ICFunctionScope || s1 instanceof ICFunctionPrototypeScope || s1 instanceof ICScope) {
            if (s2 instanceof ICFunctionScope || s2 instanceof ICFunctionPrototypeScope || s2 instanceof ICScope) {
                return ASTManager.hasSameLocation(node1, node2, true);
            }
            return 0;
        }
        return ASTManager.isSameScope(s1.getParent(), s2.getParent(), fileStatic);
    }

    public static String getName(IScope s1) {
        String name = null;
        if (s1 instanceof IIndexScope) {
            IIndexScope indexScope = (IIndexScope)s1;
            IIndexName scopeName = indexScope.getScopeName();
            if (scopeName != null) {
                name = scopeName.toString();
            }
        } else {
            name = ASTManager.getNameOrNull(ASTInternal.getPhysicalNodeOfScope((IScope)s1));
        }
        return name == null ? s1.toString() : name;
    }

    public static int hasSameSignature(IFunction b1, IFunction b2) throws DOMException {
        if (b1.takesVarArgs() != b2.takesVarArgs()) {
            return 0;
        }
        if (b1 instanceof ICPPMethod != b2 instanceof ICPPMethod) {
            return 0;
        }
        return ASTManager.hasSameSignature(b1.getType(), b2.getType());
    }

    public static int hasSameSignature(IFunctionType b1, IFunctionType b2) throws DOMException {
        if (b1 instanceof ICPPFunctionType && b2 instanceof ICPPFunctionType) {
            ICPPFunctionType cppb1 = (ICPPFunctionType)b1;
            ICPPFunctionType cppb2 = (ICPPFunctionType)b2;
            if (cppb1.isConst() != cppb2.isConst()) {
                return 0;
            }
            if (cppb1.isVolatile() != cppb2.isVolatile()) {
                return 0;
            }
        }
        return ASTManager.isSameParameterList(b1.getParameterTypes(), b2.getParameterTypes());
    }

    private static int isSameParameterList(IType[] p1, IType[] p2) throws DOMException {
        if (p1 == p2) {
            return 1;
        }
        if (p1 == null || p2 == null) {
            return -1;
        }
        if (p1.length != p2.length) {
            return 0;
        }
        int retval = 1;
        int i = 0;
        while (i < p2.length) {
            switch (ASTManager.isSameType(p1[i], p2[i])) {
                case 0: {
                    return 0;
                }
                case -1: {
                    retval = -1;
                }
            }
            ++i;
        }
        return retval;
    }

    private static int isSameType(IType t1, IType t2) throws DOMException {
        if (t1 != null && t2 != null && t1.isSameType(t2)) {
            return 1;
        }
        if ((t1 = ASTManager.getRealType(t1)) == (t2 = ASTManager.getRealType(t2))) {
            return 1;
        }
        if (t1 == null || t2 == null || t1 instanceof ISemanticProblem || t2 instanceof ISemanticProblem) {
            return -1;
        }
        if (t1 instanceof IArrayType) {
            if (t2 instanceof IArrayType) {
                IArrayType a1 = (IArrayType)t1;
                IArrayType a2 = (IArrayType)t2;
                return ASTManager.isSameType(a1.getType(), a2.getType());
            }
            return 0;
        }
        if (t1 instanceof IBasicType) {
            if (t2 instanceof IBasicType) {
                IBasicType a1 = (IBasicType)t1;
                IBasicType a2 = (IBasicType)t2;
                if (a1.getKind() != a2.getKind()) {
                    return 0;
                }
                if (ASTManager.getSigned(a1) != ASTManager.getSigned(a2) || a1.isUnsigned() != a2.isUnsigned()) {
                    return 0;
                }
                if (a1.isLong() != a2.isLong() || a1.isShort() != a2.isShort()) {
                    return 0;
                }
                return 1;
            }
            return 0;
        }
        if (t1 instanceof ICompositeType) {
            if (t2 instanceof ICompositeType) {
                ICompositeType a1 = (ICompositeType)t1;
                ICompositeType a2 = (ICompositeType)t2;
                if (a1.getKey() != a2.getKey()) {
                    return 0;
                }
                return ASTManager.isSameScope(a1.getCompositeScope(), a2.getCompositeScope(), false);
            }
            return 0;
        }
        if (t1 instanceof ICPPReferenceType) {
            if (t2 instanceof ICPPReferenceType) {
                ICPPReferenceType a1 = (ICPPReferenceType)t1;
                ICPPReferenceType a2 = (ICPPReferenceType)t2;
                return ASTManager.isSameType(a1.getType(), a2.getType());
            }
            return 0;
        }
        if (t1 instanceof ICPPTemplateTypeParameter) {
            if (t2 instanceof ICPPTemplateTypeParameter) {
                return 1;
            }
            return 0;
        }
        if (t1 instanceof IEnumeration) {
            if (t2 instanceof IEnumeration) {
                IEnumeration a1 = (IEnumeration)t1;
                IEnumeration a2 = (IEnumeration)t2;
                return ASTManager.isSameScope(a1.getScope(), a2.getScope(), false);
            }
            return 0;
        }
        if (t1 instanceof IFunctionType) {
            if (t2 instanceof IFunctionType) {
                IFunctionType a1 = (IFunctionType)t1;
                IFunctionType a2 = (IFunctionType)t2;
                return ASTManager.hasSameSignature(a1, a2);
            }
            return 0;
        }
        if (t1 instanceof IPointerType) {
            if (t2 instanceof IPointerType) {
                IPointerType a1 = (IPointerType)t1;
                IPointerType a2 = (IPointerType)t2;
                if (a1.isConst() != a2.isConst() || a1.isVolatile() != a2.isVolatile() || a1.isRestrict() != a2.isRestrict()) {
                    return 0;
                }
                return ASTManager.isSameType(a1.getType(), a2.getType());
            }
            return 0;
        }
        if (t1 instanceof IQualifierType) {
            if (t2 instanceof IQualifierType) {
                IQualifierType a1 = (IQualifierType)t1;
                IQualifierType a2 = (IQualifierType)t2;
                if (a1.isConst() != a2.isConst() || a1.isVolatile() != a2.isVolatile()) {
                    return 0;
                }
                return ASTManager.isSameType(a1.getType(), a2.getType());
            }
            return 0;
        }
        return -1;
    }

    private static boolean getSigned(IBasicType a2) {
        if (a2.isSigned()) {
            return true;
        }
        if (a2.isUnsigned()) {
            return false;
        }
        switch (a2.getKind()) {
            case eUnspecified: 
            case eInt: {
                return true;
            }
        }
        return false;
    }

    private static IType getRealType(IType t) {
        while (t instanceof ITypedef) {
            t = ((ITypedef)t).getType();
        }
        return t;
    }

    private static String getNameOrNull(IASTNode node) {
        if (node instanceof IASTDeclarator) {
            return ASTManager.getSimpleName(((IASTDeclarator)node).getName()).toString();
        }
        if (node instanceof IASTNamedTypeSpecifier) {
            return ASTManager.getSimpleName(((IASTNamedTypeSpecifier)node).getName()).toString();
        }
        if (node instanceof IASTCompositeTypeSpecifier) {
            return ASTManager.getSimpleName(((IASTCompositeTypeSpecifier)node).getName()).toString();
        }
        if (node instanceof ICPPASTNamespaceDefinition) {
            return ASTManager.getSimpleName(((ICPPASTNamespaceDefinition)node).getName()).toString();
        }
        if (node instanceof IASTTranslationUnit) {
            return ((IASTTranslationUnit)node).getFilePath();
        }
        return null;
    }

    private static int hasSameLocation(IASTNode node1, IASTNode node2, boolean fileStatic) {
        if (node1 == null || node2 == null) {
            return -1;
        }
        if (!fileStatic && node1 instanceof IASTTranslationUnit && node2 instanceof IASTTranslationUnit) {
            return 1;
        }
        IASTFileLocation l1 = node1.getNodeLocations()[0].asFileLocation();
        IASTFileLocation l2 = node2.getNodeLocations()[0].asFileLocation();
        if (l1 == null || l2 == null) {
            return -1;
        }
        if (!l1.getFileName().equals(l2.getFileName())) {
            return 0;
        }
        if (l1.getNodeOffset() != l2.getNodeOffset()) {
            return 0;
        }
        if (l1.getNodeLength() != l2.getNodeLength()) {
            return 0;
        }
        return 1;
    }

    private static IScope getContainingScope(IASTName name) {
        IASTTranslationUnit tu = name.getTranslationUnit();
        if (tu == null) {
            return null;
        }
        if (tu instanceof ICPPASTTranslationUnit) {
            return CPPVisitor.getContainingScope((IASTName)name);
        }
        return CVisitor.getContainingScope((IASTNode)name);
    }

    public static int isVirtualMethod(ICPPMethod method) throws DOMException {
        ICPPASTDeclSpecifier cppSpec;
        IASTDeclaration decl = null;
        if (method instanceof CPPMethod) {
            decl = ((CPPMethod)method).getPrimaryDeclaration();
        } else if (method instanceof CPPImplicitMethod) {
            decl = ((CPPImplicitMethod)method).getPrimaryDeclaration();
        }
        IASTDeclSpecifier spec = null;
        if (decl instanceof IASTFunctionDefinition) {
            IASTFunctionDefinition def = (IASTFunctionDefinition)decl;
            spec = def.getDeclSpecifier();
        } else if (decl instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration sdecl = (IASTSimpleDeclaration)decl;
            spec = sdecl.getDeclSpecifier();
        }
        if (spec instanceof ICPPASTDeclSpecifier && (cppSpec = (ICPPASTDeclSpecifier)spec).isVirtual()) {
            return 1;
        }
        IScope scope = method.getScope();
        if (scope instanceof ICPPClassScope) {
            ICPPBase[] bases;
            ICPPClassScope classScope = (ICPPClassScope)scope;
            ICPPClassType classType = classScope.getClassType();
            ICPPBase[] iCPPBaseArray = bases = classType.getBases();
            int n = bases.length;
            int n2 = 0;
            while (n2 < n) {
                IScope baseScope;
                ICPPClassType baseType;
                ICPPBase base = iCPPBaseArray[n2];
                if (base.getBaseClass() instanceof ICPPClassType && (baseType = (ICPPClassType)base.getBaseClass()) != null && (baseScope = baseType.getCompositeScope()) != null) {
                    IBinding[] alternates;
                    IBinding[] iBindingArray = alternates = baseScope.find(method.getName());
                    int n3 = alternates.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        CPPMethod alternateMethod;
                        IBinding binding = iBindingArray[n4];
                        if (binding instanceof CPPMethod && ASTManager.hasSameSignature((IFunction)method, (IFunction)(alternateMethod = (CPPMethod)binding)) != 0 && ASTManager.isVirtualMethod((ICPPMethod)alternateMethod) == 1) {
                            return 1;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isLocalVariable(IVariable v, IScope scope) {
        if (!(v instanceof IParameter)) ** GOTO lbl10
        return false;
lbl-1000:
        // 1 sources

        {
            if (scope instanceof ICPPFunctionScope || scope instanceof ICPPBlockScope || scope instanceof ICFunctionScope) {
                return true;
            }
            try {
                scope = scope.getParent();
                continue;
            }
            catch (DOMException v0) {
                scope = null;
            }
lbl10:
            // 3 sources

            ** while (scope != null)
        }
lbl11:
        // 1 sources

        return false;
    }

    public static boolean isLocalVariable(IVariable v) {
        try {
            return ASTManager.isLocalVariable(v, v.getScope());
        }
        catch (DOMException dOMException) {
            return false;
        }
    }

    public static IBinding[] findInScope(IScope scope, String name, boolean removeGlobalsWhenClassScope) throws DOMException {
        IBinding[] result = null;
        result = scope.find(name);
        if (result == null || result.length == 0) {
            return result;
        }
        if (removeGlobalsWhenClassScope && (scope instanceof ICPPClassScope || scope instanceof ICCompositeTypeScope)) {
            int count = 0;
            int i = 0;
            while (i < result.length) {
                IBinding binding = result[i];
                IScope bscope = binding.getScope();
                if (!(bscope instanceof ICPPClassScope) && !(bscope instanceof ICCompositeTypeScope)) {
                    result[i] = null;
                } else {
                    ++count;
                }
                ++i;
            }
            if (count < result.length) {
                IBinding[] copy = new IBinding[count];
                int i2 = 0;
                IBinding[] iBindingArray = result;
                int n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    IBinding b = iBindingArray[n2];
                    if (b != null) {
                        copy[i2++] = b;
                    }
                    ++n2;
                }
                result = copy;
            }
        }
        if (scope instanceof ICPPBlockScope) {
            int i = 0;
            while (i < result.length) {
                ICPPConstructor[] cons;
                ICPPClassType classType;
                IBinding binding = result[i];
                if (binding instanceof ICPPClassType && (classType = (ICPPClassType)binding).getKey() == 3 && (cons = classType.getConstructors()).length > 0 && !(cons[0] instanceof IProblemBinding)) {
                    result[i] = cons[0];
                }
                ++i;
            }
        }
        return result;
    }

    public ASTManager(CRefactoringArgument arg) {
        this.fArgument = arg;
    }

    public void dispose() {
        Assert.isTrue((!this.fDisposed ? 1 : 0) != 0, (String)"ASTManager.dispose() called more than once");
        this.fDisposed = true;
        if (this.fSharedAST != null) {
            ASTProvider.getASTProvider().releaseSharedAST(this.fSharedAST);
        }
    }

    protected void finalize() throws Throwable {
        if (!this.fDisposed) {
            CUIPlugin.logError("ASTManager was not disposed");
        }
        super.finalize();
    }

    void analyzeArgument(IIndex index, IProgressMonitor pm, RefactoringStatus status) {
        if (this.fArgument == null) {
            return;
        }
        if (this.fArgument.getArgumentKind() != 0) {
            return;
        }
        if (this.fArgument.getSourceFile() == null) {
            return;
        }
        pm.beginTask(RenameMessages.ASTManager_task_analyze, 2);
        IASTTranslationUnit tu = this.getTranslationUnit(index, this.fArgument.getSourceFile(), true, status);
        pm.worked(1);
        if (tu != null) {
            int length;
            int offset;
            IASTNodeSelector nodeSelector = tu.getNodeSelector(tu.getFilePath());
            IASTName name = nodeSelector.findEnclosingName(offset = this.fArgument.getOffset(), length = this.fArgument.getLength());
            if (name != null) {
                if (name instanceof ICPPASTQualifiedName) {
                    IASTName[] na = ((ICPPASTQualifiedName)name).getNames();
                    name = na[na.length - 1];
                }
            } else {
                String ident;
                IASTFileLocation fileLocation;
                IASTNode node = nodeSelector.findEnclosingNode(offset, length);
                if ((node instanceof IASTPreprocessorMacroDefinition || node instanceof IASTPreprocessorElifStatement || node instanceof IASTPreprocessorIfdefStatement || node instanceof IASTPreprocessorIfndefStatement || node instanceof IASTPreprocessorIfStatement) && (fileLocation = node.getFileLocation()) != null && (ident = this.extractIdentifier(node.getRawSignature(), offset - fileLocation.getNodeOffset(), length)) != null) {
                    IASTPreprocessorMacroDefinition[] mdefs;
                    IASTPreprocessorMacroDefinition[] iASTPreprocessorMacroDefinitionArray = mdefs = tu.getMacroDefinitions();
                    int n = mdefs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IASTPreprocessorMacroDefinition mdef = iASTPreprocessorMacroDefinitionArray[n2];
                        IASTName n3 = mdef.getName();
                        if (ident.equals(n3.toString())) {
                            name = n3;
                            break;
                        }
                        ++n2;
                    }
                }
            }
            if (name != null) {
                this.fArgument.setName(name);
                IBinding binding = name.resolveBinding();
                if (binding != null) {
                    IScope scope = null;
                    try {
                        scope = binding.getScope();
                    }
                    catch (DOMException e) {
                        this.handleDOMException(tu, e, status);
                    }
                    this.fArgument.setBinding(name.getTranslationUnit(), binding, scope);
                }
            }
        }
        pm.worked(1);
        pm.done();
    }

    private String extractIdentifier(String rawSignature, int offset, int length) {
        char[] sig = rawSignature.toCharArray();
        int end = offset + length;
        if (offset < 0 || end > sig.length) {
            return null;
        }
        int i = offset;
        while (i < end) {
            if (!Character.isJavaIdentifierPart(sig[i])) {
                return null;
            }
            ++i;
        }
        while (offset > 0) {
            if (!Character.isJavaIdentifierPart(sig[offset - 1])) break;
            --offset;
        }
        while (end < sig.length) {
            if (!Character.isJavaIdentifierPart(sig[end])) break;
            ++end;
        }
        return rawSignature.substring(offset, end);
    }

    private IASTTranslationUnit getTranslationUnit(IIndex index, IFile sourceFile, boolean cacheit, RefactoringStatus status) {
        ICElement celem;
        IASTTranslationUnit ast = this.fTranslationUnits.get(sourceFile);
        if (ast == null && (celem = CoreModel.getDefault().create(sourceFile)) instanceof ITranslationUnit) {
            ITranslationUnit tu = CModelUtil.toWorkingCopy((ITranslationUnit)celem);
            if (this.fSharedAST != null && tu.equals(this.fSharedAST.getOriginatingTranslationUnit())) {
                ast = this.fSharedAST;
            } else {
                ast = ASTProvider.getASTProvider().acquireSharedAST(tu, index, ASTProvider.WAIT_ACTIVE_ONLY, null);
                if (ast == null) {
                    try {
                        ast = tu.getAST(index, 230);
                    }
                    catch (CoreException e) {
                        status.addError(e.getMessage());
                    }
                    if (cacheit) {
                        this.fTranslationUnits.put(sourceFile, ast);
                    }
                } else {
                    if (this.fSharedAST != null) {
                        ASTProvider.getASTProvider().releaseSharedAST(this.fSharedAST);
                    }
                    this.fSharedAST = ast;
                }
            }
        }
        return ast;
    }

    public void analyzeTextMatches(IIndex index, Collection<CRefactoringMatch> matches, IProgressMonitor monitor, RefactoringStatus status) {
        long now;
        CRefactoringMatchStore store = new CRefactoringMatchStore();
        for (CRefactoringMatch match : matches) {
            store.addMatch(match);
        }
        int count = store.getFileCount();
        String taskName = RenameMessages.ASTManager_task_generateAst;
        monitor.beginTask(taskName, 2 * count);
        monitor.setTaskName(taskName);
        List<IFile> files = store.getFileList();
        int cc = 0;
        long update = now = System.currentTimeMillis();
        for (IFile file : files) {
            ++cc;
            if (store.contains((IResource)file)) {
                now = System.currentTimeMillis();
                if (now > update) {
                    String nofm = ASTManager.nth_of_m(cc, count);
                    String taskname = NLS.bind((String)RenameMessages.ASTManager_subtask_analyzing, (Object)nofm);
                    monitor.subTask(taskname);
                    update = now + 1000L;
                }
                boolean doParse = false;
                Collection<CRefactoringMatch> fm = store.getMatchesForFile((IResource)file);
                Iterator<CRefactoringMatch> iterator = fm.iterator();
                while (!doParse && iterator.hasNext()) {
                    CRefactoringMatch match = iterator.next();
                    switch (match.getLocation()) {
                        case 4: 
                        case 8: 
                        case 16: {
                            break;
                        }
                        default: {
                            doParse = true;
                        }
                    }
                }
                if (doParse) {
                    IASTTranslationUnit tu = this.getTranslationUnit(index, file, false, status);
                    monitor.worked(1);
                    this.analyzeTextMatchesOfTranslationUnit(tu, store, status);
                    if (status.hasFatalError()) {
                        return;
                    }
                    monitor.worked(1);
                } else {
                    monitor.worked(2);
                }
                if (!monitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            monitor.worked(2);
        }
        monitor.done();
    }

    private void analyzeTextMatchesOfTranslationUnit(IASTTranslationUnit tu, CRefactoringMatchStore store, RefactoringStatus status) {
        this.fKnownBindings = new HashMap();
        this.fConflictingBinding = new HashSet();
        HashSet<IPath> paths = new HashSet<IPath>();
        boolean renamesMacro = this.fArgument.getArgumentKind() == 11;
        this.analyzeMacroMatches(tu, store, paths, status);
        if (status.hasFatalError()) {
            return;
        }
        if (renamesMacro) {
            this.findConflictingBindingsWithNewName(tu, store, paths, status);
            if (status.hasFatalError()) {
                return;
            }
        }
        this.analyzeLanguageMatches(tu, store, paths, status);
        if (status.hasFatalError()) {
            return;
        }
        for (IPath path : paths) {
            if (path == null) continue;
            store.removePath(path);
        }
        this.handleConflictingBindings(tu, status);
        this.fKnownBindings = null;
        this.fConflictingBinding = null;
    }

    private void analyzeLanguageMatches(IASTTranslationUnit tu, final CRefactoringMatchStore store, final Set<IPath> paths, final RefactoringStatus status) {
        ASTSpecificNameVisitor nv = new ASTSpecificNameVisitor(this.fArgument.getName()){

            protected int visitName(IASTName name, boolean isDestructor) {
                IPath path = ASTManager.this.analyzeAstMatch(name, store, isDestructor, status);
                paths.add(path);
                return 3;
            }
        };
        tu.accept((ASTVisitor)nv);
    }

    private void analyzeMacroMatches(IASTTranslationUnit tu, CRefactoringMatchStore store, Set<IPath> pathsVisited, RefactoringStatus status) {
        IASTPreprocessorMacroDefinition[] mdefs;
        String lookfor = this.fArgument.getName();
        IASTPreprocessorMacroDefinition[] iASTPreprocessorMacroDefinitionArray = mdefs = tu.getMacroDefinitions();
        int n = mdefs.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorMacroDefinition mdef = iASTPreprocessorMacroDefinitionArray[n2];
            IASTName macroName = mdef.getName();
            String macroNameStr = macroName.toString();
            if (this.fRenameTo.equals(macroNameStr)) {
                status.addFatalError(NLS.bind((String)RenameMessages.ASTManager_error_macro_name_conflict, (Object)this.fRenameTo));
                return;
            }
            if (lookfor.equals(macroNameStr)) {
                IPath path = this.analyzeAstMatch(macroName, store, false, status);
                pathsVisited.add(path);
                IBinding macroBinding = macroName.resolveBinding();
                if (macroBinding != null) {
                    IASTName[] refs;
                    IASTName[] iASTNameArray = refs = tu.getReferences(macroBinding);
                    int n3 = refs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IASTName ref = iASTNameArray[n4];
                        path = this.analyzeAstMatch(ref, store, false, status);
                        pathsVisited.add(path);
                        ++n4;
                    }
                }
            }
            if (mdef instanceof IASTPreprocessorFunctionStyleMacroDefinition) {
                boolean nameIsPar = false;
                IASTPreprocessorFunctionStyleMacroDefinition fm = (IASTPreprocessorFunctionStyleMacroDefinition)mdef;
                IASTFunctionStyleMacroParameter[] pars = fm.getParameters();
                if (pars != null) {
                    int j = 0;
                    while (!nameIsPar && j < pars.length) {
                        IASTFunctionStyleMacroParameter par = pars[j];
                        String name = par.getParameter();
                        if (lookfor.equals(name)) {
                            nameIsPar = true;
                        }
                        ++j;
                    }
                    if (nameIsPar) {
                        IASTFileLocation floc = mdef.getNodeLocations()[0].asFileLocation();
                        int offset = floc.getNodeOffset();
                        int end = offset + floc.getNodeLength();
                        Collection<CRefactoringMatch> matches = store.findMatchesInRange(new Path(floc.getFileName()), offset, end);
                        for (CRefactoringMatch match : matches) {
                            match.setASTInformation(2);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private void findConflictingBindingsWithNewName(IASTTranslationUnit tu, CRefactoringMatchStore store, final Set<IPath> paths, final RefactoringStatus status) {
        ASTSpecificNameVisitor nv = new ASTSpecificNameVisitor(this.fRenameTo){

            protected int visitName(IASTName name, boolean isDestructor) {
                IPath path = ASTManager.this.addConflictingBindingForName(status, name);
                paths.add(path);
                return 3;
            }
        };
        tu.accept((ASTVisitor)nv);
    }

    protected IPath addConflictingBindingForName(RefactoringStatus status, IASTName name) {
        IASTNodeLocation loc;
        IASTFileLocation floc;
        IASTNodeLocation[] locations = name.getNodeLocations();
        Path path = null;
        if (locations != null && locations.length == 1 && (floc = (loc = locations[0]).asFileLocation()) != null) {
            path = new Path(floc.getFileName());
            IBinding binding = name.resolveBinding();
            if (binding instanceof IProblemBinding) {
                this.handleProblemBinding(name.getTranslationUnit(), (IProblemBinding)binding, status);
            } else if (binding != null) {
                this.fConflictingBinding.add(binding);
            }
        }
        return path;
    }

    protected IPath analyzeAstMatch(IASTName name, CRefactoringMatchStore store, boolean isDestructor, RefactoringStatus status) {
        Path path = null;
        CRefactoringMatch match = null;
        IASTFileLocation loc = ASTManager.getImageFileLocation(name);
        if (loc != null && (match = store.findMatch((IPath)(path = new Path(loc.getFileName())), loc.getNodeOffset() + (isDestructor ? 1 : 0))) != null) {
            this.analyzeAstTextMatchPair(match, name, status);
        }
        return path;
    }

    static IASTFileLocation getImageFileLocation(IASTName name) {
        return name.getImageLocation();
    }

    private void analyzeAstTextMatchPair(CRefactoringMatch match, IASTName name, RefactoringStatus status) {
        IBinding binding = name.resolveBinding();
        int cmp = 0;
        Integer cmpObj = this.fKnownBindings.get(binding);
        if (cmpObj != null) {
            cmp = cmpObj;
        } else if (binding instanceof IProblemBinding) {
            cmp = -1;
            this.handleProblemBinding(name.getTranslationUnit(), (IProblemBinding)binding, status);
        } else {
            int n;
            boolean problemInQualifier = false;
            IASTNode parent = name.getParent();
            if (parent instanceof ICPPASTQualifiedName) {
                IASTName[] names;
                IASTName[] iASTNameArray = names = ((ICPPASTQualifiedName)parent).getNames();
                n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTName n3 = iASTNameArray[n2];
                    if (n3 == name) break;
                    IBinding b = n3.resolveBinding();
                    if (b instanceof IProblemBinding) {
                        this.handleProblemBinding(name.getTranslationUnit(), (IProblemBinding)b, status);
                        problemInQualifier = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (problemInQualifier) {
                cmp = -1;
            } else {
                IASTTranslationUnit tu = name.getTranslationUnit();
                IIndex index = tu != null ? tu.getIndex() : null;
                IBinding[] iBindingArray = this.fValidBindings;
                int n4 = this.fValidBindings.length;
                n = 0;
                while (n < n4) {
                    IBinding renameBinding = iBindingArray[n];
                    try {
                        int cmp0 = ASTManager.isSameBinding(index, binding, renameBinding);
                        if (cmp0 != 0) {
                            cmp = cmp0;
                        }
                        if (cmp0 == 1) {
                            break;
                        }
                    }
                    catch (DOMException e) {
                        this.handleDOMException(name.getTranslationUnit(), e, status);
                        cmp = -1;
                    }
                    ++n;
                }
            }
            this.fKnownBindings.put(binding, new Integer(cmp));
        }
        switch (cmp) {
            case 1: {
                IScope scope;
                match.setASTInformation(1);
                if (this.fRenameTo == null || (scope = ASTManager.getContainingScope(name)) == null) break;
                IBinding[] conflicting = null;
                try {
                    conflicting = ASTManager.findInScope(scope, this.fRenameTo, true);
                }
                catch (Exception e) {
                    CUIPlugin.log(e);
                }
                if (conflicting == null || conflicting.length <= 0) break;
                this.fConflictingBinding.addAll(Arrays.asList(conflicting));
                break;
            }
            case 0: {
                match.setASTInformation(2);
            }
        }
    }

    public void handleDOMException(IASTTranslationUnit tu, DOMException e, RefactoringStatus status) {
        this.handleProblemBinding(tu, e.getProblem(), status);
    }

    public void handleProblemBinding(IASTTranslationUnit tu, IProblemBinding pb, RefactoringStatus status) {
        String fpath;
        if (tu != null && this.fProblemUnits.add(fpath = tu.getFilePath())) {
            String msg = pb.getMessage();
            msg = msg != null && msg.length() > 0 ? NLS.bind((String)RenameMessages.ASTManager_warning_parsingError_detailed, (Object)msg) : RenameMessages.ASTManager_warning_parsingError;
            int line = pb.getLineNumber();
            msg = line >= 1 ? NLS.bind((String)RenameMessages.ASTManager_warning_parsingError_withFileAndLine, (Object[])new Object[]{msg, fpath, line}) : NLS.bind((String)RenameMessages.ASTManager_warning_parsingError_withFile, (Object)msg, (Object)fpath);
            status.addWarning(msg);
        }
    }

    protected void handleConflictingBindings(IASTTranslationUnit tu, RefactoringStatus status) {
        if (this.fConflictingBinding.isEmpty()) {
            return;
        }
        int argKind = this.fArgument.getArgumentKind();
        boolean isVarParEnumerator = false;
        boolean isLocalVarPar = false;
        boolean isFunction = false;
        boolean isContainer = false;
        boolean isMacro = false;
        switch (argKind) {
            case 1: 
            case 2: {
                isLocalVarPar = true;
                isVarParEnumerator = true;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 13: {
                isVarParEnumerator = true;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                isFunction = true;
                break;
            }
            case 10: 
            case 14: 
            case 15: {
                isContainer = true;
                break;
            }
            case 11: {
                isMacro = true;
                break;
            }
        }
        Collection[] cflc = new Collection[]{new HashSet(), new ArrayList(), new ArrayList()};
        String[] errs = null;
        if (isMacro) {
            errs = new String[]{RenameMessages.CRenameLocalProcessor_error_conflict};
            cflc[0] = this.fConflictingBinding;
        } else {
            errs = new String[]{RenameMessages.CRenameLocalProcessor_error_shadow, RenameMessages.CRenameLocalProcessor_error_redeclare, RenameMessages.CRenameLocalProcessor_error_isShadowed, RenameMessages.CRenameLocalProcessor_error_overloads};
            this.classifyConflictingBindings(tu, (Set)cflc[0], (List)cflc[1], (List)cflc[2], status);
        }
        int i = 0;
        while (i < 3) {
            Collection coll = cflc[i];
            for (Object name : coll) {
                RefactoringStatusEntry[] entries;
                boolean warn = false;
                String msg = errs[i];
                IBinding conflict = (IBinding)name;
                String what = null;
                if (conflict instanceof IEnumerator) {
                    if (isVarParEnumerator || isFunction || isMacro) {
                        what = RenameMessages.CRenameLocalProcessor_enumerator;
                    }
                } else if (conflict instanceof ICPPField) {
                    if (isVarParEnumerator || isFunction || isMacro) {
                        what = RenameMessages.CRenameLocalProcessor_field;
                    }
                } else if (conflict instanceof IParameter) {
                    if (isVarParEnumerator || isFunction || isMacro) {
                        if (i == 1 && argKind == 1) {
                            msg = errs[0];
                        }
                        what = RenameMessages.CRenameLocalProcessor_parameter;
                    }
                } else if (conflict instanceof IVariable) {
                    if (isVarParEnumerator || isFunction || isMacro) {
                        IVariable conflictingVar = (IVariable)conflict;
                        what = RenameMessages.CRenameLocalProcessor_globalVariable;
                        if (ASTManager.isLocalVariable(conflictingVar)) {
                            if (i == 1 && argKind == 2) {
                                msg = errs[2];
                            }
                            what = RenameMessages.CRenameLocalProcessor_localVariable;
                        } else if (conflictingVar.isStatic()) {
                            what = RenameMessages.CRenameProcessorDelegate_fileStaticVariable;
                        }
                    }
                } else if (conflict instanceof ICPPConstructor) {
                    if (isVarParEnumerator || isFunction || isMacro) {
                        what = RenameMessages.CRenameLocalProcessor_constructor;
                    }
                } else if (conflict instanceof ICPPMethod) {
                    if (isVarParEnumerator || isFunction || isMacro) {
                        IBinding r;
                        if (i == 1 && (r = this.fArgument.getBinding()) instanceof ICPPMethod) {
                            try {
                                if (ASTManager.hasSameSignature((IFunction)((ICPPMethod)r), (IFunction)((ICPPMethod)conflict)) == 0) {
                                    msg = errs[3];
                                    warn = true;
                                }
                            }
                            catch (DOMException dOMException) {}
                        }
                        what = RenameMessages.CRenameLocalProcessor_method;
                    }
                } else if (conflict instanceof IFunction) {
                    if (isVarParEnumerator || isFunction || isMacro) {
                        IASTName[] refs;
                        boolean ignore = false;
                        if (isLocalVarPar && ((refs = this.fArgument.getTranslationUnit().getReferences(conflict)) == null || refs.length == 0)) {
                            ignore = true;
                        }
                        if (!ignore) {
                            boolean isStatic;
                            IBinding r;
                            IFunction conflictingFunction = (IFunction)conflict;
                            if (i == 1 && conflict instanceof ICPPFunction && (r = this.fArgument.getBinding()) instanceof ICPPFunction) {
                                try {
                                    if (ASTManager.hasSameSignature((IFunction)((ICPPFunction)r), conflictingFunction) == 0) {
                                        msg = errs[3];
                                        warn = true;
                                    }
                                }
                                catch (DOMException dOMException) {}
                            }
                            what = (isStatic = conflictingFunction.isStatic()) ? RenameMessages.CRenameProcessorDelegate_fileStaticFunction : RenameMessages.CRenameProcessorDelegate_globalFunction;
                        }
                    }
                } else if (conflict instanceof ICompositeType || conflict instanceof IEnumeration || conflict instanceof ITypedef) {
                    if (isContainer || isMacro) {
                        what = RenameMessages.CRenameProcessorDelegate_type;
                    }
                } else if (conflict instanceof ICPPNamespace && (isContainer || isMacro)) {
                    what = RenameMessages.CRenameProcessorDelegate_namespace;
                    if (argKind == 15) {
                        warn = true;
                    }
                }
                if (what == null) continue;
                String message = RenameMessages.CRenameLocalProcessor_error_message;
                String message1 = NLS.bind((String)RenameMessages.CRenameLocalProcessor_error_message1, (Object)msg);
                String message2 = NLS.bind((String)RenameMessages.CRenameLocalProcessor_error_message2, (Object)conflict.getName());
                String message3 = NLS.bind((String)RenameMessages.CRenameLocalProcessor_error_message3, (Object)what);
                String space = "  \n";
                String formatted = String.valueOf(message) + space + message1 + space + message2 + space + message3;
                RefactoringStatusEntry[] refactoringStatusEntryArray = entries = status.getEntries();
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    RefactoringStatusEntry entry = refactoringStatusEntryArray[n2];
                    if (formatted.equals(entry.getMessage())) {
                        formatted = null;
                        break;
                    }
                    ++n2;
                }
                if (formatted == null) continue;
                if (warn) {
                    status.addWarning(formatted);
                    continue;
                }
                status.addError(formatted);
            }
            ++i;
        }
    }

    protected void classifyConflictingBindings(IASTTranslationUnit tu, Set<IBinding> shadows, Collection<IBinding> redecl, Collection<IBinding> barriers, RefactoringStatus status) {
        String name = this.fArgument.getName();
        IBinding[] newBindingsAboverOrEqual = null;
        IScope oldBindingsScope = null;
        for (Map.Entry<IBinding, Integer> entry : this.fKnownBindings.entrySet()) {
            IBinding oldBinding = entry.getKey();
            Integer value = entry.getValue();
            if (value == 1 && oldBinding.getName().equals(name)) {
                try {
                    oldBindingsScope = oldBinding.getScope();
                    if (oldBindingsScope != null) {
                        newBindingsAboverOrEqual = ASTManager.findInScope(oldBindingsScope, this.fRenameTo, false);
                    }
                }
                catch (DOMException e) {
                    this.handleDOMException(tu, e, status);
                }
            }
            if (newBindingsAboverOrEqual != null && newBindingsAboverOrEqual.length > 0) break;
        }
        if (newBindingsAboverOrEqual == null) {
            newBindingsAboverOrEqual = new IBinding[]{};
        }
        for (IBinding conflictingBinding : this.fConflictingBinding) {
            if (conflictingBinding == null) continue;
            boolean isAboveOrEqual = false;
            int i = 0;
            while (!isAboveOrEqual && i < newBindingsAboverOrEqual.length) {
                IBinding aboveBinding = newBindingsAboverOrEqual[i];
                try {
                    if (ASTManager.isSameBinding(tu.getIndex(), aboveBinding, conflictingBinding) == 1) {
                        isAboveOrEqual = true;
                    }
                }
                catch (DOMException e) {
                    this.handleDOMException(tu, e, status);
                }
                ++i;
            }
            if (isAboveOrEqual) continue;
            barriers.add(conflictingBinding);
        }
        IBinding[] iBindingArray = newBindingsAboverOrEqual;
        int n = newBindingsAboverOrEqual.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding aboveBinding = iBindingArray[n2];
            try {
                IScope aboveScope = aboveBinding.getScope();
                if (ASTManager.isSameScope(aboveScope, oldBindingsScope, false) == 1) {
                    redecl.add(aboveBinding);
                } else {
                    shadows.add(aboveBinding);
                }
            }
            catch (DOMException e) {
                this.handleDOMException(tu, e, status);
            }
            ++n2;
        }
    }

    public void setValidBindings(IBinding[] validBindings) {
        this.fValidBindings = validBindings;
    }

    public void setRenameTo(String renameTo) {
        this.fRenameTo = renameTo;
    }
}

