/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElseStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorEndifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfdefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfndefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorUndefStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.internal.core.dom.parser.ASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class LinkedNamesFinder {
    private static final IRegion[] EMPTY_LOCATIONS_ARRAY = new IRegion[0];

    private LinkedNamesFinder() {
    }

    public static IRegion[] findByName(IASTTranslationUnit root, IASTName name) {
        IBinding target = name.resolveBinding();
        if (target == null) {
            return EMPTY_LOCATIONS_ARRAY;
        }
        BindingFinder bindingFinder = new BindingFinder(root);
        bindingFinder.find(target);
        return bindingFinder.getLocations();
    }

    private static class BindingFinder {
        private final IASTTranslationUnit root;
        private final List<IRegion> locations;

        public BindingFinder(IASTTranslationUnit root) {
            this.root = root;
            this.locations = new ArrayList<IRegion>();
        }

        public void find(IBinding target) {
            if (target instanceof IMacroBinding) {
                this.findMacro((IMacroBinding)target);
                return;
            }
            if (target instanceof ICPPConstructor || target instanceof ICPPMethod && ((ICPPMethod)target).isDestructor()) {
                target = ((ICPPMethod)target).getClassOwner();
            }
            this.findBinding(target);
            if (target instanceof ICPPClassType) {
                ICPPMethod[] methods;
                ICPPConstructor[] constructors;
                ICPPConstructor[] iCPPConstructorArray = constructors = ((ICPPClassType)target).getConstructors();
                int n = constructors.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPConstructor ctor = iCPPConstructorArray[n2];
                    if (!ctor.isImplicit()) {
                        this.findBinding((IBinding)ctor);
                    }
                    ++n2;
                }
                ICPPMethod[] iCPPMethodArray = methods = ((ICPPClassType)target).getDeclaredMethods();
                int n3 = methods.length;
                n = 0;
                while (n < n3) {
                    ICPPMethod method = iCPPMethodArray[n];
                    if (method.isDestructor()) {
                        this.findBinding((IBinding)method);
                    }
                    ++n;
                }
            } else if (target instanceof ICPPMethod) {
                ICPPMethod m;
                ICPPMethod method = (ICPPMethod)target;
                ICPPMethod[] iCPPMethodArray = ClassTypeHelper.findOverridden((ICPPMethod)method);
                int n = iCPPMethodArray.length;
                int n4 = 0;
                while (n4 < n) {
                    m = iCPPMethodArray[n4];
                    this.findBinding((IBinding)m);
                    ++n4;
                }
                try {
                    iCPPMethodArray = this.findOverridersInAST(method);
                    n = iCPPMethodArray.length;
                    n4 = 0;
                    while (n4 < n) {
                        m = iCPPMethodArray[n4];
                        this.findBinding((IBinding)m);
                        ++n4;
                    }
                }
                catch (DOMException dOMException) {}
            }
        }

        private ICPPMethod[] findOverridersInAST(ICPPMethod method) throws DOMException {
            if (!ClassTypeHelper.isVirtual((ICPPMethod)method)) {
                return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
            }
            ICPPClassType ownerClass = method.getClassOwner();
            if (ownerClass == null) {
                return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
            }
            SubclassFinder subclassFinder = new SubclassFinder(ownerClass);
            this.root.accept((ASTVisitor)subclassFinder);
            return ClassTypeHelper.findOverriders((ICPPClassType[])subclassFinder.getSubclasses(), (ICPPMethod)method);
        }

        public IRegion[] getLocations() {
            if (this.locations.isEmpty()) {
                return EMPTY_LOCATIONS_ARRAY;
            }
            return this.locations.toArray(new IRegion[this.locations.size()]);
        }

        private void findBinding(IBinding target) {
            IASTName candidate;
            IASTName[] names;
            IASTName[] iASTNameArray = names = this.root.getDeclarationsInAST(target);
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                candidate = iASTNameArray[n2];
                if (candidate.isPartOfTranslationUnitFile()) {
                    this.addLocation(candidate);
                }
                ++n2;
            }
            iASTNameArray = names = this.root.getReferences(target);
            n = names.length;
            n2 = 0;
            while (n2 < n) {
                candidate = iASTNameArray[n2];
                if (candidate.isPartOfTranslationUnitFile()) {
                    this.addLocation(candidate);
                }
                ++n2;
            }
        }

        private void addLocation(IASTName name) {
            IBinding binding = name.resolveBinding();
            if (binding != null) {
                IASTImageLocation fileLocation;
                if (name instanceof ICPPASTTemplateId) {
                    name = ((ICPPASTTemplateId)name).getTemplateName();
                }
                if ((fileLocation = name.getImageLocation()) == null || !this.root.getFilePath().equals(fileLocation.getFileName())) {
                    fileLocation = name.getFileLocation();
                }
                if (fileLocation != null) {
                    int offset = fileLocation.getNodeOffset();
                    int length = fileLocation.getNodeLength();
                    if (binding instanceof ICPPMethod && ((ICPPMethod)binding).isDestructor()) {
                        ++offset;
                        --length;
                    }
                    if (offset >= 0 && length > 0) {
                        this.locations.add((IRegion)new Region(offset, length));
                    }
                }
            }
        }

        private void findMacro(IMacroBinding target) {
            IASTPreprocessorStatement[] statements;
            this.findBinding((IBinding)target);
            char[] nameChars = target.getNameCharArray();
            ArrayList<IASTName> ifdefNameStack = new ArrayList<IASTName>();
            IASTPreprocessorStatement[] iASTPreprocessorStatementArray = statements = this.root.getAllPreprocessorStatements();
            int n = statements.length;
            int n2 = 0;
            while (n2 < n) {
                IASTPreprocessorStatement statement = iASTPreprocessorStatementArray[n2];
                if (statement.isPartOfTranslationUnitFile()) {
                    IASTName macroName = null;
                    boolean ifStatement = false;
                    if (statement instanceof IASTPreprocessorIfdefStatement) {
                        macroName = ((IASTPreprocessorIfdefStatement)statement).getMacroReference();
                        ifStatement = true;
                    } else if (statement instanceof IASTPreprocessorIfndefStatement) {
                        macroName = ((IASTPreprocessorIfndefStatement)statement).getMacroReference();
                        ifStatement = true;
                    } else if (statement instanceof IASTPreprocessorMacroDefinition) {
                        macroName = ((IASTPreprocessorMacroDefinition)statement).getName();
                    } else if (statement instanceof IASTPreprocessorUndefStatement) {
                        macroName = ((IASTPreprocessorUndefStatement)statement).getMacroName();
                    } else if (statement instanceof IASTPreprocessorIfStatement) {
                        ifStatement = true;
                    } else if (statement instanceof IASTPreprocessorEndifStatement) {
                        if (!ifdefNameStack.isEmpty() && ifdefNameStack.remove(ifdefNameStack.size() - 1) != null) {
                            this.findInStatementComment(nameChars, statement);
                        }
                    } else if (statement instanceof IASTPreprocessorElseStatement && !ifdefNameStack.isEmpty() && ifdefNameStack.get(ifdefNameStack.size() - 1) != null) {
                        this.findInStatementComment(nameChars, statement);
                    }
                    if (macroName != null) {
                        if (Arrays.equals(nameChars, macroName.getSimpleID())) {
                            IBinding binding = macroName.resolveBinding();
                            if (!target.equals(binding)) {
                                this.findBinding(binding);
                            }
                        } else {
                            macroName = null;
                        }
                    }
                    if (ifStatement) {
                        ifdefNameStack.add(macroName);
                    }
                }
                ++n2;
            }
        }

        private void findInStatementComment(char[] nameChars, IASTPreprocessorStatement statement) {
            IASTFileLocation location = statement.getFileLocation();
            IASTComment comment = this.findComment(location.getNodeOffset() + location.getNodeLength());
            if (comment != null && comment.getFileLocation().getStartingLineNumber() == location.getStartingLineNumber()) {
                this.findInComment(nameChars, comment);
            }
        }

        private IASTComment findComment(int startOffset) {
            IASTComment[] comments = ((ASTTranslationUnit)this.root).getComments();
            int low = 0;
            int high = comments.length;
            while (low < high) {
                int mid = (low + high) / 2;
                int offset = comments[mid].getFileLocation().getNodeOffset();
                if (offset < startOffset) {
                    low = mid + 1;
                    continue;
                }
                high = mid;
                if (offset == startOffset) break;
            }
            return high < comments.length ? comments[high] : null;
        }

        private void findInComment(char[] name, IASTComment comment) {
            char[] text = comment.getComment();
            int j = 0;
            int i = 2;
            while (i <= text.length - name.length + j) {
                char c = text[i];
                if (!Character.isJavaIdentifierPart(c)) {
                    j = 0;
                } else if (j >= 0 && j < name.length && name[j] == c) {
                    if (!(++j != name.length || i + 1 != text.length && Character.isJavaIdentifierPart(text[i + 1]))) {
                        int offset = comment.getFileLocation().getNodeOffset() + i + 1 - name.length;
                        this.locations.add((IRegion)new Region(offset, name.length));
                        j = 0;
                    }
                } else {
                    j = -1;
                }
                ++i;
            }
        }
    }

    static class SubclassFinder
    extends ASTVisitor {
        private final ICPPClassType baseClass;
        private Set<ICPPClassType> subclasses;
        private Set<IBinding> seenClasses;

        SubclassFinder(ICPPClassType baseClass) {
            this.shouldVisitNames = true;
            this.subclasses = new HashSet<ICPPClassType>();
            this.seenClasses = new HashSet<IBinding>();
            this.baseClass = baseClass;
        }

        public int visit(IASTName name) {
            ICPPClassType candidate;
            IBinding binding = name.resolveBinding();
            if (binding instanceof ICPPClassType && this.seenClasses.add(binding) && ClassTypeHelper.isSubclass((ICPPClassType)(candidate = (ICPPClassType)binding), (ICPPClassType)this.baseClass)) {
                this.subclasses.add(candidate);
            }
            return 3;
        }

        public ICPPClassType[] getSubclasses() {
            return this.subclasses.toArray(new ICPPClassType[this.subclasses.size()]);
        }
    }
}

