/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.widgets;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;

public class ImageCanvas
extends Canvas {
    private static final int SCROLLBAR_INCREMENT = 20;
    private Point mOrigin = new Point(0, 0);
    private ScrollBar mHorizontalScrollBar = this.getHorizontalBar();
    private ScrollBar mVerticalScrollBar = this.getVerticalBar();
    private Image mImage;
    private boolean mFitToCanvas = true;

    public ImageCanvas(Composite parent) {
        super(parent, 262912);
        this.setScrollBarIncrements();
        this.setScrollBarPageIncrements(this.getClientArea());
        this.updateScrollBars();
        SelectionAdapter scrollBarSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == ImageCanvas.this.mHorizontalScrollBar) {
                    ImageCanvas.this.scrollHorizontally();
                } else {
                    ImageCanvas.this.scrollVertically();
                }
            }
        };
        this.mHorizontalScrollBar.addSelectionListener((SelectionListener)scrollBarSelectionListener);
        this.mVerticalScrollBar.addSelectionListener((SelectionListener)scrollBarSelectionListener);
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                ImageCanvas.this.setScrollBarPageIncrements(ImageCanvas.this.getClientArea());
                ImageCanvas.this.updateScrollBars();
            }
        });
        this.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                ImageCanvas.this.paintCanvas(e.gc);
            }
        });
    }

    public void setFitToCanvas(boolean en) {
        this.mFitToCanvas = en;
        this.updateScrollBars();
        this.redraw();
    }

    public void setImage(Image image) {
        if (this.mImage != null) {
            this.mImage.dispose();
        }
        this.mImage = image;
        this.mOrigin = new Point(0, 0);
        this.updateScrollBars();
        this.redraw();
    }

    private void updateScrollBars() {
        int imageHeight;
        int imageWidth;
        Rectangle client = this.getClientArea();
        if (this.mImage != null & !this.mFitToCanvas) {
            imageWidth = this.mImage.getBounds().width;
            imageHeight = this.mImage.getBounds().height;
        } else {
            imageWidth = client.width;
            imageHeight = client.height;
        }
        this.mHorizontalScrollBar.setMaximum(imageWidth);
        this.mVerticalScrollBar.setMaximum(imageHeight);
        this.mHorizontalScrollBar.setThumb(Math.min(imageWidth, client.width));
        this.mVerticalScrollBar.setThumb(Math.min(imageHeight, client.height));
        int hPage = imageWidth - client.width;
        int vPage = imageHeight - client.height;
        int hSelection = this.mHorizontalScrollBar.getSelection();
        int vSelection = this.mVerticalScrollBar.getSelection();
        if (hSelection >= hPage) {
            if (hPage <= 0) {
                hSelection = 0;
            }
            this.mOrigin.x = -hSelection;
        }
        if (vSelection >= vPage) {
            if (vPage <= 0) {
                vSelection = 0;
            }
            this.mOrigin.y = -vSelection;
        }
        this.redraw();
    }

    private void setScrollBarPageIncrements(Rectangle clientArea) {
        this.mHorizontalScrollBar.setPageIncrement(clientArea.width);
        this.mVerticalScrollBar.setPageIncrement(clientArea.height);
    }

    private void setScrollBarIncrements() {
        this.mHorizontalScrollBar.setIncrement(20);
        this.mVerticalScrollBar.setIncrement(20);
    }

    private void scrollHorizontally() {
        if (this.mImage == null) {
            return;
        }
        int selection = this.mHorizontalScrollBar.getSelection();
        int destX = -selection - this.mOrigin.x;
        Rectangle imageBounds = this.mImage.getBounds();
        this.scroll(destX, 0, 0, 0, imageBounds.width, imageBounds.height, false);
        this.mOrigin.x = -selection;
    }

    private void scrollVertically() {
        if (this.mImage == null) {
            return;
        }
        int selection = this.mVerticalScrollBar.getSelection();
        int destY = -selection - this.mOrigin.y;
        Rectangle imageBounds = this.mImage.getBounds();
        this.scroll(0, destY, 0, 0, imageBounds.width, imageBounds.height, false);
        this.mOrigin.y = -selection;
    }

    private void paintCanvas(GC gc) {
        gc.fillRectangle(this.getClientArea());
        if (this.mImage == null) {
            return;
        }
        Rectangle rect = this.mImage.getBounds();
        Rectangle client = this.getClientArea();
        if (this.mFitToCanvas && rect.width > 0 && rect.height > 0) {
            double sx = (double)client.width / (double)rect.width;
            double sy = (double)client.height / (double)rect.height;
            if (sx < sy) {
                gc.drawImage(this.mImage, 0, 0, rect.width, rect.height, 0, 0, client.width, (int)((double)rect.height * sx));
                this.drawBorder(gc, 0, 0, client.width, (int)((double)rect.height * sx));
            } else {
                gc.drawImage(this.mImage, 0, 0, rect.width, rect.height, 0, 0, (int)((double)rect.width * sy), client.height);
                this.drawBorder(gc, 0, 0, (int)((double)rect.width * sy), client.height);
            }
        } else {
            gc.drawImage(this.mImage, this.mOrigin.x, this.mOrigin.y);
            this.drawBorder(gc, this.mOrigin.x, this.mOrigin.y, rect.width, rect.height);
        }
    }

    private void drawBorder(GC gc, int x, int y, int width, int height) {
        Color origFg = gc.getForeground();
        gc.setForeground(Display.getDefault().getSystemColor(18));
        gc.drawRectangle(x, y, width, height);
        gc.setForeground(origFg);
    }

    public void dispose() {
        if (this.mImage != null && !this.mImage.isDisposed()) {
            this.mImage.dispose();
        }
    }

    public void exportImageTo(File file) {
        if (this.mImage == null || file == null) {
            return;
        }
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{this.mImage.getImageData()};
        try {
            imageLoader.save(file.getAbsolutePath(), 5);
        }
        catch (Exception e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"Save Image", (String)"Error saving image", (IStatus)new Status(4, "com.android.ide.eclipse.gldebugger", e.toString()));
        }
    }
}

