/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IMultiConfiguration;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.MultiConfiguration;
import org.eclipse.cdt.managedbuilder.internal.ui.Messages;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildBehaviourTab;
import org.eclipse.cdt.managedbuilder.ui.properties.ManagedBuilderUIPlugin;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BuilderSettingsTab
extends AbstractCBuildPropertyTab {
    private Button b_useDefault;
    private Combo c_builderType;
    private Text t_buildCmd;
    private Button b_genMakefileAuto;
    private Button b_expandVars;
    private Text t_dir;
    private Button b_dirWsp;
    private Button b_dirFile;
    private Button b_dirVars;
    private Group group_dir;
    private IBuilder bldr;
    private IConfiguration icfg;
    private boolean canModify = true;

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout(1, false));
        Group g1 = this.setupGroup(this.usercomp, Messages.BuilderSettingsTab_0, 3, 768);
        this.setupLabel((Composite)g1, Messages.BuilderSettingsTab_1, 1, 1);
        this.c_builderType = new Combo((Composite)g1, 2060);
        this.setupControl((Control)this.c_builderType, 2, 768);
        this.c_builderType.add(Messages.BuilderSettingsTab_2);
        this.c_builderType.add(Messages.BuilderSettingsTab_3);
        this.c_builderType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BuilderSettingsTab.this.enableInternalBuilder(BuilderSettingsTab.this.c_builderType.getSelectionIndex() == 1);
                BuilderSettingsTab.this.updateButtons();
            }
        });
        this.b_useDefault = this.setupCheck((Composite)g1, Messages.BuilderSettingsTab_4, 3, 1);
        this.setupLabel((Composite)g1, Messages.BuilderSettingsTab_5, 1, 1);
        this.t_buildCmd = this.setupBlock((Composite)g1, (Control)this.b_useDefault);
        this.t_buildCmd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!BuilderSettingsTab.this.canModify) {
                    return;
                }
                String fullCommand = BuilderSettingsTab.this.t_buildCmd.getText().trim();
                String buildCommand = BuilderSettingsTab.this.parseMakeCommand(fullCommand);
                String buildArgs = fullCommand.substring(buildCommand.length()).trim();
                if (!buildCommand.equals(BuilderSettingsTab.this.bldr.getCommand()) || !buildArgs.equals(BuilderSettingsTab.this.bldr.getArguments())) {
                    BuilderSettingsTab.this.setCommand(buildCommand);
                    BuilderSettingsTab.this.setArguments(buildArgs);
                }
            }
        });
        Group g2 = this.setupGroup(this.usercomp, Messages.BuilderSettingsTab_6, 2, 768);
        ((GridLayout)g2.getLayout()).makeColumnsEqualWidth = true;
        this.b_genMakefileAuto = this.setupCheck((Composite)g2, Messages.BuilderSettingsTab_7, 1, 1);
        this.b_expandVars = this.setupCheck((Composite)g2, Messages.BuilderSettingsTab_8, 1, 1);
        this.group_dir = this.setupGroup(this.usercomp, Messages.BuilderSettingsTab_21, 2, 768);
        this.setupLabel((Composite)this.group_dir, Messages.BuilderSettingsTab_22, 1, 1);
        this.t_dir = this.setupText((Composite)this.group_dir, 1, 768);
        this.t_dir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BuilderSettingsTab.this.canModify) {
                    BuilderSettingsTab.this.setBuildPath(BuilderSettingsTab.this.t_dir.getText());
                }
            }
        });
        Composite c = new Composite((Composite)this.group_dir, 0);
        this.setupControl((Control)c, 2, 768);
        GridLayout f = new GridLayout(4, false);
        c.setLayout((Layout)f);
        Label dummy = new Label(c, 0);
        dummy.setLayoutData((Object)new GridData(768));
        this.b_dirWsp = this.setupBottomButton(c, WORKSPACEBUTTON_NAME);
        this.b_dirFile = this.setupBottomButton(c, FILESYSTEMBUTTON_NAME);
        this.b_dirVars = this.setupBottomButton(c, VARIABLESBUTTON_NAME);
    }

    private void setManagedBuild(boolean enable) {
        this.setManagedBuildOn(enable);
        this.page.informPages(101, null);
        this.updateButtons();
    }

    protected void updateButtons() {
        this.bldr = this.icfg.getEditableBuilder();
        this.canModify = false;
        int[] extStates = BuildBehaviourTab.calc3states(this.page, this.icfg, 0);
        this.b_genMakefileAuto.setEnabled(this.icfg.supportsBuild(true));
        if (extStates == null) {
            BuildBehaviourTab.setTriSelection((Button)this.b_genMakefileAuto, (boolean)this.bldr.isManagedBuildOn());
            BuildBehaviourTab.setTriSelection((Button)this.b_useDefault, (boolean)this.bldr.isDefaultBuildCmd());
            if (!this.bldr.canKeepEnvironmentVariablesInBuildfile()) {
                this.b_expandVars.setEnabled(false);
            } else {
                this.b_expandVars.setEnabled(true);
                BuildBehaviourTab.setTriSelection((Button)this.b_expandVars, (!this.bldr.keepEnvironmentVariablesInBuildfile() ? 1 : 0) != 0);
            }
        } else {
            BuildBehaviourTab.setTriSelection((Button)this.b_genMakefileAuto, (int)extStates[0]);
            BuildBehaviourTab.setTriSelection((Button)this.b_useDefault, (int)extStates[1]);
            if (extStates[2] != 1) {
                this.b_expandVars.setEnabled(false);
            } else {
                this.b_expandVars.setEnabled(true);
                BuildBehaviourTab.setTriSelection((Button)this.b_expandVars, (int)extStates[3]);
            }
        }
        this.c_builderType.select(this.isInternalBuilderEnabled() ? 1 : 0);
        this.c_builderType.setEnabled(this.canEnableInternalBuilder(true) && this.canEnableInternalBuilder(false));
        this.t_buildCmd.setText(this.getMC());
        if (this.page.isMultiCfg()) {
            this.group_dir.setVisible(false);
        } else {
            this.group_dir.setVisible(true);
            this.t_dir.setText(this.bldr.getBuildPath());
            boolean mbOn = this.bldr.isManagedBuildOn();
            this.t_dir.setEnabled(!mbOn);
            this.b_dirVars.setEnabled(!mbOn);
            this.b_dirWsp.setEnabled(!mbOn);
            this.b_dirFile.setEnabled(!mbOn);
        }
        boolean external = this.c_builderType.getSelectionIndex() == 0;
        this.b_useDefault.setEnabled(external);
        this.t_buildCmd.setEnabled(external);
        ((Control)this.t_buildCmd.getData()).setEnabled(external & !this.b_useDefault.getSelection());
        this.b_genMakefileAuto.setEnabled(external && this.icfg.supportsBuild(true));
        if (this.b_expandVars.getEnabled()) {
            this.b_expandVars.setEnabled(external && this.b_genMakefileAuto.getSelection());
        }
        if (external) {
            this.checkPressed((Control)this.b_useDefault, false);
        }
        this.canModify = true;
    }

    private Button setupBottomButton(Composite c, String name) {
        Button b = new Button(c, 8);
        b.setText(name);
        GridData fd = new GridData(2);
        fd.minimumWidth = 120;
        b.setLayoutData((Object)fd);
        b.setData((Object)this.t_dir);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BuilderSettingsTab.this.buttonVarPressed(event);
            }
        });
        return b;
    }

    private Text setupBlock(Composite c, Control check) {
        Text t = this.setupText(c, 1, 768);
        Button b = this.setupButton(c, VARIABLESBUTTON_NAME, 1, 3);
        b.setData((Object)t);
        t.setData((Object)b);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BuilderSettingsTab.this.buttonVarPressed(event);
            }
        });
        if (check != null) {
            check.setData((Object)t);
        }
        return t;
    }

    private void buttonVarPressed(SelectionEvent e) {
        Widget b = e.widget;
        if (b == null || b.getData() == null) {
            return;
        }
        if (b.getData() instanceof Text) {
            String x = null;
            if (b.equals(this.b_dirWsp)) {
                x = BuilderSettingsTab.getWorkspaceDirDialog((Shell)this.usercomp.getShell(), (String)"");
                if (x != null) {
                    ((Text)b.getData()).setText(x);
                }
            } else if (b.equals(this.b_dirFile)) {
                x = BuilderSettingsTab.getFileSystemDirDialog((Shell)this.usercomp.getShell(), (String)"");
                if (x != null) {
                    ((Text)b.getData()).setText(x);
                }
            } else {
                x = AbstractCPropertyTab.getVariableDialog((Shell)this.usercomp.getShell(), (ICConfigurationDescription)this.getResDesc().getConfiguration());
                if (x != null) {
                    ((Text)b.getData()).insert(x);
                }
            }
        }
    }

    public void checkPressed(SelectionEvent e) {
        this.checkPressed((Control)e.widget, true);
        this.updateButtons();
    }

    private void checkPressed(Control b, boolean needUpdate) {
        if (b == null) {
            return;
        }
        boolean val = false;
        if (b instanceof Button) {
            val = ((Button)b).getSelection();
        }
        if (b.getData() instanceof Text) {
            Text t = (Text)b.getData();
            if (b == this.b_useDefault) {
                val = !val;
            }
            t.setEnabled(val);
            if (t.getData() != null && t.getData() instanceof Control) {
                Control c = (Control)t.getData();
                c.setEnabled(val);
            }
        }
        if (!needUpdate) {
            return;
        }
        if (b == this.b_useDefault) {
            this.setUseDefaultBuildCmd(!val);
        } else if (b == this.b_genMakefileAuto) {
            this.setManagedBuild(val);
        } else if (b == this.b_expandVars && this.bldr.canKeepEnvironmentVariablesInBuildfile()) {
            this.setKeepEnvironmentVariablesInBuildfile(!val);
        }
    }

    private String getMC() {
        String makeCommand = this.bldr.getCommand();
        String makeArgs = this.bldr.getArguments();
        if (makeArgs != null) {
            makeCommand = String.valueOf(makeCommand) + " " + makeArgs;
        }
        return makeCommand;
    }

    public void updateData(ICResourceDescription cfgd) {
        if (cfgd == null) {
            return;
        }
        this.icfg = BuilderSettingsTab.getCfg(cfgd.getConfiguration());
        this.updateButtons();
    }

    public void performApply(ICResourceDescription src, ICResourceDescription dst) {
        BuildBehaviourTab.apply(src, dst, this.page.isMultiCfg());
    }

    private String parseMakeCommand(String rawCommand) {
        String[] result = rawCommand.split("\\s");
        if (result != null && result.length > 0) {
            return result[0];
        }
        return rawCommand;
    }

    public boolean canBeVisible() {
        return this.page.isForProject() || this.page.isForPrefs();
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    protected void performDefaults() {
        if (this.icfg instanceof IMultiConfiguration) {
            IConfiguration[] cfs = (IConfiguration[])((IMultiConfiguration)this.icfg).getItems();
            int i = 0;
            while (i < cfs.length) {
                IBuilder b = cfs[i].getEditableBuilder();
                BuildBehaviourTab.copyBuilders(b.getSuperClass(), b);
                ++i;
            }
        } else {
            BuildBehaviourTab.copyBuilders(this.bldr.getSuperClass(), this.bldr);
        }
        this.updateData(this.getResDesc());
    }

    private boolean canEnableInternalBuilder(boolean v) {
        if (this.icfg instanceof Configuration) {
            return ((Configuration)this.icfg).canEnableInternalBuilder(v);
        }
        if (this.icfg instanceof IMultiConfiguration) {
            return ((IMultiConfiguration)this.icfg).canEnableInternalBuilder(v);
        }
        return false;
    }

    private void enableInternalBuilder(boolean v) {
        if (this.icfg instanceof Configuration) {
            ((Configuration)this.icfg).enableInternalBuilder(v);
        }
        if (this.icfg instanceof IMultiConfiguration) {
            ((IMultiConfiguration)this.icfg).enableInternalBuilder(v);
        }
    }

    private boolean isInternalBuilderEnabled() {
        if (this.icfg instanceof Configuration) {
            return ((Configuration)this.icfg).isInternalBuilderEnabled();
        }
        if (this.icfg instanceof IMultiConfiguration) {
            return ((MultiConfiguration)this.icfg).isInternalBuilderEnabled();
        }
        return false;
    }

    private void setUseDefaultBuildCmd(boolean val) {
        try {
            if (this.icfg instanceof IMultiConfiguration) {
                IConfiguration[] cfs = (IConfiguration[])((IMultiConfiguration)this.icfg).getItems();
                int i = 0;
                while (i < cfs.length) {
                    IBuilder b = cfs[i].getEditableBuilder();
                    if (b != null) {
                        b.setUseDefaultBuildCmd(val);
                    }
                    ++i;
                }
            } else {
                this.icfg.getEditableBuilder().setUseDefaultBuildCmd(val);
            }
        }
        catch (CoreException e) {
            ManagedBuilderUIPlugin.log(e);
        }
    }

    private void setKeepEnvironmentVariablesInBuildfile(boolean val) {
        if (this.icfg instanceof IMultiConfiguration) {
            IConfiguration[] cfs = (IConfiguration[])((IMultiConfiguration)this.icfg).getItems();
            int i = 0;
            while (i < cfs.length) {
                IBuilder b = cfs[i].getEditableBuilder();
                if (b != null) {
                    b.setKeepEnvironmentVariablesInBuildfile(val);
                }
                ++i;
            }
        } else {
            this.icfg.getEditableBuilder().setKeepEnvironmentVariablesInBuildfile(val);
        }
    }

    private void setCommand(String buildCommand) {
        if (this.icfg instanceof IMultiConfiguration) {
            IConfiguration[] cfs = (IConfiguration[])((IMultiConfiguration)this.icfg).getItems();
            int i = 0;
            while (i < cfs.length) {
                IBuilder b = cfs[i].getEditableBuilder();
                b.setCommand(buildCommand);
                ++i;
            }
        } else {
            this.icfg.getEditableBuilder().setCommand(buildCommand);
        }
    }

    private void setArguments(String makeArgs) {
        if (this.icfg instanceof IMultiConfiguration) {
            IConfiguration[] cfs = (IConfiguration[])((IMultiConfiguration)this.icfg).getItems();
            int i = 0;
            while (i < cfs.length) {
                IBuilder b = cfs[i].getEditableBuilder();
                b.setArguments(makeArgs);
                ++i;
            }
        } else {
            this.icfg.getEditableBuilder().setArguments(makeArgs);
        }
    }

    private void setBuildPath(String path) {
        if (this.icfg instanceof IMultiConfiguration) {
            IConfiguration[] cfs = (IConfiguration[])((IMultiConfiguration)this.icfg).getItems();
            int i = 0;
            while (i < cfs.length) {
                IBuilder b = cfs[i].getEditableBuilder();
                b.setBuildPath(path);
                ++i;
            }
        } else {
            this.icfg.getEditableBuilder().setBuildPath(path);
        }
    }

    private void setManagedBuildOn(boolean on) {
        try {
            if (this.icfg instanceof IMultiConfiguration) {
                IConfiguration[] cfs = (IConfiguration[])((IMultiConfiguration)this.icfg).getItems();
                int i = 0;
                while (i < cfs.length) {
                    IBuilder b = cfs[i].getEditableBuilder();
                    b.setManagedBuildOn(on);
                    ++i;
                }
            } else {
                this.icfg.getEditableBuilder().setManagedBuildOn(on);
            }
        }
        catch (CoreException e) {
            ManagedBuilderUIPlugin.log(e);
        }
    }
}

