/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.model;

import java.util.Collection;
import org.eclipse.cdt.codan.core.model.AbstractChecker;
import org.eclipse.cdt.codan.core.model.ICheckerWithPreferences;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemLocation;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.core.param.BasicProblemPreference;
import org.eclipse.cdt.codan.core.param.FileScopeProblemPreference;
import org.eclipse.cdt.codan.core.param.IProblemPreference;
import org.eclipse.cdt.codan.core.param.IProblemPreferenceDescriptor;
import org.eclipse.cdt.codan.core.param.LaunchModeProblemPreference;
import org.eclipse.cdt.codan.core.param.ListProblemPreference;
import org.eclipse.cdt.codan.core.param.MapProblemPreference;
import org.eclipse.cdt.codan.core.param.RootProblemPreference;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public abstract class AbstractCheckerWithProblemPreferences
extends AbstractChecker
implements ICheckerWithPreferences {
    public void initPreferences(IProblemWorkingCopy problem) {
        this.getTopLevelPreference(problem);
    }

    public FileScopeProblemPreference getScopePreference(IProblem problem) {
        return this.getTopLevelPreference(problem).getScopePreference();
    }

    public LaunchModeProblemPreference getLaunchModePreference(IProblem problem) {
        return this.getTopLevelPreference(problem).getLaunchModePreference();
    }

    public boolean shouldProduceProblems(IResource res) {
        Collection<IProblem> refProblems = this.getRuntime().getCheckersRegistry().getRefProblems(this);
        for (IProblem checkerProblem : refProblems) {
            if (!this.shouldProduceProblem(this.getProblemById(checkerProblem.getId(), res), res.getLocation())) continue;
            return true;
        }
        return false;
    }

    public boolean shouldProduceProblem(IProblem problem, IPath resource) {
        FileScopeProblemPreference scope = this.getScopePreference(problem);
        if (scope == null) {
            return true;
        }
        return scope.isInScope(resource);
    }

    public void reportProblem(String problemId, IProblemLocation loc, Object ... args) {
        if (this.shouldProduceProblem(this.getProblemById(problemId, loc.getFile()), loc.getFile().getLocation())) {
            super.reportProblem(problemId, loc, args);
        }
    }

    public void reportProblem(IProblem pr, IProblemLocation loc, Object ... args) {
        if (this.shouldProduceProblem(pr, loc.getFile().getLocation())) {
            super.reportProblem(pr.getId(), loc, args);
        }
    }

    public IProblemPreference addPreference(IProblemWorkingCopy problem, String key, String label, Object defaultValue) {
        RootProblemPreference map = this.getTopLevelPreference(problem);
        BasicProblemPreference info = new BasicProblemPreference(key, label, IProblemPreferenceDescriptor.PreferenceType.typeOf(defaultValue));
        map.addChildDescriptor(info);
        this.setDefaultPreferenceValue(problem, key, defaultValue);
        return info;
    }

    public ListProblemPreference addListPreference(IProblemWorkingCopy problem, String key, String label, String itemLabel) {
        RootProblemPreference map = this.getTopLevelPreference(problem);
        ListProblemPreference list = new ListProblemPreference(key, label);
        list.setChildDescriptor(new BasicProblemPreference("#", itemLabel, IProblemPreferenceDescriptor.PreferenceType.TYPE_STRING));
        return (ListProblemPreference)map.addChildDescriptor(list);
    }

    public IProblemPreference addPreference(IProblemWorkingCopy problem, IProblemPreference pref, Object defaultValue) {
        RootProblemPreference map = this.getTopLevelPreference(problem);
        String key = pref.getKey();
        pref = map.addChildDescriptor(pref);
        this.setDefaultPreferenceValue(problem, key, defaultValue);
        return pref;
    }

    protected void setDefaultPreferenceValue(IProblemWorkingCopy problem, String key, Object defaultValue) {
        RootProblemPreference map = this.getTopLevelPreference(problem);
        if (map.getChildValue(key) == null) {
            map.setChildValue(key, defaultValue);
        }
    }

    public RootProblemPreference getTopLevelPreference(IProblem problem) {
        RootProblemPreference map = (RootProblemPreference)problem.getPreference();
        if (map == null) {
            map = new RootProblemPreference();
            if (problem instanceof IProblemWorkingCopy) {
                ((IProblemWorkingCopy)problem).setPreference(map);
            }
        }
        return map;
    }

    public Object getPreference(IProblem problem, String key) {
        return ((MapProblemPreference)problem.getPreference()).getChildValue(key);
    }

    public boolean isFilteredArg(String arg, IProblem problem, String exceptionListParamId) {
        Object[] arr = (Object[])this.getPreference(problem, exceptionListParamId);
        int i = 0;
        while (i < arr.length) {
            String str = (String)arr[i];
            if (arg.equals(str)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

