/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.c.ICASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTBaseDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.c.CCompositeTypeScope;

public class CASTCompositeTypeSpecifier
extends CASTBaseDeclSpecifier
implements ICASTCompositeTypeSpecifier,
IASTAmbiguityParent {
    private int fKey;
    private IASTName fName;
    private IASTDeclaration[] fActiveDeclarations = null;
    private IASTDeclaration[] fAllDeclarations = null;
    private int fDeclarationsPos = -1;
    private IScope fScope = null;

    public CASTCompositeTypeSpecifier() {
    }

    public CASTCompositeTypeSpecifier(int key, IASTName name) {
        this.fKey = key;
        this.setName(name);
    }

    public CASTCompositeTypeSpecifier copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public CASTCompositeTypeSpecifier copy(IASTNode.CopyStyle style) {
        CASTCompositeTypeSpecifier copy = new CASTCompositeTypeSpecifier();
        this.copyCompositeTypeSpecifier(copy, style);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    protected void copyCompositeTypeSpecifier(CASTCompositeTypeSpecifier copy, IASTNode.CopyStyle style) {
        this.copyBaseDeclSpec(copy);
        copy.setKey(this.fKey);
        copy.setName(this.fName == null ? null : this.fName.copy(style));
        IASTDeclaration[] iASTDeclarationArray = this.getMembers();
        int n = iASTDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration member = iASTDeclarationArray[n2];
            copy.addMemberDeclaration(member == null ? null : member.copy(style));
            ++n2;
        }
    }

    public int getKey() {
        return this.fKey;
    }

    public void setKey(int key) {
        this.assertNotFrozen();
        this.fKey = key;
    }

    public IASTName getName() {
        return this.fName;
    }

    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.fName = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(TYPE_NAME);
        }
    }

    public IASTDeclaration[] getMembers() {
        IASTDeclaration[] active = this.fActiveDeclarations;
        if (active == null) {
            active = ASTQueries.extractActiveDeclarations(this.fAllDeclarations, this.fDeclarationsPos + 1);
            this.fActiveDeclarations = active;
        }
        return active;
    }

    public final IASTDeclaration[] getDeclarations(boolean includeInactive) {
        if (includeInactive) {
            this.fAllDeclarations = (IASTDeclaration[])ArrayUtil.removeNullsAfter(IASTDeclaration.class, this.fAllDeclarations, this.fDeclarationsPos);
            return this.fAllDeclarations;
        }
        return this.getMembers();
    }

    public void addMemberDeclaration(IASTDeclaration declaration) {
        this.assertNotFrozen();
        if (declaration != null) {
            declaration.setParent(this);
            declaration.setPropertyInParent(MEMBER_DECLARATION);
            this.fAllDeclarations = (IASTDeclaration[])ArrayUtil.append(IASTDeclaration.class, this.fAllDeclarations, ++this.fDeclarationsPos, declaration);
            this.fActiveDeclarations = null;
        }
    }

    public void addDeclaration(IASTDeclaration declaration) {
        this.addMemberDeclaration(declaration);
    }

    public IScope getScope() {
        if (this.fScope == null) {
            this.fScope = new CCompositeTypeScope(this);
        }
        return this.fScope;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fName != null && !this.fName.accept(action)) {
            return false;
        }
        IASTDeclaration[] decls = this.getDeclarations(action.includeInactiveNodes);
        int i = 0;
        while (i < decls.length) {
            if (!decls[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public int getRoleForName(IASTName n) {
        if (n == this.fName) {
            return 2;
        }
        return 3;
    }

    public void replace(IASTNode child, IASTNode other) {
        assert (child.isActive() == other.isActive());
        int i = 0;
        while (i <= this.fDeclarationsPos) {
            if (this.fAllDeclarations[i] == child) {
                other.setParent(child.getParent());
                other.setPropertyInParent(child.getPropertyInParent());
                this.fAllDeclarations[i] = (IASTDeclaration)other;
                this.fActiveDeclarations = null;
                return;
            }
            ++i;
        }
    }
}

