/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.c.ICASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTEnumerationSpecifier;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.c.CEnumerator;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.cdt.internal.core.dom.parser.c.ICInternalBinding;
import org.eclipse.core.runtime.PlatformObject;

public class CEnumeration
extends PlatformObject
implements IEnumeration,
ICInternalBinding {
    private IASTName[] declarations = null;
    private IASTName definition = null;
    private Long fMinValue;
    private Long fMaxValue;

    public CEnumeration(IASTName enumeration) {
        ASTNodeProperty prop = enumeration.getPropertyInParent();
        if (prop == IASTElaboratedTypeSpecifier.TYPE_NAME) {
            this.declarations = new IASTName[]{enumeration};
        } else {
            this.definition = enumeration;
        }
        enumeration.setBinding(this);
    }

    public void addDeclaration(IASTName decl) {
        if (!decl.isActive()) {
            return;
        }
        if (decl.getPropertyInParent() != IASTElaboratedTypeSpecifier.TYPE_NAME) {
            return;
        }
        decl.setBinding(this);
        if (this.declarations == null) {
            this.declarations = new IASTName[]{decl};
            return;
        }
        int i = 0;
        while (i < this.declarations.length) {
            if (this.declarations[i] == null) {
                this.declarations[i] = decl;
                return;
            }
            ++i;
        }
        IASTName[] tmp = new IASTName[this.declarations.length * 2];
        System.arraycopy(this.declarations, 0, tmp, 0, this.declarations.length);
        tmp[this.declarations.length] = decl;
        this.declarations = tmp;
    }

    public IASTNode getPhysicalNode() {
        if (this.definition != null) {
            return this.definition;
        }
        return this.declarations[0];
    }

    private void checkForDefinition() {
        IASTDeclSpecifier spec = CVisitor.findDefinition((ICASTElaboratedTypeSpecifier)this.declarations[0].getParent());
        if (spec != null && spec instanceof ICASTEnumerationSpecifier) {
            ICASTEnumerationSpecifier enumSpec = (ICASTEnumerationSpecifier)spec;
            enumSpec.getName().setBinding(this);
            this.definition = enumSpec.getName();
        }
    }

    public String getName() {
        if (this.definition != null) {
            return this.definition.toString();
        }
        return this.declarations[0].toString();
    }

    public char[] getNameCharArray() {
        if (this.definition != null) {
            return this.definition.toCharArray();
        }
        return this.declarations[0].toCharArray();
    }

    public IScope getScope() {
        return CVisitor.getContainingScope(this.definition != null ? this.definition : this.declarations[0].getParent());
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    public IEnumerator[] getEnumerators() {
        if (this.definition == null) {
            this.checkForDefinition();
            if (this.definition == null) {
                return new IEnumerator[]{new CEnumerator.CEnumeratorProblem((IASTNode)this.declarations[0], 7, this.declarations[0].toCharArray())};
            }
        }
        IASTEnumerationSpecifier enumSpec = (IASTEnumerationSpecifier)this.definition.getParent();
        IASTEnumerationSpecifier.IASTEnumerator[] enums = enumSpec.getEnumerators();
        IEnumerator[] bindings = new IEnumerator[enums.length];
        int i = 0;
        while (i < enums.length) {
            bindings[i] = (IEnumerator)enums[i].getName().resolveBinding();
            ++i;
        }
        return bindings;
    }

    public void addDefinition(IASTName name) {
        if (name.isActive()) {
            this.definition = name;
        }
    }

    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef || type instanceof IIndexBinding) {
            return type.isSameType(this);
        }
        return false;
    }

    public ILinkage getLinkage() {
        return Linkage.C_LINKAGE;
    }

    public IASTNode[] getDeclarations() {
        return this.declarations;
    }

    public IASTNode getDefinition() {
        return this.definition;
    }

    public IBinding getOwner() {
        IASTName node = this.definition;
        if (node == null && this.declarations != null && this.declarations.length > 0) {
            node = this.declarations[0];
        }
        return CVisitor.findEnclosingFunction(node);
    }

    public String toString() {
        return this.getName();
    }

    public long getMinValue() {
        IEnumerator[] enumerators;
        if (this.fMinValue != null) {
            return this.fMinValue;
        }
        long minValue = Long.MAX_VALUE;
        IEnumerator[] iEnumeratorArray = enumerators = this.getEnumerators();
        int n = enumerators.length;
        int n2 = 0;
        while (n2 < n) {
            long v;
            Long val;
            IEnumerator enumerator = iEnumeratorArray[n2];
            IValue value = enumerator.getValue();
            if (value != null && (val = value.numericalValue()) != null && (v = val.longValue()) < minValue) {
                minValue = v;
            }
            ++n2;
        }
        this.fMinValue = minValue;
        return minValue;
    }

    public long getMaxValue() {
        IEnumerator[] enumerators;
        if (this.fMaxValue != null) {
            return this.fMaxValue;
        }
        long maxValue = Long.MIN_VALUE;
        IEnumerator[] iEnumeratorArray = enumerators = this.getEnumerators();
        int n = enumerators.length;
        int n2 = 0;
        while (n2 < n) {
            long v;
            Long val;
            IEnumerator enumerator = iEnumeratorArray[n2];
            IValue value = enumerator.getValue();
            if (value != null && (val = value.numericalValue()) != null && (v = val.longValue()) > maxValue) {
                maxValue = v;
            }
            ++n2;
        }
        this.fMaxValue = maxValue;
        return maxValue;
    }
}

