/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.ExpansionOverlapsBoundaryException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpressionList;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTExpressionList;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.LookupData;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPASTFunctionCallExpression
extends ASTNode
implements ICPPASTFunctionCallExpression,
IASTAmbiguityParent {
    private IASTExpression functionName;
    private IASTInitializerClause[] fArguments;
    private IASTImplicitName[] implicitNames;
    private ICPPFunction overload = UNINITIALIZED_FUNCTION;

    public CPPASTFunctionCallExpression() {
        this.setArguments(null);
    }

    public CPPASTFunctionCallExpression(IASTExpression functionName, IASTInitializerClause[] args) {
        this.setFunctionNameExpression(functionName);
        this.setArguments(args);
    }

    public CPPASTFunctionCallExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public CPPASTFunctionCallExpression copy(IASTNode.CopyStyle style) {
        IASTInitializerClause[] args = null;
        if (this.fArguments.length > 0) {
            args = new IASTInitializerClause[this.fArguments.length];
            int i = 0;
            while (i < this.fArguments.length) {
                args[i] = this.fArguments[i].copy(style);
                ++i;
            }
        }
        CPPASTFunctionCallExpression copy = new CPPASTFunctionCallExpression(null, args);
        copy.setFunctionNameExpression(this.functionName == null ? null : this.functionName.copy(style));
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    public IASTExpression getFunctionNameExpression() {
        return this.functionName;
    }

    public void setFunctionNameExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.functionName = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(FUNCTION_NAME);
        }
    }

    public IASTInitializerClause[] getArguments() {
        return this.fArguments;
    }

    public void setArguments(IASTInitializerClause[] arguments) {
        this.assertNotFrozen();
        if (arguments == null) {
            this.fArguments = IASTExpression.EMPTY_EXPRESSION_ARRAY;
        } else {
            this.fArguments = arguments;
            IASTInitializerClause[] iASTInitializerClauseArray = arguments;
            int n = arguments.length;
            int n2 = 0;
            while (n2 < n) {
                IASTInitializerClause arg = iASTInitializerClauseArray[n2];
                arg.setParent(this);
                arg.setPropertyInParent(ARGUMENT);
                ++n2;
            }
        }
    }

    public IASTImplicitName[] getImplicitNames() {
        if (this.implicitNames == null) {
            CPPASTImplicitName n2;
            CPPASTImplicitName n1;
            block11: {
                ICPPFunction overload = this.getOperator();
                if (overload == null) {
                    this.implicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
                    return IASTImplicitName.EMPTY_NAME_ARRAY;
                }
                if (this.isExplicitTypeConversion() != null) {
                    CPPASTImplicitName n12 = new CPPASTImplicitName(overload.getNameCharArray(), (IASTNode)this);
                    n12.setOffsetAndLength((ASTNode)((Object)this.functionName));
                    n12.setBinding(overload);
                    this.implicitNames = new IASTImplicitName[]{n12};
                    return this.implicitNames;
                }
                if (overload instanceof CPPImplicitFunction && (!(overload instanceof ICPPMethod) || ((ICPPMethod)overload).isImplicit())) {
                    this.implicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
                    return IASTImplicitName.EMPTY_NAME_ARRAY;
                }
                n1 = new CPPASTImplicitName(OverloadableOperator.PAREN, (IASTNode)this);
                n1.setBinding(overload);
                n2 = new CPPASTImplicitName(OverloadableOperator.PAREN, (IASTNode)this);
                n2.setBinding(overload);
                n2.setAlternate(true);
                if (this.fArguments.length == 0) {
                    int idEndOffset = ((ASTNode)((Object)this.functionName)).getOffset() + ((ASTNode)((Object)this.functionName)).getLength();
                    try {
                        IToken lparen = this.functionName.getTrailingSyntax();
                        IToken rparen = lparen.getNext();
                        if (lparen.getType() == 8) {
                            n1.setOffsetAndLength(idEndOffset + lparen.getOffset(), 1);
                        } else {
                            n1.setOffsetAndLength(idEndOffset + lparen.getEndOffset(), 0);
                        }
                        if (rparen.getType() == 9) {
                            n2.setOffsetAndLength(idEndOffset + rparen.getOffset(), 1);
                            break block11;
                        }
                        n2.setOffsetAndLength(idEndOffset + rparen.getEndOffset(), 0);
                    }
                    catch (ExpansionOverlapsBoundaryException expansionOverlapsBoundaryException) {
                        n1.setOffsetAndLength(idEndOffset, 0);
                        n2.setOffsetAndLength(idEndOffset, 0);
                    }
                } else {
                    n1.computeOperatorOffsets(this.functionName, true);
                    n2.computeOperatorOffsets(this.fArguments[this.fArguments.length - 1], true);
                }
            }
            this.implicitNames = new IASTImplicitName[]{n1, n2};
        }
        return this.implicitNames;
    }

    public boolean accept(ASTVisitor action) {
        IASTImplicitName[] implicits;
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.functionName != null && !this.functionName.accept(action)) {
            return false;
        }
        IASTImplicitName[] iASTImplicitNameArray = implicits = action.shouldVisitImplicitNames ? this.getImplicitNames() : null;
        if (implicits != null && implicits.length > 0 && !implicits[0].accept(action)) {
            return false;
        }
        IASTInitializerClause[] iASTInitializerClauseArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            IASTInitializerClause arg = iASTInitializerClauseArray[n2];
            if (!arg.accept(action)) {
                return false;
            }
            ++n2;
        }
        if (implicits != null && implicits.length > 1 && !implicits[1].accept(action)) {
            return false;
        }
        return !action.shouldVisitExpressions || action.leave(this) != 2;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.functionName) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.functionName = (IASTExpression)other;
        }
        int i = 0;
        while (i < this.fArguments.length) {
            if (child == this.fArguments[i]) {
                other.setPropertyInParent(child.getPropertyInParent());
                other.setParent(child.getParent());
                this.fArguments[i] = (IASTExpression)other;
            }
            ++i;
        }
    }

    public ICPPFunction getOperator() {
        if (this.overload == UNINITIALIZED_FUNCTION) {
            this.overload = null;
            IType t = this.isExplicitTypeConversion();
            if (t != null) {
                if ((t = SemanticUtil.getNestedType(t, 7)) instanceof ICPPClassType && !(t instanceof ICPPUnknownBinding)) {
                    ICPPClassType cls = (ICPPClassType)t;
                    LookupData data = CPPSemantics.createLookupData(((IASTIdExpression)this.functionName).getName());
                    try {
                        IBinding b = CPPSemantics.resolveFunction(data, cls.getConstructors(), true);
                        if (b instanceof ICPPFunction) {
                            this.overload = (ICPPFunction)b;
                        }
                    }
                    catch (DOMException dOMException) {}
                }
            } else {
                t = SemanticUtil.getNestedType(this.functionName.getExpressionType(), 7);
                if (t instanceof ICPPClassType) {
                    this.overload = CPPSemantics.findOverloadedOperator(this, (ICPPClassType)t);
                }
            }
        }
        return this.overload;
    }

    public IType getExpressionType() {
        IType t = this.isExplicitTypeConversion();
        if (t != null) {
            if (t instanceof IProblemBinding) {
                return ProblemType.UNRESOLVED_NAME;
            }
            return ExpressionTypes.prvalueType(t);
        }
        t = SemanticUtil.getNestedType(this.functionName.getExpressionType(), 7);
        if (t instanceof ICPPClassType) {
            if (this.overload == UNINITIALIZED_FUNCTION) {
                this.overload = CPPSemantics.findOverloadedOperator(this, (ICPPClassType)t);
            }
            if (this.overload != null) {
                return ExpressionTypes.typeFromFunctionCall(this.overload);
            }
            return new ProblemType(10004);
        }
        if (t instanceof IPointerType) {
            t = SemanticUtil.getNestedType(((IPointerType)t).getType(), 7);
        }
        if (t instanceof IFunctionType) {
            return ExpressionTypes.typeFromReturnType(((IFunctionType)t).getReturnType());
        }
        if (CPPTemplates.isDependentType(t)) {
            return CPPUnknownClass.createUnnamedInstance();
        }
        return new ProblemType(10004);
    }

    private IType isExplicitTypeConversion() {
        IASTName name;
        IBinding b;
        if (this.functionName instanceof IASTIdExpression && (b = (name = ((IASTIdExpression)this.functionName).getName()).resolvePreBinding()) instanceof IType) {
            return (IType)((Object)b);
        }
        return null;
    }

    public boolean isLValue() {
        return this.getValueCategory() == IASTExpression.ValueCategory.LVALUE;
    }

    public IASTExpression.ValueCategory getValueCategory() {
        if (this.isExplicitTypeConversion() != null) {
            return IASTExpression.ValueCategory.PRVALUE;
        }
        IType t = this.functionName.getExpressionType();
        if (t instanceof ICPPClassType) {
            if (this.overload == UNINITIALIZED_FUNCTION) {
                this.overload = CPPSemantics.findOverloadedOperator(this, (ICPPClassType)t);
            }
            if (this.overload != null) {
                return ExpressionTypes.valueCategoryFromFunctionCall(this.overload);
            }
        } else {
            if (t instanceof IPointerType) {
                t = SemanticUtil.getNestedType(((IPointerType)t).getType(), 7);
            }
            if (t instanceof IFunctionType) {
                return ExpressionTypes.valueCategoryFromReturnType(((IFunctionType)t).getReturnType());
            }
        }
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Deprecated
    public IASTExpression getParameterExpression() {
        if (this.fArguments.length == 0) {
            return null;
        }
        if (this.fArguments.length == 1) {
            IASTInitializerClause arg = this.fArguments[0];
            if (arg instanceof IASTExpression) {
                return (IASTExpression)arg;
            }
            return null;
        }
        CPPASTExpressionList result = new CPPASTExpressionList();
        IASTInitializerClause[] iASTInitializerClauseArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            IASTInitializerClause arg = iASTInitializerClauseArray[n2];
            if (arg instanceof IASTExpression) {
                result.addExpression(((IASTExpression)arg).copy());
            }
            ++n2;
        }
        result.setParent(this);
        result.setPropertyInParent(ARGUMENT);
        return result;
    }

    @Deprecated
    public void setParameterExpression(IASTExpression expression) {
        this.assertNotFrozen();
        if (expression == null) {
            this.setArguments(null);
        } else if (expression instanceof ICPPASTExpressionList) {
            this.setArguments(((ICPPASTExpressionList)expression).getExpressions());
        } else {
            this.setArguments(new IASTExpression[]{expression});
        }
    }
}

