/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.ISemanticProblem;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPArithmeticConversion;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPASTUnaryExpression
extends ASTNode
implements ICPPASTUnaryExpression,
IASTAmbiguityParent {
    private int op;
    private IASTExpression operand;
    private ICPPFunction overload = UNINITIALIZED_FUNCTION;
    private IASTImplicitName[] implicitNames = null;

    public CPPASTUnaryExpression() {
    }

    public CPPASTUnaryExpression(int operator, IASTExpression operand) {
        this.op = operator;
        this.setOperand(operand);
    }

    public CPPASTUnaryExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public CPPASTUnaryExpression copy(IASTNode.CopyStyle style) {
        CPPASTUnaryExpression copy = new CPPASTUnaryExpression(this.op, this.operand == null ? null : this.operand.copy(style));
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    public int getOperator() {
        return this.op;
    }

    public void setOperator(int operator) {
        this.assertNotFrozen();
        this.op = operator;
    }

    public IASTExpression getOperand() {
        return this.operand;
    }

    public void setOperand(IASTExpression expression) {
        this.assertNotFrozen();
        this.operand = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(OPERAND);
        }
    }

    public boolean isPostfixOperator() {
        return this.op == 10 || this.op == 9;
    }

    public IASTImplicitName[] getImplicitNames() {
        if (this.implicitNames == null) {
            ICPPFunction overload = this.getOverload();
            if (overload == null || overload instanceof CPPImplicitFunction) {
                this.implicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
            } else {
                CPPASTImplicitName operatorName = new CPPASTImplicitName(overload.getNameCharArray(), (IASTNode)this);
                operatorName.setOperator(true);
                operatorName.setBinding(overload);
                operatorName.computeOperatorOffsets(this.operand, this.isPostfixOperator());
                this.implicitNames = new IASTImplicitName[]{operatorName};
            }
        }
        return this.implicitNames;
    }

    public boolean accept(ASTVisitor action) {
        IASTImplicitName name;
        int n;
        int n2;
        IASTImplicitName[] iASTImplicitNameArray;
        boolean isPostfix;
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!(isPostfix = this.isPostfixOperator()) && action.shouldVisitImplicitNames) {
            iASTImplicitNameArray = this.getImplicitNames();
            n2 = iASTImplicitNameArray.length;
            n = 0;
            while (n < n2) {
                name = iASTImplicitNameArray[n];
                if (!name.accept(action)) {
                    return false;
                }
                ++n;
            }
        }
        if (this.operand != null && !this.operand.accept(action)) {
            return false;
        }
        if (isPostfix && action.shouldVisitImplicitNames) {
            iASTImplicitNameArray = this.getImplicitNames();
            n2 = iASTImplicitNameArray.length;
            n = 0;
            while (n < n2) {
                name = iASTImplicitNameArray[n];
                if (!name.accept(action)) {
                    return false;
                }
                ++n;
            }
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.operand) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.operand = (IASTExpression)other;
        }
    }

    public ICPPFunction getOverload() {
        if (this.overload != UNINITIALIZED_FUNCTION) {
            return this.overload;
        }
        this.overload = CPPSemantics.findOverloadedOperator(this);
        if (this.overload != null && this.op == 5 && this.computePointerToMemberType() instanceof CPPPointerToMemberType) {
            this.overload = null;
        }
        return this.overload;
    }

    private IType computePointerToMemberType() {
        IASTName name;
        IBinding b;
        IASTExpression child = this.operand;
        boolean inParenthesis = false;
        while (child instanceof IASTUnaryExpression && ((IASTUnaryExpression)child).getOperator() == 11) {
            child = ((IASTUnaryExpression)child).getOperand();
            inParenthesis = true;
        }
        if (child instanceof IASTIdExpression && (b = (name = ((IASTIdExpression)child).getName()).resolveBinding()) instanceof ICPPMember) {
            ICPPMember member = (ICPPMember)b;
            try {
                if (name instanceof ICPPASTQualifiedName && !member.isStatic()) {
                    this.overload = null;
                    if (!inParenthesis) {
                        return new CPPPointerToMemberType(member.getType(), member.getClassOwner(), false, false, false);
                    }
                    if (member instanceof IFunction) {
                        return new ProblemBinding(this.operand, 5, this.operand.getRawSignature().toCharArray());
                    }
                }
            }
            catch (DOMException e) {
                return e.getProblem();
            }
        }
        return null;
    }

    public IType getExpressionType() {
        int op = this.getOperator();
        switch (op) {
            case 8: 
            case 16: {
                return CPPVisitor.get_SIZE_T(this);
            }
            case 13: {
                return CPPVisitor.get_type_info(this);
            }
            case 11: {
                return this.getOperand().getExpressionType();
            }
            case 12: {
                return CPPSemantics.VOID_TYPE;
            }
        }
        IASTExpression operand = this.getOperand();
        if (op == 5) {
            IType ptm = this.computePointerToMemberType();
            if (ptm != null) {
                return ptm;
            }
            ICPPFunction overload = this.getOverload();
            if (overload != null) {
                return ExpressionTypes.typeFromFunctionCall(overload);
            }
            return new CPPPointerType(operand.getExpressionType());
        }
        ICPPFunction overload = this.getOverload();
        if (overload != null) {
            return ExpressionTypes.typeFromFunctionCall(overload);
        }
        if (op == 4) {
            IType type = operand.getExpressionType();
            if ((type = SemanticUtil.getNestedType(type, 7)) instanceof ISemanticProblem) {
                return type;
            }
            if (type instanceof IPointerType || type instanceof IArrayType) {
                type = ((ITypeContainer)type).getType();
                return ExpressionTypes.glvalueType(type);
            }
            if (type instanceof ICPPUnknownType) {
                return CPPUnknownClass.createUnnamedInstance();
            }
            return new ProblemType(10004);
        }
        IType typeOfOperand = operand.getExpressionType();
        switch (op) {
            case 7: {
                return CPPBasicType.BOOLEAN;
            }
            case 9: 
            case 10: {
                typeOfOperand = ExpressionTypes.prvalueType(typeOfOperand);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                IType t = CPPArithmeticConversion.promoteCppType(ExpressionTypes.prvalueType(typeOfOperand));
                if (t == null) break;
                return t;
            }
        }
        if (typeOfOperand instanceof CPPBasicType) {
            ((CPPBasicType)typeOfOperand).setFromExpression(this);
        }
        return typeOfOperand;
    }

    public IASTExpression.ValueCategory getValueCategory() {
        int op = this.getOperator();
        switch (op) {
            case 13: {
                return IASTExpression.ValueCategory.LVALUE;
            }
            case 8: 
            case 16: {
                return IASTExpression.ValueCategory.PRVALUE;
            }
            case 11: {
                return this.operand.getValueCategory();
            }
        }
        if (op == 5 && this.computePointerToMemberType() != null) {
            return IASTExpression.ValueCategory.PRVALUE;
        }
        ICPPFunction overload = this.getOverload();
        if (overload != null) {
            return ExpressionTypes.valueCategoryFromFunctionCall(overload);
        }
        switch (op) {
            case 0: 
            case 1: 
            case 4: {
                return IASTExpression.ValueCategory.LVALUE;
            }
        }
        return IASTExpression.ValueCategory.PRVALUE;
    }

    public boolean isLValue() {
        return this.getValueCategory() == IASTExpression.ValueCategory.LVALUE;
    }
}

